/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.cropToValidData;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CropToValidDataAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String INPUT = "INPUT";
    private IRasterLayer m_Window;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Crop_to_valid_data_cells"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer_to_crop"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Cropped_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Window.setFullExtent();
        AnalysisExtent extent = this.getAdjustedGridExtent(this.m_Window);
        this.m_Window.setWindowExtent(extent);
        IRasterLayer output = this.getNewRasterLayer(RESULT, this.m_Window.getName() + Sextante.getText((String)"[cropped]"), this.m_Window.getDataType(), extent);
        output.setNoDataValue(this.m_Window.getNoDataValue());
        int iNX = extent.getNX();
        int iNY = extent.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                output.setCellValue(x, y, this.m_Window.getCellValueAsDouble(x, y));
            }
        }
        return !this.m_Task.isCanceled();
    }

    private AnalysisExtent getAdjustedGridExtent(IRasterLayer input) {
        AnalysisExtent ge = new AnalysisExtent();
        double dMinX = input.getWindowGridExtent().getXMin();
        double dMaxY = input.getWindowGridExtent().getYMax();
        double dCellSize = input.getWindowGridExtent().getCellSize();
        int iNX = input.getWindowGridExtent().getNX();
        int iNY = input.getWindowGridExtent().getNY();
        double iMinX = iNX;
        double iMinY = iNY;
        double iMaxX = 0.0;
        double iMaxY = 0.0;
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue)) continue;
                if ((double)x < iMinX) {
                    iMinX = x;
                }
                if ((double)x > iMaxX) {
                    iMaxX = x;
                }
                if ((double)y < iMinY) {
                    iMinY = y;
                }
                if (!((double)y > iMaxY)) continue;
                iMaxY = y;
            }
        }
        double dMinX2 = dMinX + iMinX * dCellSize;
        double dMinY2 = dMaxY - iMaxY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMaxY - iMinY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2, true);
        ge.setYRange(dMinY2, dMaxY2, true);
        return ge;
    }
}

