/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.gridCompletion;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GridCompletionAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String ADDITIONAL = "ADDITIONAL";
    public static final String METHOD = "METHOD";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Nearest_neighbour"), Sextante.getText((String)"Bilinear"), Sextante.getText((String)"Inverse_distance"), Sextante.getText((String)"Cubic_spline"), Sextante.getText((String)"B-spline")};
        this.setName(Sextante.getText((String)"Complete_grid"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Base_layer"), true);
            this.m_Parameters.addInputRasterLayer(ADDITIONAL, Sextante.getText((String)"Additional_layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Interpolation_method"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Filled_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dValue = 0.0;
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer window2 = this.m_Parameters.getParameterValueAsRasterLayer(ADDITIONAL);
        IRasterLayer result = this.getNewRasterLayer(RESULT, window.getName() + Sextante.getText((String)"[completed]"), window.getDataType());
        window.setWindowExtent(result.getWindowGridExtent());
        window.setInterpolationMethod(iMethod);
        window2.setWindowExtent(result.getWindowGridExtent());
        window.setInterpolationMethod(iMethod);
        int iNX = window.getNX();
        int iNY = window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                dValue = window.getCellValueAsDouble(x, y);
                if (window.isNoDataValue(dValue)) {
                    dValue = window2.getCellValueAsDouble(x, y);
                    if (window2.isNoDataValue(dValue)) {
                        result.setNoData(x, y);
                        continue;
                    }
                    result.setCellValue(x, y, dValue);
                    continue;
                }
                result.setCellValue(x, y, dValue);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

