/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.kernelDensity;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;

public class KernelDensityAlgorithm
extends GeoAlgorithm {
    public static final String DENSITY = "DENSITY";
    public static final String DISTANCE = "DISTANCE";
    public static final String FIELD = "FIELD";
    public static final String LAYER = "LAYER";
    private int m_iField;
    private IVectorLayer m_Layer;
    private IRasterLayer m_Result;
    private AnalysisExtent m_Extent;
    private int m_iDistance;
    private double[][] m_dWeight;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Density__kernel"));
        this.setGroup(Sextante.getText((String)"Rasterization_and_interpolation"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Vector_layer"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Search_radius"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(DENSITY, Sextante.getText((String)"Density"));
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        double dDistance = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
        this.m_Result = this.getNewRasterLayer(DENSITY, this.m_Layer.getName() + Sextante.getText((String)"[density]"), 5);
        this.m_Result.assign(0.0);
        this.m_Extent = this.m_Result.getWindowGridExtent();
        this.m_iDistance = (int)Math.floor(dDistance / this.m_Extent.getCellSize());
        double dXMin = this.m_Extent.getXMin() - dDistance;
        double dYMin = this.m_Extent.getYMin() - dDistance;
        double dXMax = this.m_Extent.getXMax() + dDistance;
        double dYMax = this.m_Extent.getYMax() + dDistance;
        this.m_dWeight = new double[2 * this.m_iDistance + 1][2 * this.m_iDistance + 1];
        for (int y = -this.m_iDistance; y < this.m_iDistance + 1; ++y) {
            for (int x = -this.m_iDistance; x < this.m_iDistance + 1; ++x) {
                double dDist = Math.sqrt(x * x + y * y);
                this.m_dWeight[x + this.m_iDistance][y + this.m_iDistance] = dDist < (double)this.m_iDistance ? Math.pow(1.0 - dDist * dDist / (double)(this.m_iDistance * this.m_iDistance), 2.0) : 0.0;
            }
        }
        int i = 0;
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            double dValue;
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            try {
                dValue = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
            }
            catch (Exception e) {
                dValue = 1.0;
            }
            if (coord.x > dXMin && coord.x < dXMax && coord.y > dYMin && coord.y < dYMax) {
                this.doPoint(coord, dValue);
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void doPoint(Coordinate coord, double dValue) {
        GridCell cell = this.m_Extent.getGridCoordsFromWorldCoords(coord.x, coord.y);
        int iX = cell.getX();
        int iY = cell.getY();
        for (int y = -this.m_iDistance; y < this.m_iDistance + 1; ++y) {
            for (int x = -this.m_iDistance; x < this.m_iDistance + 1; ++x) {
                if (this.m_dWeight[x + this.m_iDistance][y + this.m_iDistance] == 0.0) continue;
                this.m_Result.addToCellValue(iX + x, iY + y, dValue * this.m_dWeight[x + this.m_iDistance][y + this.m_iDistance]);
            }
        }
    }
}

