/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.sortRaster;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.Arrays;

public class SortRasterAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Sort"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Sorted_raster_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer layer = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        layer.setFullExtent();
        GridCell[] cells = this.getSortedArrayOfCells(layer);
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)layer);
        IRasterLayer sorted = this.getNewRasterLayer(RESULT, layer.getName() + Sextante.getText((String)"[sorted]"), 3, gridExtent);
        int iCells = layer.getNX() * layer.getNY();
        for (int i = 0; i < iCells && this.setProgress(i, iCells); ++i) {
            GridCell cell = cells[i];
            if (!layer.isNoDataValue(cell.getValue())) {
                sorted.setCellValue(cell.getX(), cell.getY(), (double)i);
                continue;
            }
            sorted.setNoData(cell.getX(), cell.getY());
        }
        return !this.m_Task.isCanceled();
    }

    public GridCell[] getSortedArrayOfCells(IRasterLayer layer) {
        int iNX = layer.getNX();
        int iCells = layer.getNX() * layer.getNY();
        Object[] cells = new GridCell[iCells];
        for (int i = 0; i < iCells; ++i) {
            int iX = i % iNX;
            int iY = i / iNX;
            GridCell cell = new GridCell(iX, iY, layer.getCellValueAsDouble(iX, iY));
            cells[i] = cell;
        }
        Arrays.sort(cells);
        return cells;
    }
}

