/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.createExclusionAreas;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CreateExclusionAreasAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String RESULT = "RESULT";
    public static final String OUTLET_POINT = "OUTLET_POINT";
    public static final String INPUT = "INPUT";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Grid;
    boolean[][] m_IsCellAlreadyVisited;
    private IRasterLayer m_ExclusionAreas;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"CreateExclusionAreas"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addPoint(OUTLET_POINT, Sextante.getText((String)"Outlet_point"));
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Grid.setFullExtent();
        this.m_Grid.setInterpolationMethod(0);
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        this.m_IsCellAlreadyVisited = new boolean[this.m_iNX][this.m_iNY];
        this.m_ExclusionAreas = this.getNewRasterLayer(RESULT, Sextante.getText((String)"ExclusionAreas"), 3, this.m_Grid.getLayerGridExtent());
        this.m_ExclusionAreas.assign(this.m_Grid);
        this.m_ExclusionAreas.setNoDataValue(0.0);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(OUTLET_POINT);
        GridCell cell = this.m_Grid.getLayerGridExtent().getGridCoordsFromWorldCoords(pt);
        this.exclude(cell.getX(), cell.getY());
        this.m_ExclusionAreas.setNoData(cell.getX(), cell.getY());
        return !this.m_Task.isCanceled();
    }

    private void exclude(int x, int y) {
        double dArea = 0.0;
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Grid.getCellValueAsInt(x, y);
        centralPoints.add(new Point(x, y));
        this.m_IsCellAlreadyVisited[x][y] = true;
        while (centralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                dArea += this.m_Grid.getWindowCellSize() * this.m_Grid.getWindowCellSize();
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                double dClass = this.m_Grid.getCellValueAsInt(x, y);
                if (this.m_Grid.isNoDataValue(dClass)) continue;
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    dClass = this.m_Grid.getCellValueAsDouble(x2, y2);
                    if (this.m_Grid.isNoDataValue(dClass)) continue;
                    int iClass = (int)dClass;
                    if (this.m_IsCellAlreadyVisited[x2][y2] || iInitClass != iClass) continue;
                    this.m_IsCellAlreadyVisited[x2][y2] = true;
                    adjPoints.add(new Point(x2, y2));
                    this.m_ExclusionAreas.setNoData(x2, y2);
                }
            }
            centralPoints = adjPoints;
            System.out.println(centralPoints.size());
            adjPoints = new ArrayList();
        }
        this.m_ExclusionAreas.setNoData(x, y);
    }
}

