/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.texture.quantization;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class QuantizationAlgorithm
extends GeoAlgorithm {
    public static final String GRID = "GRID";
    public static final String RESULT = "RESULT";
    private static final double CLASSES = 15.0;
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Grid = null;
    private IRasterLayer m_Result;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Grid.getName() + Sextante.getText((String)"[4 bits]"), 0);
        this.m_Result.setNoDataValue(-1.0);
        this.m_Grid.setWindowExtent(this.getAnalysisExtent());
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        return this.normalize();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Quantization_[4_bits]"));
        this.setGroup(Sextante.getText((String)"Image_processing"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Image"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean normalize() throws GeoAlgorithmExecutionException {
        double dValue1 = 0.0;
        double dValue2 = 0.0;
        dValue1 = this.m_Grid.getMinValue();
        dValue2 = this.m_Grid.getMaxValue() - dValue1;
        if (dValue2 == 0.0) {
            this.m_Result.assign(1.0);
            return true;
        }
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double z = this.m_Grid.getCellValueAsDouble(x, y);
                if (!this.m_Grid.isNoDataValue(z)) {
                    this.m_Result.setCellValue(x, y, Math.floor((z - dValue1) / dValue2) * 15.0);
                    continue;
                }
                this.m_Result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

