/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.vectorizeTrees;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.imageAnalysis.vectorizeTrees.Tree;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.parameters.RasterLayerAndBand;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public class VectorizeTreesAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String INPUT = "INPUT";
    public static final String POLYGONS = "POLYGONS";
    public static final String TOLERANCE_SPECTRAL = "TOLERANCE_SPECTRAL";
    public static final String TOLERANCE_SIZE = "TOLERANCE_SIZE";
    public static final String MINSIZE = "MINSIZE";
    public static final String MAXSIZE = "MAXSIZE";
    public static final String TREES = "TREES";
    private static final int ANALIZED = 2;
    private int m_iMinX;
    private int m_iMinY;
    private IRasterLayer[] m_Window;
    private IRasterLayer m_BinaryImage;
    private ArrayList m_Bands;
    private IVectorLayer m_Polygons;
    private ArrayList m_Stats;
    private SimpleStats m_SizeStats;
    private IVectorLayer m_Trees;
    private ArrayList m_TreesArray;
    private double m_dTolerance;
    private double m_dToleranceSize;
    private double m_dMinSize;
    private double m_dMaxSize;
    private GeometryFactory m_GeometryFactory;
    private int[] m_iBand;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Detect_and_vectorize_individual_trees"));
        this.setGroup(Sextante.getText((String)"Image_processing"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Bands"), 7, true);
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Sample_trees"), 2, true);
            this.m_Parameters.addNumericalValue(TOLERANCE_SPECTRAL, Sextante.getText((String)"Tolerance"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(TOLERANCE_SIZE, Sextante.getText((String)"Tolerance_[size]"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(TREES, Sextante.getText((String)"Trees"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_GeometryFactory = new GeometryFactory();
        this.m_Bands = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE_SPECTRAL);
        this.m_dToleranceSize = this.m_Parameters.getParameterValueAsDouble(TOLERANCE_SIZE);
        this.m_TreesArray = new ArrayList();
        this.m_Trees = this.getNewVectorLayer(TREES, Sextante.getText((String)"Trees"), 0, new Class[]{Integer.class, Double.class, Double.class}, new String[]{"ID", Sextante.getText((String)"Superficie"), Sextante.getText((String)"coef_forma")});
        this.m_SizeStats = new SimpleStats();
        this.getClassInformation();
        this.m_BinaryImage = this.getTempRasterLayer(0, this.m_AnalysisExtent, 1);
        this.m_BinaryImage.setNoDataValue(0.0);
        for (int i = 0; i < this.m_Window.length; ++i) {
            this.m_Window[i].setWindowExtent(this.m_AnalysisExtent);
        }
        this.doParalellpiped();
        this.detectAndVectorizeTrees();
        return !this.m_Task.isCanceled();
    }

    private void detectAndVectorizeTrees() {
        int iNX = this.m_BinaryImage.getWindowGridExtent().getNX();
        int iNY = this.m_BinaryImage.getWindowGridExtent().getNY();
        this.setProgressText(Sextante.getText((String)"Vectorizing"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = this.m_BinaryImage.getCellValueAsDouble(x, y);
                if (this.m_BinaryImage.isNoDataValue(dValue) || dValue == 2.0) continue;
                this.detectTree(x, y);
            }
        }
        this.vectorize();
    }

    private void detectTree(int x, int y) {
        int iCells = 0;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        ArrayList<java.awt.Point> centralPoints = new ArrayList<java.awt.Point>();
        ArrayList<java.awt.Point> adjPoints = new ArrayList<java.awt.Point>();
        xMin = Math.min(xMin, x);
        yMin = Math.min(yMin, y);
        xMax = Math.max(xMax, x);
        yMax = Math.max(yMax, y);
        ++iCells;
        centralPoints.add(new java.awt.Point(x, y));
        this.m_BinaryImage.setCellValue(x, y, 2.0);
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                java.awt.Point point = (java.awt.Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    double dValue = this.m_BinaryImage.getCellValueAsDouble(x2, y2);
                    if (this.m_BinaryImage.isNoDataValue(dValue) || dValue == 2.0) continue;
                    this.m_BinaryImage.setCellValue(x2, y2, 2.0);
                    adjPoints.add(new java.awt.Point(x2, y2));
                    xMin = Math.min(xMin, x2);
                    yMin = Math.min(yMin, y2);
                    xMax = Math.max(xMax, x2);
                    yMax = Math.max(yMax, y2);
                    ++iCells;
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
        if (Math.abs((double)iCells - this.m_SizeStats.getMean()) < this.m_SizeStats.getStdDev() * this.m_dToleranceSize) {
            Tree tree = new Tree();
            GridCell cellMin = new GridCell(xMin, yMin, 0.0);
            GridCell cellMax = new GridCell(xMax, yMax, 0.0);
            Point2D ptMin = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(cellMin);
            Point2D ptMax = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(cellMax);
            double xCenter = (ptMax.getX() + ptMin.getX()) / 2.0;
            double yCenter = (ptMax.getY() + ptMin.getY()) / 2.0;
            tree.center = new Point2D.Double(xCenter, yCenter);
            tree.dArea = iCells;
            tree.dPerimeter = (xMax - xMin + 1) * (yMax - yMin + 1);
            this.m_TreesArray.add(tree);
        }
    }

    private void vectorize() {
        int iTree = 1;
        for (int i = 0; i < this.m_TreesArray.size(); ++i) {
            Tree tree = (Tree)this.m_TreesArray.get(i);
            Object[] value = new Object[]{new Integer(iTree), new Double(tree.dArea), new Double(tree.getAreaPerimeterRatio())};
            Point pt = this.m_GeometryFactory.createPoint(new Coordinate(tree.center.getX(), tree.center.getY()));
            this.m_Trees.addFeature((Geometry)pt, value);
            ++iTree;
        }
    }

    private void getClassInformation() {
        int i;
        this.m_Stats = new ArrayList();
        this.m_Window = new IRasterLayer[this.m_Bands.size()];
        this.m_iBand = new int[this.m_Bands.size()];
        for (i = 0; i < this.m_Bands.size(); ++i) {
            RasterLayerAndBand rab = (RasterLayerAndBand)this.m_Bands.get(i);
            this.m_iBand[i] = rab.getBand();
            this.m_Window[i] = rab.getRasterLayer();
            AnalysisExtent extent = this.getAdjustedGridExtent(i);
            this.m_Stats.add(new SimpleStats());
            this.m_Window[i].setWindowExtent(extent);
        }
        this.setProgressText(Sextante.getText((String)"Calculating_spectral_signatures"));
        i = 0;
        int iShapeCount = this.m_Polygons.getShapesCount();
        IFeatureIterator featureIter = this.m_Polygons.iterator();
        while (featureIter.hasNext() && this.setProgress(i, iShapeCount)) {
            try {
                IFeature feature = featureIter.next();
                Geometry geometry = feature.getGeometry();
                this.doPolygon(geometry);
            }
            catch (IteratorException iteratorException) {}
        }
        featureIter.close();
    }

    private void doPolygon(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part);
        }
    }

    private void doPolygonPart(Geometry geom) {
        int iSize = 0;
        Envelope extent = geom.getEnvelopeInternal();
        Coordinate[] points = geom.getCoordinates();
        for (int i = 0; i < this.m_Window.length; ++i) {
            int xStop;
            Coordinate p = new Coordinate();
            SimpleStats substats = (SimpleStats)this.m_Stats.get(i);
            AnalysisExtent ge = this.m_Window[i].getWindowGridExtent();
            int iNX = ge.getNX();
            int iNY = ge.getNY();
            boolean[] bCrossing = new boolean[iNX];
            int xStart = (int)((extent.getMinX() - ge.getXMin()) / ge.getCellSize()) - 1;
            if (xStart < 0) {
                xStart = 0;
            }
            if ((xStop = (int)((extent.getMaxX() - ge.getXMin()) / ge.getCellSize()) + 1) >= iNX) {
                xStop = iNX - 1;
            }
            int y = 0;
            double yPos = ge.getYMax();
            while (y < iNY) {
                if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                    Arrays.fill(bCrossing, false);
                    Coordinate pLeft = new Coordinate(ge.getXMin() - 1.0, yPos);
                    Coordinate pRight = new Coordinate(ge.getXMax() + 1.0, yPos);
                    Coordinate pb = points[points.length - 1];
                    for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                        Coordinate pa = pb;
                        pb = points[iPoint];
                        if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                        this.getCrossing(p, pa, pb, pLeft, pRight);
                        int ix = (int)((p.x - ge.getXMin()) / ge.getCellSize() + 1.0);
                        if (ix < 0) {
                            ix = 0;
                        } else if (ix >= iNX) {
                            ix = iNX - 1;
                        }
                        bCrossing[ix] = !bCrossing[ix];
                    }
                    boolean bFill = false;
                    for (int x = xStart; x <= xStop; ++x) {
                        if (bCrossing[x]) {
                            boolean bl = bFill = !bFill;
                        }
                        if (!bFill) continue;
                        ++iSize;
                        double dValue = this.m_Window[i].getCellValueAsDouble(x, y, this.m_iBand[i]);
                        if (this.m_Window[i].isNoDataValue(dValue)) continue;
                        substats.addValue(dValue);
                    }
                }
                ++y;
                yPos -= ge.getCellSize();
            }
            if (i != 0) continue;
            this.m_SizeStats.addValue((double)iSize);
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }

    private AnalysisExtent getAdjustedGridExtent(int iLayer) {
        AnalysisExtent ge = new AnalysisExtent();
        Rectangle2D rect = this.m_Polygons.getFullExtent();
        double dMinX = this.m_Window[iLayer].getLayerGridExtent().getXMin();
        double dMinY = this.m_Window[iLayer].getLayerGridExtent().getYMin();
        double dCellSize = this.m_Window[iLayer].getLayerGridExtent().getCellSize();
        this.m_iMinX = (int)Math.floor((rect.getMinX() - dMinX) / dCellSize);
        double iMaxX = Math.ceil((rect.getMaxX() - dMinX) / dCellSize);
        this.m_iMinY = (int)Math.floor((rect.getMinY() - dMinY) / dCellSize);
        double iMaxY = Math.ceil((rect.getMaxY() - dMinY) / dCellSize);
        double dMinX2 = dMinX + (double)this.m_iMinX * dCellSize;
        double dMinY2 = dMinY + (double)this.m_iMinY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMinY + iMaxY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2, true);
        ge.setYRange(dMinY2, dMaxY2, true);
        return ge;
    }

    private boolean doParalellpiped() {
        int iGrid;
        double[] dMean = new double[this.m_Window.length];
        double[] dStdDev = new double[this.m_Window.length];
        int iNX = this.m_BinaryImage.getWindowGridExtent().getNX();
        int iNY = this.m_BinaryImage.getWindowGridExtent().getNY();
        for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
            SimpleStats substats = (SimpleStats)this.m_Stats.get(iGrid);
            dMean[iGrid] = substats.getMean();
            dStdDev[iGrid] = Math.sqrt(substats.getVariance());
        }
        this.setProgressText(Sextante.getText((String)"Classifying"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                boolean bIsInParalellpiped = true;
                for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                    double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y, this.m_iBand[iGrid]);
                    if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                        if (!(Math.abs(dValue - dMean[iGrid]) > dStdDev[iGrid] * this.m_dTolerance)) continue;
                        bIsInParalellpiped = false;
                        break;
                    }
                    bIsInParalellpiped = false;
                    break;
                }
                if (bIsInParalellpiped) {
                    this.m_BinaryImage.setCellValue(x, y, 1.0);
                    continue;
                }
                this.m_BinaryImage.setNoData(x, y);
            }
        }
        return true;
    }
}

