/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.solarRadiation;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SolarRadiationAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String SOLARCONST = "SOLARCONST";
    public static final String METHOD = "METHOD";
    public static final String TRANSMITTANCE = "TRANSMITTANCE";
    public static final String PRESSURE = "PRESSURE";
    public static final String HOURSTEP = "HOURSTEP";
    public static final String DAILYSTEP = "DAILYSTEP";
    public static final String WATER = "WATER";
    public static final String DUST = "DUST";
    public static final String LATITUDE = "LATITUDE";
    public static final String INITMONTH = "INITMONTH";
    public static final String INITDAY = "INITDAY";
    public static final String ENDMONTH = "ENDMONTH";
    public static final String ENDDAY = "ENDDAY";
    public static final String RADIATION = "RADIATION";
    public static final String TIME = "TIME";
    private static final double DEG_90_IN_RAD = Math.toRadians(90.0);
    int m_iNX;
    int m_iNY;
    int m_iMethod;
    double m_SolarConstant;
    double m_Transmittance;
    double m_Water;
    double m_Dust;
    double m_Pressure;
    double m_dAzimuth;
    double m_dHeight;
    double m_dRDIRN;
    double m_dRDIFN;
    IRasterLayer m_Radiation;
    IRasterLayer m_RadiationDaily;
    IRasterLayer m_Duration;
    IRasterLayer m_DurationDaily;
    IRasterLayer m_Sum;
    IRasterLayer m_DEM = null;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Global_atmospheric_transmittance"), Sextante.getText((String)"Calculate_components_separately")};
        String[] sMonths = new String[]{Sextante.getText((String)"January"), Sextante.getText((String)"February"), Sextante.getText((String)"March"), Sextante.getText((String)"April"), Sextante.getText((String)"May"), Sextante.getText((String)"June"), Sextante.getText((String)"July"), Sextante.getText((String)"August"), Sextante.getText((String)"September"), Sextante.getText((String)"October"), Sextante.getText((String)"November"), Sextante.getText((String)"December")};
        String[] sDays = new String[31];
        for (int i = 1; i < 32; ++i) {
            sDays[i - 1] = Integer.toString(i);
        }
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setName(Sextante.getText((String)"Solar_radiation"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(SOLARCONST, Sextante.getText((String)"Solar_constant_[W-m\u00b2]"), 1367.0, 2);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(TRANSMITTANCE, Sextante.getText((String)"Global_transmittance"), 2, 70.0, 0.0, 100.0);
            this.m_Parameters.addNumericalValue(PRESSURE, Sextante.getText((String)"Atmospheric_pressure_[mb]"), 2, 1013.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(WATER, Sextante.getText((String)"Atmospheric_water_content_[cm]"), 2, 1.68, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(DUST, Sextante.getText((String)"Dust_[ppm]"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(LATITUDE, Sextante.getText((String)"Latitude"), 2, 41.0, -90.0, 90.0);
            this.m_Parameters.addNumericalValue(HOURSTEP, Sextante.getText((String)"Interval_for_daily_insolation_[h]"), 2, 1.0, 0.001, 12.0);
            this.m_Parameters.addNumericalValue(DAILYSTEP, Sextante.getText((String)"Interval_for_global_insolation_[days]"), 2, 1.0, 1.0, 100.0);
            this.m_Parameters.addSelection(INITMONTH, Sextante.getText((String)"Starting_month"), sMonths);
            this.m_Parameters.addSelection(INITDAY, Sextante.getText((String)"Starting_day"), sDays);
            this.m_Parameters.addSelection(ENDMONTH, Sextante.getText((String)"Ending_month"), sMonths);
            this.m_Parameters.addSelection(ENDDAY, Sextante.getText((String)"Ending_day"), sDays);
            this.addOutputRasterLayer(RADIATION, Sextante.getText((String)"Solar_radiation"));
            this.addOutputRasterLayer(TIME, Sextante.getText((String)"Insolation_time"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int[] Month2Day = new int[]{0, 31, 49, 80, 109, 140, 170, 201, 232, 272, 303, 333};
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_SolarConstant = this.m_Parameters.getParameterValueAsDouble(SOLARCONST) / 1000.0;
        this.m_Transmittance = this.m_Parameters.getParameterValueAsDouble(TRANSMITTANCE) / 100.0;
        this.m_Pressure = this.m_Parameters.getParameterValueAsDouble(PRESSURE);
        this.m_Water = this.m_Parameters.getParameterValueAsDouble(WATER);
        this.m_Dust = this.m_Parameters.getParameterValueAsDouble(DUST);
        double Latitude = Math.toRadians(this.m_Parameters.getParameterValueAsDouble(LATITUDE));
        int Day_Step = this.m_Parameters.getParameterValueAsInt(DAILYSTEP);
        double Hour_Step = this.m_Parameters.getParameterValueAsDouble(HOURSTEP);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Radiation = this.getNewRasterLayer(RADIATION, Sextante.getText((String)"Solar_radiation"), 4);
        this.m_Duration = this.getNewRasterLayer(TIME, Sextante.getText((String)"Insolation_time"), 4);
        AnalysisExtent extent = this.m_Radiation.getWindowGridExtent();
        this.m_RadiationDaily = this.getTempRasterLayer(4, extent);
        this.m_DurationDaily = this.getTempRasterLayer(4, extent);
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        double Hour_Start = 0.0;
        double Hour_Stop = 24.0;
        int Day_Start = this.m_Parameters.getParameterValueAsInt(INITDAY) + Month2Day[this.m_Parameters.getParameterValueAsInt(INITMONTH)];
        int Day_Stop = this.m_Parameters.getParameterValueAsInt(ENDDAY) + Month2Day[this.m_Parameters.getParameterValueAsInt(ENDMONTH)];
        this.executeSumOfDays(Latitude, Hour_Step, Hour_Start, Hour_Stop, Day_Step, Day_Start, Day_Stop);
        return !this.m_Task.isCanceled();
    }

    private void executeSumOfDays(double Latitude_RAD, double Hour_Step, double Hour_Start, double Hour_Stop, int Day_Step, int Day_Start, int Day_Stop) {
        int Day;
        int nDays = Day_Stop - Day_Start;
        if (Day_Step < 1 || Day_Step > nDays) {
            Day_Step = 1;
        }
        for (Day = Day_Start; Day < Day_Stop && !this.m_Task.isCanceled(); Day += Day_Step) {
            this.setProgressText(Sextante.getText((String)"Calculating_day") + Integer.toString(Day - Day_Start + 1) + Sextante.getText((String)"de") + Integer.toString(nDays));
            this.getDailySum(Latitude_RAD, Hour_Step, Hour_Start, Hour_Stop, Day);
            this.m_RadiationDaily.multiply((double)Day_Step);
            this.m_Radiation.add(this.m_RadiationDaily);
            this.m_DurationDaily.multiply((double)Day_Step);
            this.m_Duration.add(this.m_DurationDaily);
        }
        Day_Step = Day_Stop - Day;
        if (Day_Step > 0) {
            this.getDailySum(Latitude_RAD, Hour_Step, Hour_Start, Hour_Stop, Day);
            this.m_RadiationDaily.multiply((double)Day_Step);
            this.m_Radiation.add(this.m_RadiationDaily);
            this.m_DurationDaily.multiply((double)Day_Step);
            this.m_Duration.add(this.m_DurationDaily);
        }
    }

    private void getDailySum(double Latitude_RAD, double Hour_Step, double Hour_Start, double Hour_Stop, int Day) {
        if ((Day %= 366) < 0) {
            Day += 366;
        }
        this.m_RadiationDaily.assign(0.0);
        this.m_DurationDaily.assign(0.0);
        for (double time = Hour_Start += Hour_Step / 2.0; time < Hour_Stop && this.setProgress((int)(time - Hour_Start), (int)(Hour_Stop - Hour_Start)); time += Hour_Step) {
            if (!this.getSolarPosition(Day, time, Latitude_RAD, 0.0, false)) continue;
            this.rayTrace();
            for (int y = 0; y < this.m_iNY; ++y) {
                for (int x = 0; x < this.m_iNX; ++x) {
                    double Solar_Angle = this.m_RadiationDaily.getCellValueAsDouble(x, y);
                    if (this.m_RadiationDaily.isNoDataValue(Solar_Angle) || !(Solar_Angle < DEG_90_IN_RAD)) continue;
                    this.getSolarCorrection(DEG_90_IN_RAD - this.m_dHeight, this.m_DEM.getCellValueAsDouble(x, y));
                    double d = this.m_SolarConstant * Hour_Step * this.m_dRDIRN * Math.cos(Solar_Angle);
                    this.m_RadiationDaily.addToCellValue(x, y, d);
                    this.m_DurationDaily.addToCellValue(x, y, Hour_Step);
                }
            }
        }
    }

    void getSolarCorrection(double ZenithAngle, double Elevation) {
        double AMASS;
        double[] AM = new double[]{2.0, 2.06, 2.12, 2.19, 2.27, 2.36, 2.45, 2.55, 2.65, 2.77, 2.9, 3.05, 3.21, 3.39, 3.59, 3.82, 4.07, 4.37, 4.72, 5.12, 5.6, 6.18, 6.88, 7.77, 8.9, 10.39, 12.44, 15.36, 19.79, 26.96, 26.96, 26.96};
        double Pressure_0 = 1013.0;
        double z = Math.toDegrees(ZenithAngle);
        if (z <= 60.0) {
            AMASS = 1.0 / Math.cos(ZenithAngle);
        } else {
            int i = (int)(z -= 60.0);
            AMASS = AM[i] + (z - (double)i) * (AM[i + 1] - AM[i]);
        }
        z = this.m_Pressure / Math.pow(10.0, Elevation * 5.4667E-5);
        double AMASS2 = AMASS * z / 1013.0;
        switch (this.m_iMethod) {
            default: {
                this.m_dRDIRN = Math.pow(this.m_Transmittance, AMASS2);
                this.m_dRDIFN = 0.271 - 0.294 * this.m_dRDIRN;
                break;
            }
            case 1: {
                double AW = 1.0 - 0.077 * Math.pow(this.m_Water * AMASS2, 0.3);
                double TW = Math.pow(0.975, this.m_Water * AMASS);
                double TD = Math.pow(0.95, this.m_Water * this.m_Dust / 100.0);
                double TDC = Math.pow(0.9, AMASS2) + 0.026 * (AMASS2 - 1.0);
                this.m_dRDIRN = AW * TW * TD * TDC;
                this.m_dRDIFN = 0.5 * (AW - this.m_dRDIRN);
            }
        }
    }

    private boolean getSolarPosition(int Day, double Time, double LAT, double LON, boolean bDegree) {
        int[] Day2Month = new int[]{0, 31, 49, 80, 109, 140, 170, 201, 232, 272, 303, 333, 366};
        double ECLIPTIC_OBL = Math.toRadians(23.43999);
        double Year = 2000.0;
        double Month = 1.0;
        for (int i = 0; i <= 12; ++i) {
            if (Day >= Day2Month[i]) continue;
            Month = i;
            Day -= Day2Month[i - 1];
            break;
        }
        if (Month < 1.0 || Month > 12.0) {
            Month = 1.0;
        }
        if (Month <= 2.0) {
            Month += 12.0;
            Year -= 1.0;
        }
        double UTime = Time - LON * 12.0 / Math.PI;
        double JD = (double)((int)(365.25 * Year) + (int)(30.6001 * (Month + 1.0)) - 15) + 1720996.5 + (double)Day + UTime / 24.0;
        double T = (JD - 2451545.0) / 36525.0;
        double M = Math.toRadians(357.5291 + 35999.0503 * T - 1.559E-4 * T * T - 4.8E-7 * T * T * T);
        double L = Math.toRadians(280.46645 + 36000.76983 * T + 3.032E-4 * T * T + ((1.9146 - 0.004817 * T - 1.4E-5 * T * T) * Math.sin(M) + (0.019993 - 1.01E-4 * T) * Math.sin(2.0 * M) + 2.9E-4 * Math.sin(3.0 * M)));
        double X = Math.cos(L);
        double Y = Math.cos(ECLIPTIC_OBL) * Math.sin(L);
        double Z = Math.sin(ECLIPTIC_OBL) * Math.sin(L);
        double R = Math.sqrt(1.0 - Z * Z);
        double DEC = Math.atan2(Z, R);
        double RA = 2.0 * Math.atan2(Y, X + R);
        double theta = LON + Math.toRadians(280.46061837 + 360.98564736629 * (JD - 2451545.0) + T * T * (3.87933E-4 - T / 3.871E7));
        double tau = theta - RA;
        this.m_dHeight = Math.asin(Math.sin(LAT) * Math.sin(DEC) + Math.cos(LAT) * Math.cos(DEC) * Math.cos(tau));
        this.m_dAzimuth = Math.atan2(-Math.sin(tau) * Math.cos(DEC), Math.cos(LAT) * Math.sin(DEC) - Math.sin(LAT) * Math.cos(DEC) * Math.cos(tau));
        if (bDegree) {
            this.m_dHeight = Math.toDegrees(this.m_dHeight);
            this.m_dAzimuth = Math.toDegrees(this.m_dAzimuth);
        }
        return this.m_dHeight >= 0.0;
    }

    private void getShading() {
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dSlope = this.m_DEM.getSlope(x, y);
                double dAspect = this.m_DEM.getAspect(x, y);
                if (!this.m_DEM.isNoDataValue(dSlope) && !this.m_DEM.isNoDataValue(dAspect)) {
                    double dSinDec = Math.sin(this.m_dHeight);
                    double dCosDec = Math.cos(this.m_dHeight);
                    dSlope = Math.tan(dSlope);
                    double dShading = DEG_90_IN_RAD - Math.atan(dSlope);
                    if ((dShading = Math.acos(Math.sin(dShading) * dSinDec + Math.cos(dShading) * dCosDec * Math.cos(dAspect - this.m_dAzimuth))) > DEG_90_IN_RAD) {
                        dShading = DEG_90_IN_RAD;
                    }
                    this.m_RadiationDaily.setCellValue(x, y, dShading);
                    continue;
                }
                this.m_RadiationDaily.setNoData(x, y);
            }
        }
    }

    private void rayTrace() {
        this.getShading();
    }
}

