/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.viewshed;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.LinkedList;

public class RangeOfSight {
    public static final double VISIBLE = 255.0;
    public static final double HIDDEN = 0.0;
    public static final double UNDEFINED = -1.0;
    private final IRasterLayer m_dem;
    private final double m_objectHeights;

    public RangeOfSight(IRasterLayer dem, double objectHeights) {
        this.m_dem = dem;
        this.m_objectHeights = objectHeights;
    }

    public LinkedList<GridCell> Calculate(GridCell sourceCell, GridCell targetCell, boolean skipNoData) {
        double d;
        double dMaxSlope = Double.MAX_VALUE;
        LinkedList<GridCell> ros = new LinkedList<GridCell>();
        ros.add(new GridCell(sourceCell.getX(), sourceCell.getY(), 255.0));
        double dx = targetCell.getX() - sourceCell.getX();
        double dy = targetCell.getY() - sourceCell.getY();
        double d2 = d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        if (d == 0.0) {
            return ros;
        }
        double dist = Math.sqrt(dx * dx + dy * dy);
        dx /= d;
        dy /= d;
        d = dist / d;
        double ix = (double)sourceCell.getX() + 0.5;
        double iy = (double)sourceCell.getY() + 0.5;
        if (this.m_dem.isNoDataValue(sourceCell.getValue())) {
            return ros;
        }
        double id = 0.0;
        while (id < dist) {
            GridCell currCell;
            id += d;
            if (this.m_dem.isNoDataValue((currCell = new GridCell((int)(ix += dx), (int)(iy += dy), this.m_dem.getCellValueAsDouble((int)ix, (int)iy))).getValue())) {
                if (skipNoData) continue;
                ros.add(new GridCell(currCell.getX(), currCell.getY(), this.m_dem.getNoDataValue()));
                continue;
            }
            double heightedSlope = (currCell.getValue() + this.m_objectHeights - sourceCell.getValue()) / id;
            if (dMaxSlope == Double.MAX_VALUE) {
                ros.add(new GridCell(currCell.getX(), currCell.getY(), 255.0));
            } else if (heightedSlope <= dMaxSlope) {
                ros.add(new GridCell(currCell.getX(), currCell.getY(), 0.0));
            } else {
                ros.add(new GridCell(currCell.getX(), currCell.getY(), 255.0));
            }
            double realSlope = (currCell.getValue() - sourceCell.getValue()) / id;
            if (dMaxSlope != Double.MAX_VALUE && !(realSlope > dMaxSlope)) continue;
            dMaxSlope = realSlope;
        }
        return ros;
    }

    public LinkedList<Coordinate> Calculate(Coordinate source, Coordinate target) {
        double maxSlope = Double.MAX_VALUE;
        LinkedList<Coordinate> ros = new LinkedList<Coordinate>();
        ros.add(new Coordinate(source.x, source.y, 255.0));
        if (this.m_dem.isNoDataValue(source.z)) {
            return ros;
        }
        LineSegment los = new LineSegment(source, target);
        double rosAngle = los.angle();
        double losCosAngle = Math.cos(rosAngle);
        double losSinAngle = Math.sin(rosAngle);
        double losDistance = los.getLength();
        int xCellCount = (int)((target.x - source.x) / this.m_dem.getLayerCellSize());
        int yCellCount = (int)((target.y - source.y) / this.m_dem.getLayerCellSize());
        int maxCellCount = Math.max(Math.abs(xCellCount), Math.abs(yCellCount));
        if (maxCellCount == 0) {
            return ros;
        }
        double cellDistance = losDistance / (double)maxCellCount;
        double currDistance = 0.0;
        while (currDistance < losDistance) {
            Coordinate currLOSPoint = new Coordinate(source.x + (currDistance += cellDistance) * losCosAngle, source.y + currDistance * losSinAngle);
            currLOSPoint.z = this.m_dem.getValueAt(currLOSPoint.x, currLOSPoint.y);
            if (this.m_dem.isNoDataValue(currLOSPoint.z)) continue;
            double slope = (currLOSPoint.z - source.z) / currDistance;
            if (maxSlope == Double.MAX_VALUE) {
                maxSlope = slope;
                ros.add(new Coordinate(currLOSPoint.x, currLOSPoint.y, 255.0));
                continue;
            }
            if (slope <= maxSlope) {
                ros.add(new Coordinate(currLOSPoint.x, currLOSPoint.y, 0.0));
                continue;
            }
            maxSlope = slope;
            ros.add(new Coordinate(currLOSPoint.x, currLOSPoint.y, 255.0));
        }
        return ros;
    }
}

