/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.visibility;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public class VisibilityAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String METHOD = "METHOD";
    public static final String HEIGHT = "HEIGHT";
    public static final String HEIGHTOBS = "HEIGHTOBS";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    private static final double DEG_90_IN_RAD = Math.toRadians(90.0);
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Visibility;
    private GridCell m_Point;
    private double m_dHeight;
    private double m_dHeightObs;
    private int m_iMethod;
    private int m_iRadius;
    private int m_iRadius2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        int iDataType = this.m_iMethod == 0 ? 3 : 4;
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
        this.m_dHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
        this.m_dHeightObs = this.m_Parameters.getParameterValueAsDouble(HEIGHTOBS);
        this.m_DEM.setWindowExtent(this.getAnalysisExtent());
        this.m_Visibility = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Visibility"), iDataType);
        this.m_iRadius = (int)((double)this.m_Parameters.getParameterValueAsInt(RADIUS) / this.m_DEM.getWindowCellSize());
        this.m_iRadius2 = this.m_iRadius * this.m_iRadius;
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.m_Point = this.m_DEM.getWindowGridExtent().getGridCoordsFromWorldCoords(pt);
        this.calculateVisibility(this.m_Point.getX(), this.m_Point.getY());
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Visibility"), Sextante.getText((String)"Lighting"), Sextante.getText((String)"Distance"), Sextante.getText((String)"Height")};
        this.setName(Sextante.getText((String)"Visibility"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Coordinates_of_emitter-receiver"));
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_emitter-receiver"), 10.0, 2);
            this.m_Parameters.addNumericalValue(HEIGHTOBS, Sextante.getText((String)"Height_of_mobile_receiver-emitter"), 0.0, 2);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 0.0, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Visibility"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateVisibility(int x_Pos, int y_Pos) {
        int iYMax;
        int iXMax;
        int iYMin;
        int iXMin;
        double Exaggeration = 1.0;
        double z_Pos = this.m_DEM.getCellValueAsDouble(x_Pos, y_Pos);
        if (this.m_DEM.isNoDataValue(z_Pos)) {
            return;
        }
        z_Pos += this.m_dHeight;
        if (this.m_iRadius > 0) {
            iXMin = Math.max(0, x_Pos - this.m_iRadius);
            iYMin = Math.max(0, y_Pos - this.m_iRadius);
            iXMax = Math.min(this.m_iNX, x_Pos + this.m_iRadius);
            iYMax = Math.min(this.m_iNY, y_Pos + this.m_iRadius);
        } else {
            iXMin = 0;
            iXMax = this.m_iNX;
            iYMin = 0;
            iYMax = this.m_iNY;
        }
        for (int y = iYMin; y < iYMax && this.setProgress(y, this.m_iNY); ++y) {
            block12: for (int x = iXMin; x < iXMax; ++x) {
                int dx = x_Pos - x;
                int dy = y_Pos - y;
                int iDist = dx * dx + dy * dy;
                if (iDist >= this.m_iRadius2 && this.m_iRadius2 > 0) continue;
                double z = this.m_DEM.getCellValueAsDouble(x, y) + this.m_dHeightObs;
                if (this.m_DEM.isNoDataValue(z)) {
                    this.m_Visibility.setNoData(x, y);
                    continue;
                }
                double dz = z_Pos - z;
                if (this.tracePoint(x, y, dx, dy, dz)) {
                    switch (this.m_iMethod) {
                        case 0: {
                            this.m_Visibility.setCellValue(x, y, 1.0);
                            break;
                        }
                        case 1: {
                            double decDTM = this.m_DEM.getSlope(x, y);
                            double aziDTM = this.m_DEM.getAspect(x, y);
                            decDTM = DEG_90_IN_RAD - Math.atan(1.0 * Math.tan(decDTM));
                            double decSrc = Math.atan2(dz, Math.sqrt(dx * dx + dy * dy));
                            double aziSrc = Math.atan2(dx, dy);
                            double d2 = Math.acos(Math.sin(decDTM) * Math.sin(decSrc) + Math.cos(decDTM) * Math.cos(decSrc) * Math.cos(aziDTM - aziSrc));
                            this.m_Visibility.setCellValue(x, y, d2 < DEG_90_IN_RAD ? d2 : DEG_90_IN_RAD);
                            break;
                        }
                        case 2: {
                            this.m_Visibility.setCellValue(x, y, this.m_DEM.getWindowCellSize() * Math.sqrt(dx * dx + dy * dy));
                            break;
                        }
                        case 3: {
                            double d;
                            double d2 = this.m_DEM.getWindowCellSize() * Math.sqrt(dx * dx + dy * dy);
                            if (d > 0.0) {
                                this.m_Visibility.setCellValue(x, y, Math.atan2(this.m_dHeight, d2));
                                break;
                            }
                            this.m_Visibility.setNoData(x, y);
                        }
                    }
                    continue;
                }
                switch (this.m_iMethod) {
                    case 0: {
                        this.m_Visibility.setCellValue(x, y, 0.0);
                        continue block12;
                    }
                    case 1: {
                        this.m_Visibility.setCellValue(x, y, DEG_90_IN_RAD);
                        continue block12;
                    }
                    case 2: 
                    case 3: {
                        this.m_Visibility.setNoData(x, y);
                    }
                }
            }
        }
    }

    boolean tracePoint(int x, int y, double dx, double dy, double dz) {
        double d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        double zmax = this.m_DEM.getMaxValue();
        if (d > 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx /= d;
            dy /= d;
            dz /= d;
            d = dist / d;
            double id = 0.0;
            double ix = (double)x + 0.5;
            double iy = (double)y + 0.5;
            double iz = this.m_DEM.getCellValueAsDouble(x, y);
            while (id < dist) {
                id += d;
                iz += dz;
                x = (int)(ix += dx);
                y = (int)(iy += dy);
                if (!this.m_DEM.getWindowGridExtent().containsCell(x, y)) {
                    return true;
                }
                if (iz < this.m_DEM.getCellValueAsDouble(x, y)) {
                    return false;
                }
                if (!(iz > zmax)) continue;
                return true;
            }
        }
        return true;
    }
}

