/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.distanceMatrix;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class DistanceMatrixAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        int j = 0;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iCount = layer.getShapesCount();
        double[][] d = new double[iCount][iCount];
        String[] sFields = new String[iCount + 1];
        Class[] types = new Class[iCount + 1];
        Object[] values = new Object[iCount + 1];
        sFields[0] = "ID";
        types[0] = Integer.class;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            sFields[i + 1] = Integer.toString(i + 1);
            types[i + 1] = Double.class;
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            double x1 = coord.x;
            double y1 = coord.y;
            IFeatureIterator iter2 = layer.iterator();
            j = 0;
            while (iter2.hasNext()) {
                feature = iter2.next();
                geom = feature.getGeometry();
                coord = geom.getCoordinate();
                double x2 = coord.x;
                double y2 = coord.y;
                double dDifX = x2 - x1;
                double dDifY = y2 - y1;
                d[i][j] = Math.sqrt(dDifX * dDifX + dDifY * dDifY);
                ++j;
            }
            iter2.close();
            ++i;
        }
        iter.close();
        String sTableName = Sextante.getText((String)"Distance_matrix_[") + layer.getName() + "]";
        ITable driver = this.getNewTable(RESULT, sTableName, types, sFields);
        for (i = 0; i < iCount && this.setProgress(i, iCount); ++i) {
            values[0] = new Integer(i + 1);
            for (j = 0; j < iCount; ++j) {
                double dDist = d[i][j];
                values[j + 1] = new Double(dDist);
            }
            driver.addRecord(values);
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Distance_matrix"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.addOutputTable(RESULT, Sextante.getText((String)"Distance_matrix"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

