/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.profiles.crossSections;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CrossSectionsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String NUMPOINTS = "NUMPOINTS";
    public static final String WIDTH = "WIDTH";
    public static final String DISTANCE = "DISTANCE";
    public static final String DEM = "DEM";
    public static final String ROUTE = "ROUTE";
    private IVectorLayer m_Lines;
    private IVectorLayer m_Result;
    private IRasterLayer m_DEM;
    private double m_dStepX;
    private double m_dStepY;
    private double m_dDistance;
    private double m_dInterval;
    private double m_dSectionWidth;
    private int m_iPointsInSection;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Lines = this.m_Parameters.getParameterValueAsVectorLayer(ROUTE);
        if (!this.m_bIsAutoExtent) {
            this.m_Lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if (this.m_Lines.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException("zero shapes in layer");
        }
        this.m_dDistance = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
        this.m_dSectionWidth = this.m_Parameters.getParameterValueAsDouble(WIDTH);
        this.m_iPointsInSection = this.m_Parameters.getParameterValueAsInt(NUMPOINTS);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        this.m_dInterval = this.m_dSectionWidth / (double)this.m_iPointsInSection;
        String[] sFieldNames = new String[this.m_iPointsInSection * 2 + 1];
        Class[] types = new Class[this.m_iPointsInSection * 2 + 1];
        int i = -this.m_iPointsInSection;
        int iField = 0;
        while (i < this.m_iPointsInSection + 1) {
            sFieldNames[iField] = Double.toString(this.m_dInterval * (double)i);
            types[iField] = Double.class;
            ++i;
            ++iField;
        }
        sFieldNames[this.m_iPointsInSection] = "0";
        types[this.m_iPointsInSection] = Double.class;
        this.m_Result = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Cross_sections"), 1, types, sFieldNames);
        int iCount = this.m_Lines.getShapesCount();
        IFeatureIterator iter = this.m_Lines.iterator();
        i = 0;
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geometry = feature.getGeometry();
            for (int j = 0; j < geometry.getNumGeometries(); ++j) {
                Geometry line = geometry.getGeometryN(j);
                this.processLine(line);
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cross_sections"));
        this.setGroup(Sextante.getText((String)"Profiles"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(ROUTE, Sextante.getText((String)"Route"), 1, true);
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Distance_between_sections"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(WIDTH, Sextante.getText((String)"Section_width__to_each_side"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(NUMPOINTS, Sextante.getText((String)"Number_of_points__on_each_side"), 1, 5.0, 0.0, 2.147483647E9);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Cross_sections"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void processLine(Geometry line) {
        double dAddedPointX = 0.0;
        double dAddedPointY = 0.0;
        double dRemainingDistFromLastSegment = 0.0;
        Coordinate[] coords = line.getCoordinates();
        if (coords.length < 2) {
            return;
        }
        double dX1 = coords[0].x;
        double dY1 = coords[0].y;
        double dX2 = coords[1].x;
        double dY2 = coords[1].y;
        dAddedPointX = dX1;
        dAddedPointY = dY1;
        this.computeSegmentOrientation(dX1, dY1, dX2, dY2);
        this.addPoint(dX1, dY1);
        for (int i = 0; i < coords.length - 1; ++i) {
            dX1 = coords[i].x;
            dY1 = coords[i].y;
            dX2 = coords[i + 1].x;
            dY2 = coords[i + 1].y;
            double dDX = dX2 - dX1;
            double dDY = dY2 - dY1;
            double dDistToNextPoint = Math.sqrt(dDX * dDX + dDY * dDY);
            this.computeSegmentOrientation(dX1, dY1, dX2, dY2);
            if (dRemainingDistFromLastSegment + dDistToNextPoint > this.m_dDistance) {
                int iPoints = (int)((dRemainingDistFromLastSegment + dDistToNextPoint) / this.m_dDistance);
                double dDist = this.m_dDistance - dRemainingDistFromLastSegment;
                for (int j = 0; j < iPoints; ++j) {
                    dDist = this.m_dDistance - dRemainingDistFromLastSegment;
                    dAddedPointX = dX1 + (dDist += (double)j * this.m_dDistance) * dDX / dDistToNextPoint;
                    dAddedPointY = dY1 + dDist * dDY / dDistToNextPoint;
                    this.addPoint(dAddedPointX, dAddedPointY);
                }
                dDX = dX2 - dAddedPointX;
                dDY = dY2 - dAddedPointY;
                dRemainingDistFromLastSegment = Math.sqrt(dDX * dDX + dDY * dDY);
                continue;
            }
            dRemainingDistFromLastSegment += dDistToNextPoint;
        }
    }

    private void computeSegmentOrientation(double x, double y, double x2, double y2) {
        double dx = x2 - x;
        double dy = y2 - y;
        double dDistance = Math.sqrt(dx * dx + dy * dy);
        this.m_dStepX = dy / dDistance * this.m_dInterval;
        this.m_dStepY = -dx / dDistance * this.m_dInterval;
    }

    private void addPoint(double x, double y) {
        Object[] value = new Object[this.m_iPointsInSection * 2 + 1];
        Coordinate[] coords = new Coordinate[]{new Coordinate(x + (double)this.m_iPointsInSection * this.m_dStepX, y + (double)this.m_iPointsInSection * this.m_dStepY), new Coordinate(x - (double)this.m_iPointsInSection * this.m_dStepX, y - (double)this.m_iPointsInSection * this.m_dStepY)};
        int i = -this.m_iPointsInSection;
        int iField = 0;
        while (i < this.m_iPointsInSection + 1) {
            double x2 = x - (double)i * this.m_dStepX;
            double y2 = y - (double)i * this.m_dStepY;
            double dElevation = this.m_DEM.getValueAt(x2, y2);
            value[iField] = new Double(dElevation);
            ++i;
            ++iField;
        }
        GeometryFactory gf = new GeometryFactory();
        this.m_Result.addFeature((Geometry)gf.createLineString(coords), value);
    }
}

