/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterize.directionToClosestPoint;

import es.unex.sextante.closestpts.Point3D;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rTree.SextanteRTree;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public class DirectionToClosestPointAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    protected IVectorLayer m_Layer;
    private SextanteRTree m_SearchEngine;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setName(Sextante.getText((String)"Direction_to_closest_point"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Point_layer"), 0, true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_SearchEngine = new SextanteRTree(this.m_Layer, 0, this.m_Task);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.m_Layer.getName() + "[" + Sextante.getText((String)"Direction_to_closest_point") + "]", 5);
        int iNX = this.m_AnalysisExtent.getNX();
        int iNY = this.m_AnalysisExtent.getNY();
        this.setProgressText(Sextante.getText((String)"Calculating"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                result.setCellValue(x, y, this.getValueAt(x, y));
            }
        }
        return !this.m_Task.isCanceled();
    }

    protected double getValueAt(int x, int y) {
        Point2D pt = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
        Point3D closestPt = this.m_SearchEngine.getClosestPoint(pt.getX(), pt.getY());
        Point2D.Double closestPt2D = new Point2D.Double(closestPt.getX(), closestPt.getY());
        Double y0 = ((Point2D)closestPt2D).getY();
        Double y1 = pt.getY();
        Double x0 = ((Point2D)closestPt2D).getX();
        Double x1 = pt.getX();
        Double angle = y1 - y0 >= 0.0 & x1 - x0 >= 0.0 ? Double.valueOf(Math.atan((y1 - y0) / (x1 - x0))) : (y1 - y0 >= 0.0 & x1 - x0 < 0.0 ? Double.valueOf(Math.atan((y1 - y0) / (x1 - x0)) + Math.PI) : (y1 - y0 < 0.0 & x1 - x0 < 0.0 ? Double.valueOf(Math.atan((y1 - y0) / (x1 - x0)) + Math.PI) : Double.valueOf(Math.atan((y1 - y0) / (x1 - x0)) + Math.PI * 2)));
        return angle;
    }
}

