/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.normalityTest;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.tables.normalityTest.SWilk;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class NormalityTestAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String FIELD = "FIELD";
    public static final String LAYER = "LAYER";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ArrayList<Double> array = new ArrayList<Double>();
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int i = 0;
        int iCount = layer.getShapesCount();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            try {
                double dValue = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                array.add(new Double(dValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        iter.close();
        if (array.size() < 3) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"At_least_three_features_are_needed_for_using_this_algorithm"));
        }
        if (array.size() > 5000) {
            Sextante.addWarningToLog((String)"Mas_de_5000puntos_shapiro");
        }
        double[] values = new double[array.size() + 1];
        for (int j = 0; j < array.size(); ++j) {
            values[j + 1] = (Double)array.get(j);
        }
        double[] pw = new double[1];
        double[] w = new double[1];
        double[] a = new double[array.size() / 2];
        int n = Math.min(5000, array.size());
        boolean[] init = new boolean[]{false};
        int[] ifault = new int[]{-1};
        SWilk.swilk(init, values, n, n, n / 2, a, w, pw, ifault);
        if (ifault[0] != 0 && ifault[0] != 2) {
            throw new GeoAlgorithmExecutionException("Error_calculando_shapiro");
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Normality_test"));
        doc.addHeader(Sextante.getText((String)"Normality_test"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Shapiro-Wilk_W") + df.format(w[0]));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(RESULT, Sextante.getText((String)"Statistics") + "[" + layer.getName() + "]", doc.getHTMLCode());
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Normality_test"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.addOutputText(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

