/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.smoothTinBezier;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.tin.smoothTinBezier.Bezier;
import es.unex.sextante.tin.smoothTinBezier.Bezier2;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class BezierSurface {
    private final STRtree trianglesIndex;
    Coordinate[][] triangles;
    TreeMap breakLines = new TreeMap();
    Bezier[] miniBezierTriangles;
    double scaleZ;
    int index = 0;
    int m_LoD;
    byte[] trianIndex;
    float[][] barycentrCoor;

    public BezierSurface(Coordinate[][] triangles, STRtree trianglesIndex, TreeMap breakLines, double scaleZ, int m_LoD) {
        this.trianglesIndex = trianglesIndex;
        this.triangles = triangles;
        this.breakLines = breakLines;
        this.scaleZ = scaleZ;
        this.m_LoD = m_LoD;
        for (int k = 0; k < triangles.length; ++k) {
            for (int l = 0; l < 3; ++l) {
                triangles[k][l].z /= scaleZ;
            }
        }
        this.setBaryCoordinates();
    }

    public boolean hasNext() {
        return this.index != this.triangles.length;
    }

    public Coordinate[][] nextTrinagle() {
        boolean indexOfInterpolatedTriangles = false;
        Bezier2 newBezierTriangles = new Bezier2(this.triangles[this.index]);
        newBezierTriangles.setNormalVector(this.searchVectors(newBezierTriangles, newBezierTriangles.b300, this.index), this.searchVectors(newBezierTriangles, newBezierTriangles.b030, this.index), this.searchVectors(newBezierTriangles, newBezierTriangles.b003, this.index));
        if (this.breakLines.containsKey(this.index)) {
            newBezierTriangles.setControlPoints((Integer)this.breakLines.get(this.index));
        } else {
            newBezierTriangles.setControlPoints(-1);
        }
        ++this.index;
        return this.getInterpolatedTriangles2(newBezierTriangles);
    }

    private void setBaryCoordinates() {
        switch (this.m_LoD) {
            case 1: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.5f, 0.0f}, {0.5f, 0.0f}, {0.5f, 0.0f}, {0.5f, 0.0f}, {0.5f, 0.0f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 2: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 0, 1, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.33333334f, 0.0f}, {0.6666667f, 0.0f}, {0.33333334f, 0.0f}, {0.0f, 1.0f}, {0.6666667f, 0.0f}, {0.0f, 1.0f}, {0.33333334f, 0.0f}, {0.6666667f, 0.0f}, {0.0f, 1.0f}, {0.6666667f, 0.0f}, {0.33333334f, 0.0f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 3: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.25f, 0.0f}, {0.75f, 0.0f}, {0.25f, 0.0f}, {0.0f, 0.75f}, {0.75f, 0.0f}, {0.25f, 0.0f}, {0.5f, 0.0f}, {0.0f, 0.75f}, {0.0f, 0.75f}, {0.5f, 0.0f}, {0.25f, 0.75f}, {0.25f, 0.75f}, {0.5f, 0.0f}, {0.75f, 0.0f}, {0.0f, 0.75f}, {0.0f, 0.75f}, {0.0f, 0.75f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 4: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.2f, 0.0f}, {0.8f, 0.0f}, {0.2f, 0.0f}, {0.0f, 0.6f}, {0.8f, 0.0f}, {0.2f, 0.6f}, {0.0f, 0.6f}, {0.2f, 0.6f}, {0.0f, 0.6f}, {0.2f, 0.0f}, {0.4f, 0.0f}, {0.0f, 0.6f}, {0.4f, 0.0f}, {0.2f, 0.6f}, {0.2f, 0.6f}, {0.4f, 0.0f}, {0.6f, 0.0f}, {0.2f, 0.6f}, {0.6f, 0.0f}, {0.4f, 0.6f}, {0.4f, 0.6f}, {0.6f, 0.0f}, {0.8f, 0.0f}, {0.2f, 0.6f}, {0.2f, 0.6f}, {0.2f, 0.6f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 5: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.16666667f, 0.0f}, {0.8333333f, 0.0f}, {0.16666667f, 0.0f}, {0.0f, 0.5f}, {0.8333333f, 0.0f}, {0.0f, 0.5f}, {0.16666667f, 0.5f}, {0.33333334f, 0.5f}, {0.16666667f, 0.5f}, {0.0f, 1.0f}, {0.33333334f, 0.5f}, {0.16666667f, 0.0f}, {0.33333334f, 0.0f}, {0.0f, 0.5f}, {0.33333334f, 0.0f}, {0.5f, 0.0f}, {0.16666667f, 0.5f}, {0.5f, 0.0f}, {0.6666667f, 0.0f}, {0.33333334f, 0.5f}, {0.6666667f, 0.0f}, {0.8333333f, 0.0f}, {0.5f, 0.5f}, {0.33333334f, 0.0f}, {0.0f, 0.5f}, {0.16666667f, 0.5f}, {0.5f, 0.0f}, {0.16666667f, 0.5f}, {0.33333334f, 0.5f}, {0.6666667f, 0.0f}, {0.33333334f, 0.5f}, {0.5f, 0.5f}, {0.16666667f, 0.5f}, {0.33333334f, 0.5f}, {0.0f, 1.0f}, {0.16666667f, 0.5f}, {0.25f, 0.5f}, {0.0f, 1.0f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 6: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.14285715f, 0.0f}, {0.85714287f, 0.0f}, {0.14285715f, 0.0f}, {0.0f, 0.42857143f}, {0.85714287f, 0.0f}, {0.0f, 0.42857143f}, {0.14285715f, 0.42857143f}, {0.42857143f, 0.42857143f}, {0.0f, 0.85714287f}, {0.14285715f, 0.42857143f}, {0.42857143f, 0.42857143f}, {0.14285715f, 0.0f}, {0.2857143f, 0.0f}, {0.0f, 0.42857143f}, {0.2857143f, 0.0f}, {0.42857143f, 0.0f}, {0.14285715f, 0.42857143f}, {0.42857143f, 0.0f}, {0.5714286f, 0.0f}, {0.2857143f, 0.42857143f}, {0.5714286f, 0.0f}, {0.71428573f, 0.0f}, {0.42857143f, 0.42857143f}, {0.71428573f, 0.0f}, {0.85714287f, 0.0f}, {0.5714286f, 0.42857143f}, {0.2857143f, 0.0f}, {0.14285715f, 0.42857143f}, {0.0f, 0.42857143f}, {0.42857143f, 0.0f}, {0.2857143f, 0.42857143f}, {0.14285715f, 0.42857143f}, {0.5714286f, 0.0f}, {0.42857143f, 0.42857143f}, {0.2857143f, 0.42857143f}, {0.71428573f, 0.0f}, {0.5714286f, 0.42857143f}, {0.42857143f, 0.42857143f}, {0.0f, 0.85714287f}, {0.2857143f, 0.42857143f}, {0.14285715f, 0.42857143f}, {0.14285715f, 0.85714287f}, {0.42857143f, 0.42857143f}, {0.2857143f, 0.42857143f}, {0.0f, 0.85714287f}, {0.14285715f, 0.85714287f}, {0.2857143f, 0.42857143f}, {0.0f, 0.85714287f}, {0.0f, 0.85714287f}, {0.0f, 0.85714287f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 7: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.125f, 0.0f}, {0.875f, 0.0f}, {0.125f, 0.0f}, {0.0f, 0.375f}, {0.875f, 0.0f}, {0.0f, 0.375f}, {0.125f, 0.375f}, {0.5f, 0.375f}, {0.0f, 0.75f}, {0.125f, 0.375f}, {0.5f, 0.375f}, {0.0f, 0.75f}, {0.125f, 0.75f}, {0.125f, 0.75f}, {0.125f, 0.0f}, {0.25f, 0.0f}, {0.0f, 0.375f}, {0.25f, 0.0f}, {0.375f, 0.0f}, {0.125f, 0.375f}, {0.375f, 0.0f}, {0.5f, 0.0f}, {0.25f, 0.375f}, {0.5f, 0.0f}, {0.625f, 0.0f}, {0.375f, 0.375f}, {0.625f, 0.0f}, {0.75f, 0.0f}, {0.5f, 0.375f}, {0.75f, 0.0f}, {0.875f, 0.0f}, {0.625f, 0.375f}, {0.125f, 0.375f}, {0.25f, 0.0f}, {0.0f, 0.375f}, {0.25f, 0.375f}, {0.375f, 0.0f}, {0.125f, 0.375f}, {0.375f, 0.375f}, {0.5f, 0.0f}, {0.25f, 0.375f}, {0.5f, 0.375f}, {0.625f, 0.0f}, {0.375f, 0.375f}, {0.625f, 0.375f}, {0.75f, 0.0f}, {0.5f, 0.375f}, {0.25f, 0.375f}, {0.0f, 0.75f}, {0.125f, 0.375f}, {0.375f, 0.375f}, {0.125f, 0.75f}, {0.25f, 0.375f}, {0.5f, 0.375f}, {0.25f, 0.75f}, {0.375f, 0.375f}, {0.25f, 0.375f}, {0.0f, 0.75f}, {0.125f, 0.75f}, {0.375f, 0.375f}, {0.125f, 0.75f}, {0.25f, 0.75f}, {0.125f, 0.75f}, {0.125f, 0.75f}, {0.125f, 0.75f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 8: {
                byte[] tIndex = new byte[]{0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.11111111f, 0.0f}, {0.8888889f, 0.0f}, {0.11111111f, 0.0f}, {0.0f, 0.33333334f}, {0.8888889f, 0.0f}, {0.0f, 0.33333334f}, {0.11111111f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.0f, 1.0f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.11111111f, 0.0f}, {0.22222222f, 0.0f}, {0.0f, 0.33333334f}, {0.22222222f, 0.0f}, {0.33333334f, 0.0f}, {0.11111111f, 0.33333334f}, {0.33333334f, 0.0f}, {0.44444445f, 0.0f}, {0.22222222f, 0.33333334f}, {0.44444445f, 0.0f}, {0.5555556f, 0.0f}, {0.33333334f, 0.33333334f}, {0.5555556f, 0.0f}, {0.6666667f, 0.0f}, {0.44444445f, 0.33333334f}, {0.6666667f, 0.0f}, {0.7777778f, 0.0f}, {0.5555556f, 0.33333334f}, {0.7777778f, 0.0f}, {0.8888889f, 0.0f}, {0.6666667f, 0.33333334f}, {0.11111111f, 0.33333334f}, {0.22222222f, 0.0f}, {0.0f, 0.33333334f}, {0.22222222f, 0.33333334f}, {0.33333334f, 0.0f}, {0.11111111f, 0.33333334f}, {0.33333334f, 0.33333334f}, {0.44444445f, 0.0f}, {0.22222222f, 0.33333334f}, {0.44444445f, 0.33333334f}, {0.5555556f, 0.0f}, {0.33333334f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.6666667f, 0.0f}, {0.44444445f, 0.33333334f}, {0.6666667f, 0.33333334f}, {0.7777778f, 0.0f}, {0.5555556f, 0.33333334f}, {0.22222222f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.33333334f}, {0.33333334f, 0.33333334f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.33333334f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.6666667f}, {0.33333334f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.33333334f, 0.6666667f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.6666667f}, {0.33333334f, 0.33333334f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.6666667f}, {0.33333334f, 0.6666667f}, {0.0f, 1.0f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
            case 9: {
                byte[] tIndex = new byte[]{0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4};
                float[][] bCoor = new float[][]{{0.0f, 0.0f}, {0.11111111f, 0.0f}, {0.0f, 0.16666667f}, {0.0f, 0.0f}, {0.0f, 0.16666667f}, {0.8888889f, 0.0f}, {0.0f, 0.16666667f}, {0.11111111f, 0.0f}, {0.11111111f, 0.16666667f}, {0.0f, 0.16666667f}, {0.0f, 0.33333334f}, {0.11111111f, 0.16666667f}, {0.0f, 0.33333334f}, {0.11111111f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.0f, 1.0f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.11111111f, 0.0f}, {0.22222222f, 0.0f}, {0.11111111f, 0.16666667f}, {0.22222222f, 0.16666667f}, {0.22222222f, 0.0f}, {0.11111111f, 0.16666667f}, {0.22222222f, 0.0f}, {0.33333334f, 0.0f}, {0.22222222f, 0.16666667f}, {0.33333334f, 0.16666667f}, {0.33333334f, 0.0f}, {0.22222222f, 0.16666667f}, {0.33333334f, 0.0f}, {0.44444445f, 0.0f}, {0.33333334f, 0.16666667f}, {0.44444445f, 0.16666667f}, {0.44444445f, 0.0f}, {0.33333334f, 0.16666667f}, {0.44444445f, 0.0f}, {0.5555556f, 0.0f}, {0.44444445f, 0.16666667f}, {0.5555556f, 0.16666667f}, {0.5555556f, 0.0f}, {0.44444445f, 0.16666667f}, {0.5555556f, 0.0f}, {0.6666667f, 0.0f}, {0.5555556f, 0.16666667f}, {0.6666667f, 0.16666667f}, {0.6666667f, 0.0f}, {0.5555556f, 0.16666667f}, {0.6666667f, 0.0f}, {0.7777778f, 0.0f}, {0.6666667f, 0.16666667f}, {0.7777778f, 0.16666667f}, {0.7777778f, 0.0f}, {0.6666667f, 0.16666667f}, {0.7777778f, 0.0f}, {0.8888889f, 0.0f}, {0.7777778f, 0.16666667f}, {0.11111111f, 0.33333334f}, {0.11111111f, 0.16666667f}, {0.0f, 0.33333334f}, {0.11111111f, 0.33333334f}, {0.11111111f, 0.16666667f}, {0.22222222f, 0.16666667f}, {0.22222222f, 0.33333334f}, {0.22222222f, 0.16666667f}, {0.11111111f, 0.33333334f}, {0.22222222f, 0.33333334f}, {0.22222222f, 0.16666667f}, {0.33333334f, 0.16666667f}, {0.33333334f, 0.33333334f}, {0.33333334f, 0.16666667f}, {0.22222222f, 0.33333334f}, {0.33333334f, 0.33333334f}, {0.33333334f, 0.16666667f}, {0.44444445f, 0.16666667f}, {0.44444445f, 0.33333334f}, {0.44444445f, 0.16666667f}, {0.33333334f, 0.33333334f}, {0.44444445f, 0.33333334f}, {0.44444445f, 0.16666667f}, {0.5555556f, 0.16666667f}, {0.5555556f, 0.33333334f}, {0.5555556f, 0.16666667f}, {0.44444445f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.5555556f, 0.16666667f}, {0.6666667f, 0.16666667f}, {0.6666667f, 0.33333334f}, {0.6666667f, 0.16666667f}, {0.5555556f, 0.33333334f}, {0.6666667f, 0.33333334f}, {0.6666667f, 0.16666667f}, {0.7777778f, 0.16666667f}, {0.6666667f, 0.33333334f}, {0.8333333f, 0.16666667f}, {0.7777778f, 0.16666667f}, {0.8888889f, 0.0f}, {0.8333333f, 0.16666667f}, {0.7777778f, 0.16666667f}, {0.22222222f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.33333334f}, {0.33333334f, 0.33333334f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.33333334f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.6666667f}, {0.33333334f, 0.33333334f}, {0.5555556f, 0.33333334f}, {0.33333334f, 0.6666667f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.33333334f}, {0.0f, 0.6666667f}, {0.11111111f, 0.6666667f}, {0.33333334f, 0.33333334f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}, {0.44444445f, 0.33333334f}, {0.22222222f, 0.6666667f}, {0.33333334f, 0.6666667f}, {0.0f, 1.0f}, {0.11111111f, 0.6666667f}, {0.22222222f, 0.6666667f}};
                this.trianIndex = tIndex;
                this.barycentrCoor = bCoor;
                break;
            }
        }
    }

    private Coordinate[][] getInterpolatedTriangles2(Bezier2 newBezierTriangles) {
        Bezier[] bezierPatch = new Bezier[3];
        for (int i = 0; i < 3; ++i) {
            bezierPatch[i] = newBezierTriangles.getBezierPatch(i);
        }
        Coordinate[][] newTriangles = new Coordinate[(int)Math.pow(this.m_LoD + 1, 2.0)][3];
        if (this.m_LoD == 9) {
            newTriangles = new Coordinate[129][3];
        }
        int indexOfNewTriangles = 0;
        for (int i = 2; i < this.trianIndex.length - 1; i += 3) {
            for (int j = 0; j < 3; ++j) {
                newTriangles[indexOfNewTriangles][0] = bezierPatch[(this.trianIndex[i - 2] + j) % 3].getElevation(this.barycentrCoor[i - 2][0], this.barycentrCoor[i - 2][1], this.scaleZ);
                newTriangles[indexOfNewTriangles][1] = bezierPatch[(this.trianIndex[i - 1] + j) % 3].getElevation(this.barycentrCoor[i - 1][0], this.barycentrCoor[i - 1][1], this.scaleZ);
                newTriangles[indexOfNewTriangles][2] = bezierPatch[(this.trianIndex[i] + j) % 3].getElevation(this.barycentrCoor[i][0], this.barycentrCoor[i][1], this.scaleZ);
                ++indexOfNewTriangles;
            }
        }
        if (this.m_LoD != 2 && this.m_LoD != 5 && this.m_LoD != 8 && this.m_LoD != 9) {
            newTriangles[indexOfNewTriangles][0] = bezierPatch[0].getElevation(this.barycentrCoor[this.barycentrCoor.length - 3][0], this.barycentrCoor[this.barycentrCoor.length - 3][1], this.scaleZ);
            newTriangles[indexOfNewTriangles][1] = bezierPatch[1].getElevation(this.barycentrCoor[this.barycentrCoor.length - 2][0], this.barycentrCoor[this.barycentrCoor.length - 2][1], this.scaleZ);
            newTriangles[indexOfNewTriangles][2] = bezierPatch[2].getElevation(this.barycentrCoor[this.barycentrCoor.length - 1][0], this.barycentrCoor[this.barycentrCoor.length - 1][1], this.scaleZ);
        }
        return newTriangles;
    }

    private Coordinate[][] getInterpolatedTriangles(Bezier2 newBezierTriangles) {
        Coordinate[][] newTriangles = new Coordinate[(int)Math.pow(this.m_LoD + 1, 2.0) * 3][3];
        int indexOfNewTriangles = 0;
        double[] indexes = new double[this.m_LoD + 2];
        double koeficient = 1.0 / ((double)this.m_LoD + 1.0);
        for (int i = 0; i <= this.m_LoD + 1; ++i) {
            indexes[i] = koeficient * (double)i;
        }
        for (int k = 0; k < 3; ++k) {
            int j;
            int i;
            Bezier bezierTriangles2 = newBezierTriangles.getBezierPatch(k);
            int maxTi = this.m_LoD + 1;
            int maxTj = this.m_LoD;
            for (i = 0; i <= maxTi; ++i) {
                for (j = 0; j <= maxTj; ++j) {
                    newTriangles[indexOfNewTriangles][0] = bezierTriangles2.getElevation(indexes[i], indexes[j], this.scaleZ);
                    newTriangles[indexOfNewTriangles][1] = bezierTriangles2.getElevation(indexes[i], indexes[j + 1], this.scaleZ);
                    newTriangles[indexOfNewTriangles++][2] = bezierTriangles2.getElevation(indexes[i + 1], indexes[j], this.scaleZ);
                }
                --maxTj;
            }
            maxTj = this.m_LoD - 1;
            for (i = 1; i <= maxTi; ++i) {
                for (j = 0; j <= maxTj; ++j) {
                    newTriangles[indexOfNewTriangles][0] = bezierTriangles2.getElevation(indexes[i], indexes[j], this.scaleZ);
                    newTriangles[indexOfNewTriangles][1] = bezierTriangles2.getElevation(indexes[i], indexes[j + 1], this.scaleZ);
                    newTriangles[indexOfNewTriangles++][2] = bezierTriangles2.getElevation(indexes[i - 1], indexes[j + 1], this.scaleZ);
                }
                --maxTj;
            }
        }
        return newTriangles;
    }

    private LinkedList searchVectors(Bezier2 bezierT, Coordinate P, int indexOfBezierT) {
        LinkedList<Coordinate> vectors = new LinkedList<Coordinate>();
        List listOfTrianglesIndex = null;
        try {
            listOfTrianglesIndex = this.trianglesIndex.query(new Envelope(P));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iterTrianglesIndex = listOfTrianglesIndex.iterator();
        boolean haveBreakLine = false;
        boolean testingBreakLine = true;
        while (iterTrianglesIndex.hasNext()) {
            int index = (Integer)iterTrianglesIndex.next();
            Coordinate[] TT = this.triangles[index];
            switch (this.compareReturnIndex(TT, P)) {
                case 'A': {
                    if (testingBreakLine) {
                        haveBreakLine = this.testOfBreakLine('A', index);
                    }
                    Coordinate v1 = Bezier2.setVector(P, TT[1]);
                    Coordinate v2 = Bezier2.setVector(P, TT[2]);
                    double scalar = Bezier2.countScalarProduct(v1, v2);
                    double scalarJ = Bezier2.countScalarProduct(v1, v1) * Bezier2.countScalarProduct(v2, v2);
                    double alfa = Math.abs(scalar) < Math.abs(scalarJ) ? Math.acos(scalar / scalarJ) : 1.0;
                    Coordinate normal = Bezier2.setNormalVector(v1, v2);
                    vectors.add(new Coordinate(normal.x * alfa, normal.y * alfa, normal.z * alfa));
                    break;
                }
                case 'B': {
                    if (testingBreakLine) {
                        haveBreakLine = this.testOfBreakLine('B', index);
                    }
                    Coordinate v1 = Bezier2.setVector(P, TT[0]);
                    Coordinate v2 = Bezier2.setVector(P, TT[2]);
                    double scalar = Bezier2.countScalarProduct(v1, v2);
                    double scalarJ = Bezier2.countScalarProduct(v1, v1) * Bezier2.countScalarProduct(v2, v2);
                    double alfa = Math.abs(scalar) < Math.abs(scalarJ) ? Math.acos(scalar / scalarJ) : 1.0;
                    Coordinate normal = Bezier2.setNormalVector(v1, v2);
                    vectors.add(new Coordinate(normal.x * alfa, normal.y * alfa, normal.z * alfa));
                    break;
                }
                case 'C': {
                    if (testingBreakLine) {
                        haveBreakLine = this.testOfBreakLine('C', index);
                    }
                    Coordinate v1 = Bezier2.setVector(P, TT[0]);
                    Coordinate v2 = Bezier2.setVector(P, TT[1]);
                    double scalar = Bezier2.countScalarProduct(v1, v2);
                    double scalarJ = Bezier2.countScalarProduct(v1, v1) * Bezier2.countScalarProduct(v2, v2);
                    double alfa = Math.abs(scalar) < Math.abs(scalarJ) ? Math.acos(scalar / scalarJ) : 1.0;
                    Coordinate normal = Bezier2.setNormalVector(v1, v2);
                    vectors.add(new Coordinate(normal.x * alfa, normal.y * alfa, normal.z * alfa));
                }
            }
            if (!haveBreakLine) continue;
            testingBreakLine = false;
            haveBreakLine = false;
            vectors = new LinkedList();
            iterTrianglesIndex = this.setCorectTrianglesIndex(listOfTrianglesIndex, bezierT, P, indexOfBezierT).iterator();
        }
        return vectors;
    }

    private LinkedList setCorectTrianglesIndex(List<Integer> listOfTrianglesIndex, Bezier2 bezierT, Coordinate P, int indexOfBezierT) {
        TreeMap<Integer, Triangle> allTriangles = new TreeMap<Integer, Triangle>();
        TreeMap<Integer, Triangle> newTriangles = new TreeMap<Integer, Triangle>();
        for (int index : listOfTrianglesIndex) {
            Coordinate[] TT = this.triangles[index];
            Object typeOfBreakL = this.breakLines.get(index);
            int typeOfBreakLine = typeOfBreakL != null ? (Integer)typeOfBreakL : -1;
            switch (this.compareReturnIndex(TT, P)) {
                case 'A': {
                    allTriangles.put(index, new Triangle(index, TT, typeOfBreakLine));
                    break;
                }
                case 'B': {
                    if (typeOfBreakLine != -1) {
                        if (typeOfBreakLine < 3) {
                            typeOfBreakLine = (typeOfBreakLine + 2) % 3;
                        } else if (typeOfBreakLine != 6) {
                            typeOfBreakLine = (typeOfBreakLine + 2) % 3 + 3;
                        }
                    }
                    allTriangles.put(index, new Triangle(index, TT[1], TT[2], TT[0], typeOfBreakLine));
                    break;
                }
                case 'C': {
                    if (typeOfBreakLine != -1) {
                        if (typeOfBreakLine < 3) {
                            typeOfBreakLine = (typeOfBreakLine + 1) % 3;
                        } else if (typeOfBreakLine != 6) {
                            typeOfBreakLine = (typeOfBreakLine + 1) % 3 + 3;
                        }
                    }
                    allTriangles.put(index, new Triangle(index, TT[2], TT[0], TT[1], typeOfBreakLine));
                }
            }
        }
        Triangle T2 = (Triangle)allTriangles.get(indexOfBezierT);
        newTriangles.put(indexOfBezierT, T2);
        allTriangles.remove(indexOfBezierT);
        Triangle rightT = T2;
        boolean change = true;
        block8: while (rightT.typeOfBreakLine != 6 && rightT.typeOfBreakLine != 3 && rightT.typeOfBreakLine != 2 && rightT.typeOfBreakLine != 5 && !allTriangles.isEmpty() && change) {
            change = false;
            for (Triangle T2 : allTriangles.values()) {
                if (!rightT.coord[2].equals2D(T2.coord[1])) continue;
                change = true;
                newTriangles.put(T2.index, T2);
                allTriangles.remove(T2.index);
                rightT = T2;
                continue block8;
            }
        }
        Triangle leftT = (Triangle)newTriangles.get(indexOfBezierT);
        change = true;
        block10: while (leftT.typeOfBreakLine != 6 && leftT.typeOfBreakLine != 3 && leftT.typeOfBreakLine != 0 && leftT.typeOfBreakLine != 4 && !allTriangles.isEmpty() && change) {
            change = false;
            for (Triangle T2 : allTriangles.values()) {
                if (!leftT.coord[1].equals2D(T2.coord[2])) continue;
                change = true;
                newTriangles.put(T2.index, T2);
                allTriangles.remove(T2.index);
                leftT = T2;
                continue block10;
            }
        }
        LinkedList<Integer> finalTriangles = new LinkedList<Integer>();
        try {
            Iterator iterOfNewTriangles = newTriangles.values().iterator();
            while (iterOfNewTriangles.hasNext()) {
                finalTriangles.add(new Integer(((Triangle)iterOfNewTriangles.next()).index));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalTriangles;
    }

    private boolean testOfBreakLine(char vertex, int indexTT) {
        if (this.breakLines.containsKey(indexTT)) {
            Object typeOfBreakL = this.breakLines.get(indexTT);
            int typeOfBreakLine = typeOfBreakL != null ? (Integer)typeOfBreakL : -1;
            switch (vertex) {
                case 'A': {
                    return typeOfBreakLine != 1;
                }
                case 'B': {
                    return typeOfBreakLine != 2;
                }
                case 'C': {
                    return typeOfBreakLine != 0;
                }
            }
        }
        return false;
    }

    protected char compareReturnIndex(Coordinate[] triangle, Coordinate P) {
        if (P.equals2D(triangle[0])) {
            return 'A';
        }
        if (P.equals2D(triangle[1])) {
            return 'B';
        }
        if (P.equals2D(triangle[2])) {
            return 'C';
        }
        return 'N';
    }

    private class Triangle {
        int index;
        Coordinate[] coord = new Coordinate[3];
        int typeOfBreakLine;

        Triangle(int index, Coordinate[] coord, int typeOfBreakLine) {
            this.index = index;
            this.coord = coord;
            this.typeOfBreakLine = typeOfBreakLine;
        }

        Triangle(int index, Coordinate A, Coordinate B, Coordinate C, int typeOfBreakLine) {
            this.index = index;
            this.coord[0] = A;
            this.coord[1] = B;
            this.coord[2] = C;
            this.typeOfBreakLine = typeOfBreakLine;
        }

        void printToConsole() {
            System.out.println(this.coord[0]);
            System.out.println(this.coord[1]);
            System.out.println(this.coord[2]);
            System.out.println(this.index);
            System.out.println(this.typeOfBreakLine);
        }
    }
}

