/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.NNSpatialJoin;

import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.IteratorException;
import java.util.Properties;

public class SextanteRTree {
    private final RTree m_Tree;
    private final int m_iShapes;
    private final IFeature[] m_Features;

    public SextanteRTree(IVectorLayer layer, ITaskMonitor task) {
        task.setProgressText(Sextante.getText((String)"Creating_index"));
        this.m_Tree = new RTree();
        this.m_Tree.init(new Properties());
        this.m_iShapes = layer.getShapesCount();
        this.m_Features = new IFeature[this.m_iShapes];
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && !task.isCanceled()) {
            try {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                Envelope bounds = geom.getEnvelopeInternal();
                Rectangle rect = new Rectangle((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY());
                this.m_Tree.add(rect, new Integer(i).intValue());
                this.m_Features[i] = feature;
                if (i % 50 == 0) {
                    task.setProgress(i, this.m_iShapes);
                }
                ++i;
            }
            catch (IteratorException iteratorException) {}
        }
        iter.close();
    }

    public IFeature getClosestFeature(double x, double y) {
        Point pt = new Point((float)x, (float)y);
        int iIdx = this.m_Tree.nearest(pt);
        return this.m_Features[iIdx];
    }
}

