/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.constrainedDelaunay;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class ConstrainedDelaunayAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String LINES = "LINES";
    public static final String TRIANGLES = "TRIANGLES";
    private IVectorLayer m_Points;
    private IVectorLayer m_Lines;
    private IVectorLayer m_Triangles;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Constrained_Delaunay_triangulation"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points_layer"), 0, true);
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines_layer"), 1, true);
            this.addOutputVectorLayer(TRIANGLES, Sextante.getText((String)"Result"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_Lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_Lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] types = new Class[]{Integer.class};
        String[] sNames = new String[]{"ID"};
        this.m_Triangles = this.getNewVectorLayer(TRIANGLES, this.m_Points.getName() + "[" + Sextante.getText((String)"triangulated") + "]", 2, types, sNames);
        int i = 0;
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        int iShapeCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            list.add(feature.getGeometry());
            ++i;
        }
        iter.close();
        GeometryFactory gf = new GeometryFactory();
        GeometryCollection geomcolPoints = gf.createGeometryCollection(list.toArray(new Geometry[0]));
        i = 0;
        iShapeCount = this.m_Lines.getShapesCount();
        list.clear();
        iter = this.m_Lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            list.add(feature.getGeometry());
            ++i;
        }
        iter.close();
        GeometryCollection geomcolLines = gf.createGeometryCollection(list.toArray(new Geometry[0]));
        this.m_Task.setDeterminate(false);
        ConformingDelaunayTriangulationBuilder delaunay = new ConformingDelaunayTriangulationBuilder();
        delaunay.setSites((Geometry)geomcolPoints);
        delaunay.setConstraints((Geometry)geomcolLines);
        Geometry triangles = delaunay.getTriangles(gf);
        int iTriangles = triangles.getNumGeometries();
        for (int iTriangle = 0; iTriangle < iTriangles; ++iTriangle) {
            Geometry triangle = triangles.getGeometryN(iTriangle);
            Object[] record = new Object[]{new Integer(iTriangle)};
            this.m_Triangles.addFeature(triangle, record);
        }
        return !this.m_Task.isCanceled();
    }
}

