/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.dissolve;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DissolveAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String GROUPING_FIELD = "GROUPING_FIELD";
    public static final String GROUPING_FUNCTIONS = "GROUPING_FUNCTIONS";
    public static final int SUM = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int AVG = 3;
    public static final String[] FUNCTIONS = new String[]{"SUM", "MIN", "MAX", "AVG"};
    private IVectorLayer m_LayerIn;
    private int m_iField;
    private Grouping[] m_Groupings;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_LayerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_LayerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_iField = this.m_Parameters.getParameterValueAsInt(GROUPING_FIELD);
        String sGroupings = this.m_Parameters.getParameterValueAsString(GROUPING_FUNCTIONS);
        this.m_Groupings = this.getGroupings(sGroupings);
        String[] sFields = new String[1 + this.m_Groupings.length];
        Class[] types = new Class[1 + this.m_Groupings.length];
        sFields[0] = Sextante.getText((String)"Class");
        types[0] = String.class;
        for (int i = 0; i < this.m_Groupings.length; ++i) {
            sFields[i + 1] = this.m_LayerIn.getFieldName(this.m_Groupings[i].field) + "_" + FUNCTIONS[this.m_Groupings[i].function];
            types[i + 1] = Double.class;
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, this.m_LayerIn.getName(), this.m_LayerIn.getShapeType(), types, sFields);
        int iShapesCount = this.m_LayerIn.getShapesCount();
        HashMap<String, Geometry> geoms = new HashMap<String, Geometry>();
        HashMap[] stats = new HashMap[this.m_LayerIn.getFieldCount()];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = new HashMap();
        }
        IFeatureIterator iter = this.m_LayerIn.iterator();
        int i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            String sClass = feature.getRecord().getValue(this.m_iField).toString();
            Geometry geom = (Geometry)geoms.get(sClass);
            if (geom == null) {
                geoms.put(sClass, feature.getGeometry());
                for (HashMap element : stats) {
                    element.put(sClass, new SimpleStats());
                }
            } else {
                try {
                    geom = EnhancedPrecisionOp.union((Geometry)geom, (Geometry)feature.getGeometry());
                }
                catch (Exception e) {
                    geom = EnhancedPrecisionOp.union((Geometry)geom.buffer(0.0), (Geometry)feature.getGeometry());
                }
                geoms.put(sClass, geom);
            }
            IRecord record = feature.getRecord();
            for (int j = 0; j < stats.length; ++j) {
                try {
                    double dValue = Double.parseDouble(record.getValue(j).toString());
                    ((SimpleStats)stats[j].get(sClass)).addValue(dValue);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Set set = geoms.keySet();
        Iterator keys = set.iterator();
        i = 0;
        while (keys.hasNext() && this.setProgress(i, geoms.size())) {
            String sClass = (String)keys.next();
            SimpleStats[] stat = new SimpleStats[this.m_LayerIn.getFieldCount()];
            for (int j = 0; j < stat.length; ++j) {
                stat[j] = (SimpleStats)stats[j].get(sClass);
            }
            Object[] values = this.calculateRecord(stat, sClass);
            output.addFeature((Geometry)geoms.get(sClass), values);
            ++i;
        }
        return !this.m_Task.isCanceled();
    }

    private Object[] calculateRecord(SimpleStats[] stats, String sClass) {
        Object[] values = new Object[this.m_Groupings.length + 1];
        values[0] = sClass;
        for (int i = 0; i < this.m_Groupings.length; ++i) {
            double dValue;
            int iField = this.m_Groupings[i].field;
            int iFunction = this.m_Groupings[i].function;
            switch (iFunction) {
                case 1: {
                    dValue = stats[iField].getMin();
                    break;
                }
                case 2: {
                    dValue = stats[iField].getMax();
                    break;
                }
                case 0: {
                    dValue = stats[iField].getSum();
                    break;
                }
                default: {
                    dValue = stats[iField].getMean();
                }
            }
            values[i + 1] = stats[iField].getCount() > 0 ? new Double(dValue) : null;
        }
        return values;
    }

    private Grouping[] getGroupings(String sGroupings) throws GeoAlgorithmExecutionException {
        if (sGroupings.trim().equals("")) {
            return new Grouping[0];
        }
        try {
            String[] sTokens = sGroupings.split(",");
            if (sTokens.length % 2 != 0) {
                throw new GeoAlgorithmExecutionException("Wrong groupings");
            }
            Grouping[] groupings = new Grouping[sTokens.length / 2];
            int iGrouping = 0;
            for (int i = 0; i < sTokens.length - 1; ++i) {
                groupings[iGrouping] = new Grouping();
                groupings[iGrouping].field = Integer.parseInt(sTokens[i]);
                if (groupings[iGrouping].field >= this.m_LayerIn.getFieldCount() || groupings[iGrouping].field < 0) {
                    throw new GeoAlgorithmExecutionException("Wrong groupings");
                }
                groupings[iGrouping].function = Integer.parseInt(sTokens[++i]);
                if (groupings[iGrouping].function > 4 || groupings[iGrouping].function < 0) {
                    throw new GeoAlgorithmExecutionException("Wrong groupings");
                }
                ++iGrouping;
            }
            return groupings;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException("Wrong groupings");
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Dissolve"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addTableField(GROUPING_FIELD, Sextante.getText((String)"Field_with_class_name"), LAYER);
            this.m_Parameters.addString(GROUPING_FUNCTIONS, Sextante.getText((String)"Summary_statistics"));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private class Grouping {
        public int field;
        public int function;
    }
}

