/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.distanceToClosestGeometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.vectorTools.distanceToClosestGeometry.SextanteRTree;

public class DistanceToClosestGeometryAlgorithm
extends GeoAlgorithm {
    public static final String DISTTO = "SNAPTO";
    public static final String LAYER = "LAYER";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String RESULT = "RESULT";
    public static final String FIELD = "FIELD";
    private IVectorLayer m_Points;
    private IVectorLayer m_Geometries;
    private IVectorLayer m_Output;
    private SextanteRTree m_NNF;
    private int m_iField;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Distance_to_closest_geometry"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(DISTTO, Sextante.getText((String)"Lines_layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), DISTTO);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_Geometries = this.m_Parameters.getParameterValueAsVectorLayer(DISTTO);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_Geometries.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_NNF = new SextanteRTree(this.m_Geometries, this.m_Task);
        Class[] types = new Class[this.m_Points.getFieldCount() + 2];
        String[] sFields = new String[this.m_Points.getFieldCount() + 2];
        for (int j = 0; j < sFields.length - 2; ++j) {
            types[j] = this.m_Points.getFieldTypes()[j];
            sFields[j] = this.m_Points.getFieldName(j);
        }
        sFields[sFields.length - 2] = "ID";
        sFields[sFields.length - 1] = "DIST";
        types[types.length - 2] = String.class;
        types[types.length - 1] = Double.class;
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Distance_to_closest_geometry"), 0, types, sFields);
        int i = 0;
        int iShapeCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.processPoint(feature);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void processPoint(IFeature feature) {
        Geometry geom = feature.getGeometry();
        Coordinate coord = geom.getCoordinate();
        IFeature closest = this.m_NNF.getClosestFeature(coord.x, coord.y);
        Object[] record = feature.getRecord().getValues();
        Object[] attribs = new Object[record.length + 2];
        for (int i = 0; i < attribs.length - 2; ++i) {
            attribs[i] = record[i];
        }
        attribs[attribs.length - 2] = closest.getRecord().getValue(this.m_iField);
        double dDist = feature.getGeometry().distance(closest.getGeometry());
        attribs[attribs.length - 1] = new Double(dDist);
        this.m_Output.addFeature(feature.getGeometry(), attribs);
    }
}

