/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.geometricPropertiesLines;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.shapesTools.ShapesTools;

public class GeometricPropertiesLinesAlgorithm
extends GeoAlgorithm {
    private static final String RESULT = "RESULT";
    private static final String LINES = "LINES";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Geometric_properties_of_lines"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Layer"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, LINES);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class};
        String[] sFields = new String[]{Sextante.getText((String)"Length"), Sextante.getText((String)"Straight_length"), Sextante.getText((String)"Sinuosity"), Sextante.getText((String)"Average_angle"), Sextante.getText((String)"Direction")};
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if (lines.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException("zero lines in layer");
        }
        int i = 0;
        int iShapesCount = lines.getShapesCount();
        Object[][] values = new Object[5][iShapesCount];
        IFeatureIterator iter = lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            LineProperties lp = this.getProperties(feature.getGeometry());
            values[0][i] = new Double(lp.length);
            values[1][i] = new Double(lp.straightLength);
            values[2][i] = new Double(lp.sinuosity);
            values[3][i] = new Double(lp.angleStats.getMean());
            values[4][i] = new Double(lp.direction);
            ++i;
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        Output out = this.m_OutputObjects.getOutput(RESULT);
        out.setDescription(lines.getName());
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)lines, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        return !this.m_Task.isCanceled();
    }

    private LineProperties getProperties(Geometry geometry) {
        double dDifY;
        double dDifX;
        double y;
        double x;
        double dDist = 0.0;
        Coordinate[] coords = geometry.getCoordinates();
        double dInitX = x = coords[0].x;
        double dInitY = y = coords[0].y;
        LineProperties lp = new LineProperties();
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0 && i < coords.length - 1) {
                lp.angleStats.addValue(this.getAngle(coords[i - 1], coords[i], coords[i + 1]));
            }
            dDifX = coords[i].x - x;
            dDifY = coords[i].y - y;
            dDist += Math.sqrt(dDifX * dDifX + dDifY * dDifY);
            x = coords[i].x;
            y = coords[i].y;
        }
        dDifX = x - dInitX;
        dDifY = y - dInitY;
        double dStraightDist = Math.sqrt(Math.pow(dDifX, 2.0) + Math.pow(dDifY, 2.0));
        double dDirection = Math.toDegrees(Math.atan2(dDifX, dDifY));
        lp.length = dDist;
        lp.straightLength = dStraightDist;
        lp.sinuosity = dDist / dStraightDist;
        lp.direction = dDirection;
        return lp;
    }

    private double getAngle(Coordinate p1, Coordinate p2, Coordinate p3) {
        return Math.toDegrees(Angle.angleBetween((Coordinate)p1, (Coordinate)p2, (Coordinate)p3));
    }

    private class LineProperties {
        public double length;
        public double straightLength;
        public double sinuosity;
        public double direction;
        public SimpleStats angleStats = new SimpleStats();

        private LineProperties() {
        }
    }
}

