/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.geometricPropertiesLinesB;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.ArrayList;

public class GeometricPropertiesLinesBAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    public static final String DISTANCE = "DISTANCE";
    public static final String DEM = "DEM";
    private IRasterLayer m_DEM;
    private double m_dDist;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Geometric_properties_of_lines_b"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Layer"), 1, true);
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)DEM), true);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Distance_between_points"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, LINES);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        String[] sFields = new String[]{Sextante.getText((String)"Length"), Sextante.getText((String)"Straight_length"), Sextante.getText((String)"Sinuosity"), Sextante.getText((String)"Average_angle"), Sextante.getText((String)"Direction"), Sextante.getText((String)"Slope"), "Max." + Sextante.getText((String)"Slope")};
        this.m_dDist = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if (lines.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException("zero lines in layer");
        }
        int i = 0;
        int iShapesCount = lines.getShapesCount();
        Object[][] values = new Object[sFields.length][iShapesCount];
        IFeatureIterator iter = lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            LineProperties lp = this.getProperties(feature.getGeometry());
            AdditionalStats stats = this.getAdditionalStats(feature.getGeometry());
            values[0][i] = new Double(lp.length);
            values[1][i] = new Double(lp.straightLength);
            values[2][i] = new Double(lp.sinuosity);
            values[3][i] = new Double(stats.meanAngle);
            values[4][i] = new Double(lp.direction);
            values[5][i] = new Double(stats.meanSlope * 100.0);
            values[6][i] = new Double(stats.maxSlope * 100.0);
            ++i;
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        Output out = this.m_OutputObjects.getOutput(RESULT);
        out.setDescription(lines.getName());
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)lines, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        return !this.m_Task.isCanceled();
    }

    private AdditionalStats getAdditionalStats(Geometry geom) {
        double dDist;
        double dY1;
        double dX1;
        double dRemainingDistFromLastSegment = 0.0;
        Coordinate[] coords = geom.getCoordinates();
        ArrayList<Point> points = new ArrayList<Point>();
        GeometryFactory gf = new GeometryFactory();
        double dAddedPointX = dX1 = coords[0].x;
        double dAddedPointY = dY1 = coords[0].y;
        Point point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
        points.add(point);
        for (int i = 0; i < coords.length - 1; ++i) {
            double dX2 = coords[i + 1].x;
            dX1 = coords[i].x;
            double dDX = dX2 - dX1;
            double dY2 = coords[i + 1].y;
            dY1 = coords[i].y;
            double dDY = dY2 - dY1;
            double dDistToNextPoint = Math.sqrt(dDX * dDX + dDY * dDY);
            if (dRemainingDistFromLastSegment + dDistToNextPoint > this.m_dDist) {
                int iPoints = (int)((dRemainingDistFromLastSegment + dDistToNextPoint) / this.m_dDist);
                dDist = this.m_dDist - dRemainingDistFromLastSegment;
                for (int j = 0; j < iPoints; ++j) {
                    dDist = this.m_dDist - dRemainingDistFromLastSegment;
                    dAddedPointX = dX1 + (dDist += (double)j * this.m_dDist) * dDX / dDistToNextPoint;
                    dAddedPointY = dY1 + dDist * dDY / dDistToNextPoint;
                    point = gf.createPoint(new Coordinate(dAddedPointX, dAddedPointY));
                    points.add(point);
                }
                dDX = dX2 - dAddedPointX;
                dDY = dY2 - dAddedPointY;
                dRemainingDistFromLastSegment = Math.sqrt(dDX * dDX + dDY * dDY);
                continue;
            }
            dRemainingDistFromLastSegment += dDistToNextPoint;
        }
        SimpleStats slopeStats = new SimpleStats();
        SimpleStats angleStats = new SimpleStats();
        for (int k = 0; k < points.size() - 1; ++k) {
            point = (Point)points.get(k);
            double dElevation = this.m_DEM.getValueAt(point.getX(), point.getY());
            Point point2 = (Point)points.get(k + 1);
            double dElevation2 = this.m_DEM.getValueAt(point2.getX(), point2.getY());
            dDist = Math.sqrt(Math.pow(point.getX() - point2.getX(), 2.0) + Math.pow(point.getY() - point2.getY(), 2.0));
            double dSlope = Math.abs((dElevation2 - dElevation) / dDist);
            slopeStats.addValue(dSlope);
            if (k <= 0 || k >= points.size() - 2) continue;
            Point point3 = (Point)points.get(k + 2);
            double dAngle = this.getAngle(point, point2, point3);
            angleStats.addValue(dAngle);
        }
        AdditionalStats aStats = new AdditionalStats();
        aStats.maxSlope = slopeStats.getMax();
        aStats.meanSlope = slopeStats.getMean();
        aStats.meanAngle = angleStats.getMean();
        return aStats;
    }

    private LineProperties getProperties(Geometry geometry) {
        double dDifY;
        double dDifX;
        double y;
        double x;
        double dDist = 0.0;
        Coordinate[] coords = geometry.getCoordinates();
        double dInitX = x = coords[0].x;
        double dInitY = y = coords[0].y;
        LineProperties lp = new LineProperties();
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0 && i < coords.length - 1) {
                lp.angleStats.addValue(this.getAngle(coords[i - 1], coords[i], coords[i + 1]));
            }
            dDifX = coords[i].x - x;
            dDifY = coords[i].y - y;
            dDist += Math.sqrt(dDifX * dDifX + dDifY * dDifY);
            x = coords[i].x;
            y = coords[i].y;
        }
        dDifX = x - dInitX;
        dDifY = y - dInitY;
        double dStraightDist = Math.sqrt(Math.pow(dDifX, 2.0) + Math.pow(dDifY, 2.0));
        double dDirection = Math.toDegrees(Math.atan2(dDifX, dDifY));
        lp.length = dDist;
        lp.straightLength = dStraightDist;
        lp.sinuosity = dDist / dStraightDist;
        lp.direction = dDirection;
        return lp;
    }

    private double getAngle(Coordinate p1, Coordinate p2, Coordinate p3) {
        return Math.toDegrees(Angle.angleBetween((Coordinate)p1, (Coordinate)p2, (Coordinate)p3));
    }

    private double getAngle(Point p1, Point p2, Point p3) {
        Coordinate c1 = new Coordinate(p1.getX(), p1.getY());
        Coordinate c2 = new Coordinate(p2.getX(), p2.getY());
        Coordinate c3 = new Coordinate(p3.getX(), p3.getY());
        return Math.toDegrees(Angle.angleBetween((Coordinate)c1, (Coordinate)c2, (Coordinate)c3));
    }

    private class AdditionalStats {
        public double meanSlope;
        public double maxSlope;
        public double meanAngle;

        private AdditionalStats() {
        }
    }

    private class LineProperties {
        public double length;
        public double straightLength;
        public double sinuosity;
        public double direction;
        public SimpleStats angleStats = new SimpleStats();

        private LineProperties() {
        }
    }
}

