/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.gridStatisticsInPolygons;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.ArrayList;
import java.util.Arrays;

public class GridStatisticsInPolygonsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String GRIDS = "GRIDS";
    public static final String LAYER = "LAYER";
    private static final Double NODATA = new Double(-99999.0);
    private int m_iNX;
    private int m_iNY;
    private IVectorLayer m_Layer;
    private AnalysisExtent m_Extent;
    private IRasterLayer m_Window;
    private ArrayList m_Grids;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Grid_statistics_in_polygons"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polygons"), 2, true);
            this.m_Parameters.addMultipleInput(GRIDS, Sextante.getText((String)"Grids"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Polygons"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        int iLayer = 0;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_Grids = this.m_Parameters.getParameterValueAsArrayList(GRIDS);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iShapeCount = this.m_Layer.getShapesCount();
        SimpleStats[][] stats = new SimpleStats[this.m_Grids.size()][iShapeCount];
        for (iLayer = 0; iLayer < this.m_Grids.size() && this.setProgress(iLayer, this.m_Grids.size()); ++iLayer) {
            this.m_Window = (IRasterLayer)this.m_Grids.get(iLayer);
            this.m_Window.setFullExtent();
            this.m_Extent = this.m_Window.getWindowGridExtent();
            Coordinate[] coords = new Coordinate[]{new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getXMax(), this.m_Extent.getYMax()), new Coordinate(this.m_Extent.getXMax(), this.m_Extent.getYMin()), new Coordinate(this.m_Extent.getXMin(), this.m_Extent.getYMin())};
            GeometryFactory gf = new GeometryFactory();
            LinearRing ring = gf.createLinearRing(coords);
            Polygon extent = gf.createPolygon(ring, null);
            this.m_iNX = this.m_Window.getNX();
            this.m_iNY = this.m_Window.getNY();
            IFeatureIterator iter = this.m_Layer.iterator();
            i = 0;
            while (iter.hasNext() && !this.m_Task.isCanceled()) {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                if (geom.intersects((Geometry)extent)) {
                    stats[iLayer][i] = this.doPolygon(geom);
                }
                ++i;
            }
            iter.close();
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Object[][] values = new Double[this.m_Grids.size() * 4][iShapeCount];
        String[] sNames = new String[this.m_Grids.size() * 4];
        Class[] types = new Class[this.m_Grids.size() * 4];
        for (i = 0; i < this.m_Grids.size() * 4; i += 4) {
            int j;
            int iGrid = i / 4;
            IRasterLayer grid = (IRasterLayer)this.m_Grids.get(iGrid);
            String sName = grid.getName();
            sNames[i] = Sextante.getText((String)"AVG") + "_" + sName;
            sNames[i + 1] = Sextante.getText((String)"VAR") + "_" + sName;
            sNames[i + 2] = Sextante.getText((String)"MIN") + "_" + sName;
            sNames[i + 3] = Sextante.getText((String)"MAX") + "_" + sName;
            for (j = 0; j < 4; ++j) {
                types[i + j] = Double.class;
            }
            for (j = 0; j < iShapeCount; ++j) {
                if (stats[iGrid][j] != null) {
                    values[i][j] = new Double(stats[iGrid][j].getMean());
                    values[i + 1][j] = new Double(stats[iGrid][j].getVariance());
                    values[i + 2][j] = new Double(stats[iGrid][j].getMin());
                    values[i + 3][j] = new Double(stats[iGrid][j].getMax());
                    continue;
                }
                values[i][j] = NODATA;
                values[i + 1][j] = NODATA;
                values[i + 2][j] = NODATA;
                values[i + 3][j] = NODATA;
            }
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(this.m_Layer.getName());
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)this.m_Layer, (IOutputChannel)channel, (String[])sNames, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }

    private SimpleStats doPolygon(Geometry geom) {
        SimpleStats stats = new SimpleStats();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part, stats);
        }
        return stats;
    }

    private void doPolygonPart(Geometry geom, SimpleStats stats) {
        int xStop;
        Coordinate p = new Coordinate();
        boolean[] bCrossing = new boolean[this.m_iNX];
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) + 1) >= this.m_iNX) {
            xStop = this.m_iNX - 1;
        }
        Coordinate[] points = geom.getCoordinates();
        int y = 0;
        double yPos = this.m_Extent.getYMax();
        while (y < this.m_iNY) {
            if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                Arrays.fill(bCrossing, false);
                Coordinate pLeft = new Coordinate(this.m_Extent.getXMin() - 1.0, yPos);
                Coordinate pRight = new Coordinate(this.m_Extent.getXMax() + 1.0, yPos);
                Coordinate pb = points[points.length - 1];
                for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                    Coordinate pa = pb;
                    pb = points[iPoint];
                    if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                    this.getCrossing(p, pa, pb, pLeft, pRight);
                    int ix = (int)((p.x - this.m_Extent.getXMin()) / this.m_Extent.getCellSize() + 1.0);
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= this.m_iNX) {
                        ix = this.m_iNX - 1;
                    }
                    bCrossing[ix] = !bCrossing[ix];
                }
                boolean bFill = false;
                for (int x = xStart; x <= xStop; ++x) {
                    double dValue;
                    if (bCrossing[x]) {
                        boolean bl = bFill = !bFill;
                    }
                    if (!bFill || this.m_Window.isNoDataValue(dValue = this.m_Window.getCellValueAsDouble(x, y))) continue;
                    stats.addValue(dValue);
                }
            }
            ++y;
            yPos -= this.m_Extent.getCellSize();
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }
}

