/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.groupNearFeatures;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.tools.exception.BaseException;

public class GroupNearFeaturesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Group_near_features"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 5.0, 1.0E-4, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int subtype;
        boolean i = false;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        double tolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] in_ftypes = layerIn.getFieldTypes();
        Class[] out_ftypes = new Class[in_ftypes.length + 1];
        System.arraycopy(in_ftypes, 0, out_ftypes, 0, in_ftypes.length);
        out_ftypes[out_ftypes.length - 1] = Integer.class;
        String[] in_fnames = layerIn.getFieldNames();
        String[] out_fnames = new String[in_ftypes.length + 1];
        System.arraycopy(in_fnames, 0, out_fnames, 0, in_fnames.length);
        out_fnames[out_fnames.length - 1] = "GROUP_ID";
        try {
            subtype = layerIn.getSubType();
        }
        catch (BaseException e) {
            subtype = 4;
        }
        IVectorLayer driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Grouped_Layer"), layerIn.getShapeType(), out_ftypes, out_fnames, subtype);
        int iTotal = layerIn.getShapesCount();
        int groupID = 0;
        int[] groupedMap = new int[iTotal];
        for (int k = 0; k < iTotal; ++k) {
            groupedMap[k] = -1;
        }
        HashMap<Integer, ArrayList> groupGeoms = new HashMap<Integer, ArrayList>();
        IFeatureIterator iter1 = layerIn.iterator();
        Object[] values = new Object[out_fnames.length];
        int featCount1 = 0;
        while (iter1.hasNext()) {
            IFeature feat1 = iter1.next();
            Geometry geom1 = feat1.getGeometry();
            if (groupedMap[featCount1] == -1) {
                groupedMap[featCount1] = groupID;
                ArrayList geomArray = new ArrayList();
                geomArray.add(geom1);
                groupGeoms.put(groupID, geomArray);
                Object[] aux_values = feat1.getRecord().getValues();
                System.arraycopy(aux_values, 0, values, 0, aux_values.length);
                values[values.length - 1] = groupID;
                driver.addFeature(geom1, values);
                IFeatureIterator iter2 = layerIn.iterator();
                int featCount2 = 0;
                while (iter2.hasNext()) {
                    IFeature feat2 = iter2.next();
                    if (groupedMap[featCount2] == -1) {
                        Geometry geom2 = feat2.getGeometry();
                        geomArray = (ArrayList)groupGeoms.get(groupID);
                        for (int j = 0; j < geomArray.size(); ++j) {
                            geom1 = (Geometry)geomArray.get(j);
                            double dist = geom1.distance(geom2);
                            if (!(dist < tolerance)) continue;
                            groupedMap[featCount2] = groupID;
                            geomArray = (ArrayList)groupGeoms.get(groupID);
                            geomArray.add(geom2);
                            aux_values = feat2.getRecord().getValues();
                            System.arraycopy(aux_values, 0, values, 0, aux_values.length);
                            values[values.length - 1] = groupID;
                            driver.addFeature(geom2, values);
                            iter2 = layerIn.iterator();
                            featCount2 = -1;
                            break;
                        }
                    }
                    ++featCount2;
                }
                iter2.close();
                ++groupID;
                this.setProgress(0, iTotal);
            }
            ++featCount1;
        }
        iter1.close();
        return !this.m_Task.isCanceled();
    }
}

