/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.medialAxis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import gishur.core.SimpleList;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XSegment;
import gishur.x.voronoi.Skeleton;
import java.util.ArrayList;

public class MedialAxisAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IVectorLayer result = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Medial_Axis"), 1, layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            MultiLineString axis = this.getMedialAxis((Polygon)feature.getGeometry().getGeometryN(0));
            result.addFeature((Geometry)axis, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Medial_Axis"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polygons"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Medial_Axis"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private MultiLineString getMedialAxis(Polygon poly) {
        ArrayList<LineString> list = new ArrayList<LineString>();
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = poly.getExteriorRing().getCoordinates();
        XPoint[] xpoints = new XPoint[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            xpoints[i] = new XPoint(coords[i].x, coords[i].y);
        }
        XPolygon xpoly = new XPolygon(xpoints);
        Skeleton skeleton = new Skeleton(xpoly);
        skeleton.execute();
        SimpleList lines = skeleton.getLines(false);
        Object[] array = lines.convertValuesToArray();
        for (int i = 0; i < array.length; ++i) {
            XSegment segment = (XSegment)array[i];
            System.out.println(segment.toString());
            Coordinate[] segmentCoords = new Coordinate[]{new Coordinate(segment.getStartPoint().x, segment.getStartPoint().y), new Coordinate(segment.getEndPoint().x, segment.getEndPoint().y)};
            list.add(gf.createLineString(segmentCoords));
        }
        return gf.createMultiLineString(list.toArray(new LineString[0]));
    }
}

