/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.placePointsOnLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.parameters.FixedTableModel;
import java.util.ArrayList;
import java.util.HashMap;

public class PlacePointsOnLinesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String FIELD = "FIELD";
    public static final String TABLE = "TABLE";
    public static final String LINES = "LINES";
    private IVectorLayer m_Output;
    private HashMap<String, ArrayList<Double>> m_Map;
    private int m_iField;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Map = new HashMap();
        try {
            this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
            IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
            FixedTableModel table = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(TABLE);
            for (int j = 0; j < table.getRowCount(); ++j) {
                String sName = table.getValueAt(j, 0).toString();
                String sDistance = table.getValueAt(j, 1).toString();
                ArrayList<Double> distances = this.m_Map.get(sName);
                if (distances == null) {
                    distances = new ArrayList();
                    this.m_Map.put(sName, distances);
                }
                distances.add(Double.parseDouble(sDistance));
            }
            this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Points") + "(" + lines.getName() + ")", 0, new Class[]{String.class}, new String[]{"ID"});
            int i = 0;
            int iShapeCount = lines.getShapesCount();
            IFeatureIterator iter = lines.iterator();
            while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                IFeature feature = iter.next();
                this.processLine(feature);
                ++i;
            }
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        return !this.m_Task.isCanceled();
    }

    private void processLine(IFeature feature) {
        String sName = feature.getRecord().getValue(this.m_iField).toString();
        ArrayList<Double> distances = this.m_Map.get(sName);
        if (distances != null) {
            for (int i = 0; i < distances.size(); ++i) {
                this.addPoint(feature, distances.get(i));
            }
        }
    }

    private void addPoint(IFeature feature, Double dist) {
        GeometryFactory gf = new GeometryFactory();
        boolean bPointAdded = false;
        double dDist = 0.0;
        Coordinate[] coords = feature.getGeometry().getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            double dDistToNextPoint = coords[i].distance(coords[i + 1]);
            if (dDist + dDistToNextPoint > dist) {
                double dDistToPoint = dist - dDist;
                double dRatio = dDistToPoint / dDistToNextPoint;
                double dDifX = coords[i + 1].x - coords[i].x;
                double dDifY = coords[i + 1].y - coords[i].y;
                Coordinate coord = new Coordinate(coords[i].x + dDifX * dRatio, coords[i].y + dDifY * dRatio);
                this.m_Output.addFeature((Geometry)gf.createPoint(coord), feature.getRecord().getValues());
                bPointAdded = true;
                break;
            }
            dDist += dDistToNextPoint;
        }
        if (!bPointAdded) {
            String sName = feature.getRecord().getValue(this.m_iField).toString();
            Sextante.addWarningToLog((String)(Sextante.getText((String)"Could_not_add_point_distance_too_large") + ": " + sName + "," + dist.toString()));
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Place_point_on_line_at_distance"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LINES);
            this.m_Parameters.addFixedTable(TABLE, Sextante.getText((String)"Table"), new String[]{Sextante.getText((String)"Name"), Sextante.getText((String)"Distance")}, 1, false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Points"), 0);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

