/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.polygonsToPolylines;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class PolygonsToPolylinesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Polygons_to_polylines"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polygons"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1, this.m_Layer.getFieldTypes(), this.m_Layer.getFieldNames());
        ArrayList<LineString> array = new ArrayList<LineString>();
        GeometryFactory gf = new GeometryFactory();
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        int i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            array.clear();
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                if (!(subgeom instanceof Polygon)) continue;
                Polygon poly = (Polygon)subgeom;
                array.add(poly.getExteriorRing());
                for (int k = 0; k < poly.getNumInteriorRing(); ++k) {
                    array.add(poly.getInteriorRingN(k));
                }
            }
            if (array.size() != 0) {
                LineString[] lines = new LineString[array.size()];
                for (int j = 0; j < array.size(); ++j) {
                    lines[j] = (LineString)array.get(j);
                }
                this.m_Output.addFeature((Geometry)gf.createMultiLineString(lines), feature.getRecord().getValues());
            }
            ++i;
        }
        return !this.m_Task.isCanceled();
    }
}

