/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.polylinesToPolygons;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class PolylinesToPolygonsAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Polylines_to_polygons"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polylines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Polygons"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Layer.getName(), 2, this.m_Layer.getFieldTypes(), this.m_Layer.getFieldNames());
        ArrayList<Polygon> array = new ArrayList<Polygon>();
        GeometryFactory gf = new GeometryFactory();
        int iShapeCount = this.m_Layer.getShapesCount();
        IFeatureIterator iter = this.m_Layer.iterator();
        int i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            array.clear();
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                Coordinate[] lineCoords = subgeom.getCoordinates();
                Coordinate[] ringCoords = new Coordinate[lineCoords.length + 1];
                System.arraycopy(lineCoords, 0, ringCoords, 0, lineCoords.length);
                ringCoords[lineCoords.length] = new Coordinate(lineCoords[0].x, lineCoords[0].y);
                LinearRing ring = gf.createLinearRing(ringCoords);
                Polygon polygon = gf.createPolygon(ring, null);
                array.add(polygon);
            }
            Polygon[] polygons = new Polygon[array.size()];
            for (int j = 0; j < array.size(); ++j) {
                polygons[j] = (Polygon)array.get(j);
            }
            this.m_Output.addFeature((Geometry)gf.createMultiPolygon(polygons), feature.getRecord().getValues());
            ++i;
        }
        return !this.m_Task.isCanceled();
    }
}

