/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.removeHoles;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;
import java.util.Arrays;

public class RemoveHolesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IVectorLayer driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), layer.getShapeType(), layer.getFieldTypes(), layer.getFieldNames());
        int iTotal = layer.getShapesCount();
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            ArrayList<Polygon> list = new ArrayList<Polygon>();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                list.add(this.removeHoles(geom.getGeometryN(j)));
            }
            MultiPolygon resultingGeom = geom.getFactory().createMultiPolygon(list.toArray(new Polygon[0]));
            driver.addFeature((Geometry)resultingGeom, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Remove_holes"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private Polygon removeHoles(Geometry geom) {
        if (!(geom instanceof Polygon)) {
            return null;
        }
        Polygon polygon = (Polygon)geom;
        LineString outer = polygon.getExteriorRing();
        if (outer.getStartPoint().distance((Geometry)outer.getEndPoint()) != 0.0) {
            ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(outer.getCoordinates()));
            clist.add(outer.getStartPoint().getCoordinate());
            outer = outer.getFactory().createLinearRing(clist.toArray(new Coordinate[clist.size()]));
        }
        LinearRing r = (LinearRing)outer;
        return outer.getFactory().createPolygon(r, null);
    }
}

