/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.removeRepeatedGeometries;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.HashMap;

public class RemoveRepeatedGeometriesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Remove_repeated_geometries"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Unique_Geometries"), -1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IVectorLayer driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Unique_Geometries"), layerIn.getShapeType(), layerIn.getFieldTypes(), layerIn.getFieldNames());
        HashMap<String, Boolean> geomHashMap = new HashMap<String, Boolean>();
        int iTotal = layerIn.getShapesCount();
        IFeatureIterator iter = layerIn.iterator();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feat = iter.next();
            Geometry geom = feat.getGeometry();
            Object[] values = feat.getRecord().getValues();
            if (geomHashMap.containsKey(geom.toText())) continue;
            geomHashMap.put(geom.toText(), true);
            driver.addFeature(geom, values);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

