/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.splitLinesWithPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.vectorTools.splitLinesWithPoints.PtAndAttributes;
import java.util.List;

public class NearestNeighbourFinder {
    private final STRtree m_Tree;
    private final int m_iPoints;
    private final double[] m_dX;
    private final double[] m_dY;
    private final Object[] m_Attributes;

    public NearestNeighbourFinder(IVectorLayer layer, ITaskMonitor task) throws IteratorException {
        task.setProgressText(Sextante.getText((String)"Creating_index"));
        this.m_Tree = new STRtree();
        this.m_iPoints = layer.getShapesCount();
        this.m_dX = new double[this.m_iPoints];
        this.m_dY = new double[this.m_iPoints];
        this.m_Attributes = new Object[this.m_iPoints];
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && !task.isCanceled()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            float x = (float)coord.x;
            float y = (float)coord.y;
            Envelope bounds = geom.getEnvelopeInternal();
            this.m_Tree.insert(bounds, (Object)new Integer(i));
            this.m_dX[i] = x;
            this.m_dY[i] = y;
            this.m_Attributes[i] = feature.getRecord().getValues();
            if (i % 50 == 0) {
                task.setProgress(i, this.m_iPoints);
            }
            ++i;
        }
        iter.close();
    }

    public PtAndAttributes[] getClosestPoints(LineSegment seg, double dDistance) {
        Envelope search = new Envelope(seg.p0, seg.p1);
        search.expandBy(dDistance);
        List list = this.m_Tree.query(search);
        int iSize = list.size();
        PtAndAttributes[] pts = new PtAndAttributes[iSize];
        for (int i = 0; i < iSize; ++i) {
            int iID = (Integer)list.get(i);
            pts[i] = new PtAndAttributes(this.m_dX[iID], this.m_dY[iID], iID, (Object[])this.m_Attributes[iID]);
        }
        return pts;
    }
}

