/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorize.contourLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class ContourLinesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String DISTANCE = "DISTANCE";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_Window;
    private IVectorLayer m_Contour;
    private char[][] m_Row;
    private char[][] m_Col;
    private final GeometryFactory m_GF = new GeometryFactory();

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Contour_lines"));
        this.setGroup(Sextante.getText((String)"Vectorization"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Input_layer"), true);
            this.m_Parameters.addNumericalValue(DISTANCE, Sextante.getText((String)"Equidistance"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(MIN, Sextante.getText((String)"Min_value"), 0.0, 2);
            this.m_Parameters.addNumericalValue(MAX, Sextante.getText((String)"Max_value"), 10000.0, 2);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Contour_lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() {
        String[] sFields = new String[2];
        Class[] types = new Class[]{Integer.class, Double.class};
        try {
            this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
            double dMin = this.m_Parameters.getParameterValueAsDouble(MIN);
            double dMax = this.m_Parameters.getParameterValueAsDouble(MAX);
            double dDistance = this.m_Parameters.getParameterValueAsDouble(DISTANCE);
            this.m_Window.setFullExtent();
            if (dMin <= dMax && dDistance > 0.0) {
                if (dMin < this.m_Window.getMinValue()) {
                    dMin += dDistance * (double)((int)((this.m_Window.getMinValue() - dMin) / dDistance));
                }
                if (dMax > this.m_Window.getMaxValue()) {
                    dMax = this.m_Window.getMaxValue();
                }
                sFields[0] = "ID";
                sFields[1] = "Elevation";
                this.m_Contour = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Contour_lines"), 1, types, sFields);
                this.createContours(dMin, dMax, dDistance);
                return !this.m_Task.isCanceled();
            }
            return false;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private void createContours(double dMin, double dMax, double dDistance) {
        double dValue = 0.0;
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        this.m_Row = new char[iNY][iNX];
        this.m_Col = new char[iNY][iNX];
        if (dDistance <= 0.0) {
            dDistance = 1.0;
        }
        int ID = 0;
        for (double dZ = dMin; dZ <= dMax && this.setProgress((int)(dZ - dMin), (int)(dMax - dMin)); dZ += dDistance) {
            int x;
            int y;
            for (y = 0; y < iNY - 1; ++y) {
                for (x = 0; x < iNX - 1; ++x) {
                    dValue = this.m_Window.getCellValueAsDouble(x, y);
                    if (dValue >= dZ) {
                        this.m_Row[y][x] = (char)(this.m_Window.getCellValueAsDouble(x + 1, y) < dZ ? 1 : 0);
                        this.m_Col[y][x] = (char)(this.m_Window.getCellValueAsDouble(x, y + 1) < dZ ? 1 : 0);
                        continue;
                    }
                    this.m_Row[y][x] = (char)(this.m_Window.getCellValueAsDouble(x + 1, y) >= dZ ? 1 : 0);
                    this.m_Col[y][x] = (char)(this.m_Window.getCellValueAsDouble(x, y + 1) >= dZ ? 1 : 0);
                }
            }
            for (y = 0; y < iNY - 1; ++y) {
                for (x = 0; x < iNX - 1; ++x) {
                    int i;
                    if (this.m_Row[y][x] != '\u0000') {
                        for (i = 0; i < 2; ++i) {
                            this.findContour(x, y, dZ, true, ID++);
                        }
                        this.m_Row[y][x] = '\u0000';
                    }
                    if (this.m_Col[y][x] == '\u0000') continue;
                    for (i = 0; i < 2; ++i) {
                        this.findContour(x, y, dZ, false, ID++);
                    }
                    this.m_Col[y][x] = '\u0000';
                }
            }
        }
    }

    private void findContour(int x, int y, double z, boolean doRow, int ID) {
        boolean doContinue = true;
        boolean bIsFirstPoint = true;
        int zx = doRow ? x + 1 : x;
        int zy = doRow ? y : y + 1;
        double xMin = this.m_Window.getWindowGridExtent().getXMin();
        double yMax = this.m_Window.getWindowGridExtent().getYMax();
        Object[] values = new Object[2];
        NextContourInfo info = new NextContourInfo();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        info.x = x;
        info.y = y;
        info.iDir = 0;
        info.doRow = doRow;
        do {
            double d = this.m_Window.getCellValueAsDouble(info.x, info.y);
            d = (d - z) / (d - this.m_Window.getCellValueAsDouble(zx, zy));
            double xPos = xMin + this.m_Window.getWindowCellSize() * ((double)info.x + d * (double)(zx - info.x) + 0.5);
            double yPos = yMax - this.m_Window.getWindowCellSize() * ((double)info.y + d * (double)(zy - info.y) + 0.5);
            coords.add(new Coordinate(xPos, yPos));
            if (!this.findNextContour(info)) {
                doContinue = this.findNextContour(info);
            }
            info.iDir = (info.iDir + 5) % 8;
            if (info.doRow) {
                this.m_Row[info.y][info.x] = '\u0000';
                zx = info.x + 1;
                zy = info.y;
                continue;
            }
            this.m_Col[info.y][info.x] = '\u0000';
            zx = info.x;
            zy = info.y + 1;
        } while (doContinue);
        values[0] = new Integer(ID);
        values[1] = new Double(z);
        Coordinate[] coordinates = new Coordinate[coords.size()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = (Coordinate)coords.get(i);
        }
        if (coordinates.length > 1) {
            LineString line = this.m_GF.createLineString(coordinates);
            this.m_Contour.addFeature((Geometry)line, values);
        }
    }

    private boolean findNextContour(NextContourInfo info) {
        boolean doContinue;
        if (info.doRow) {
            switch (info.iDir) {
                case 0: {
                    if (this.m_Row[info.y + 1][info.x] != '\u0000') {
                        ++info.y;
                        info.iDir = 0;
                        doContinue = true;
                        break;
                    }
                }
                case 1: {
                    if (this.m_Col[info.y][info.x + 1] != '\u0000') {
                        ++info.x;
                        info.iDir = 1;
                        info.doRow = false;
                        doContinue = true;
                        break;
                    }
                }
                case 2: 
                case 3: {
                    if (info.y - 1 >= 0 && this.m_Col[info.y - 1][info.x + 1] != '\u0000') {
                        ++info.x;
                        --info.y;
                        info.doRow = false;
                        info.iDir = 3;
                        doContinue = true;
                        break;
                    }
                }
                case 4: {
                    if (info.y - 1 >= 0 && this.m_Row[info.y - 1][info.x] != '\u0000') {
                        --info.y;
                        info.iDir = 4;
                        doContinue = true;
                        break;
                    }
                }
                case 5: {
                    if (info.y - 1 >= 0 && this.m_Col[info.y - 1][info.x] != '\u0000') {
                        --info.y;
                        info.doRow = false;
                        info.iDir = 5;
                        doContinue = true;
                        break;
                    }
                }
                case 6: 
                case 7: {
                    if (this.m_Col[info.y][info.x] != '\u0000') {
                        info.doRow = false;
                        info.iDir = 7;
                        doContinue = true;
                        break;
                    }
                }
                default: {
                    info.iDir = 0;
                    doContinue = false;
                    break;
                }
            }
        } else {
            switch (info.iDir) {
                case 0: 
                case 1: {
                    if (this.m_Row[info.y + 1][info.x] != '\u0000') {
                        ++info.y;
                        info.doRow = true;
                        info.iDir = 1;
                        doContinue = true;
                        break;
                    }
                }
                case 2: {
                    if (this.m_Col[info.y][info.x + 1] != '\u0000') {
                        ++info.x;
                        info.iDir = 2;
                        doContinue = true;
                        break;
                    }
                }
                case 3: {
                    if (this.m_Row[info.y][info.x] != '\u0000') {
                        info.doRow = true;
                        info.iDir = 3;
                        doContinue = true;
                        break;
                    }
                }
                case 4: 
                case 5: {
                    if (info.x - 1 >= 0 && this.m_Row[info.y][info.x - 1] != '\u0000') {
                        --info.x;
                        info.doRow = true;
                        info.iDir = 5;
                        doContinue = true;
                        break;
                    }
                }
                case 6: {
                    if (info.x - 1 >= 0 && this.m_Col[info.y][info.x - 1] != '\u0000') {
                        --info.x;
                        info.iDir = 6;
                        doContinue = true;
                        break;
                    }
                }
                case 7: {
                    if (info.x - 1 >= 0 && this.m_Row[info.y + 1][info.x - 1] != '\u0000') {
                        --info.x;
                        ++info.y;
                        info.doRow = true;
                        info.iDir = 7;
                        doContinue = true;
                        break;
                    }
                }
                default: {
                    info.iDir = 0;
                    doContinue = false;
                }
            }
        }
        return doContinue;
    }

    private class NextContourInfo {
        public int iDir;
        public int x;
        public int y;
        public boolean doRow;

        private NextContourInfo() {
        }
    }
}

