/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorize.rasterToPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.geom.Point2D;

public class RasterToPointsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    private IRasterLayer m_Window;
    private IVectorLayer m_Points;
    private int m_iNX;
    private int m_iNY;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Raster_layer_to_points_layer"));
        this.setGroup(Sextante.getText((String)"Vectorization"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Input_layer"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Object[] value = new Object[1];
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        String[] sFields = new String[]{this.m_Window.getName()};
        Class[] types = new Class[]{Double.class};
        this.m_Window.setWindowExtent(this.m_AnalysisExtent);
        this.m_Points = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Points"), 0, types, sFields);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        GeometryFactory gf = new GeometryFactory();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue)) continue;
                Point2D pt = this.m_Window.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
                Point point = gf.createPoint(new Coordinate(pt.getX(), pt.getY()));
                value[0] = new Double(dValue);
                this.m_Points.addFeature((Geometry)point, value);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

