/*
 * Decompiled with CFR 0.152.
 */
package wf.rothermel;

public class Behave {
    public boolean isCalculated = false;
    public boolean canDerive = true;
    public int fuelModel = 0;
    public double w0_d1 = 0.0;
    public double w0_d2 = 0.0;
    public double w0_d3 = 0.0;
    public double w0_lh = 0.0;
    public double w0_lw = 0.0;
    public double sv_d1 = 0.0;
    public double sv_d2 = 357.6115;
    public double sv_d3 = 98.4252;
    public double sv_lh = 4921.2598;
    public double sv_lw = 4921.2598;
    public double depth = 0.0;
    public double rho_p = 512.72341;
    public double heat = 18606.70194;
    public double s_t = 5.5;
    public double s_e = 1.0;
    public double mx = 0.0;
    public double m_d1 = 0.0;
    public double m_d2 = 0.0;
    public double m_d3 = 0.0;
    public double m_lh = 0.0;
    public double m_lw = 0.0;
    public double wsp = 0.0;
    public double wdr = 0.0;
    public double slp = 0.0;
    public double asp = 0.0;
    public double rho_b = 0.0;
    public double beta = 0.0;
    public double beta_opt = 0.0;
    public double beta_ratio = 0.0;
    public double w_n = 0.0;
    public double eta_s = 0.0;
    public double eta_M = 0.0;
    public double xi = 0.0;
    public double A = 0.0;
    public double gamma = 0.0;
    public double gamma_max = 0.0;
    public double I_r = 0.0;
    public double phi_s = 0.0;
    public double B;
    public double C;
    public double E = 0.0;
    public double phi_w = 0.0;
    public double phi_t = 0.0;
    public double vx;
    public double vy;
    public double vl = 0.0;
    public double ecc = 0.0;
    public double asp_r;
    public double slp_r;
    public double wdr_r;
    public double sdr_r;
    public double sin_asp;
    public double cos_asp;
    public double sin_wdr;
    public double cos_wdr;
    public double tan_slp;
    public double al;
    public double splitDeg;
    public double splitRad;
    public double cos_splitRad;
    public double sin_splitRad;
    public double alDeg;
    public double alRad;
    public double sw_d1;
    public double sw_d2;
    public double sw_d3;
    public double sw_lh;
    public double sw_lw;
    public double sw_d;
    public double sw_l;
    public double sw_t = 0.0;
    public double s2w_d;
    public double s2w_l;
    public double s2w_t = 0.0;
    public double sw2_d;
    public double sw2_l;
    public double sw2_t = 0.0;
    public double swm_d;
    public double swm_l;
    public double swm_t = 0.0;
    public double sigma = 0.0;
    public double w0 = 0.0;
    public double wn_d1;
    public double wn_d2;
    public double wn_d3;
    public double wn_lh;
    public double wn_lw;
    public double wn_d;
    public double wn_l;
    public double eps_d1;
    public double eps_d2;
    public double eps_d3;
    public double eps_lh;
    public double eps_lw;
    public double q_d1;
    public double q_d2;
    public double q_d3;
    public double q_lh;
    public double q_lw;
    public double hskz;
    public double hn_d1;
    public double hn_d2;
    public double hn_d3;
    public double hn_lh;
    public double hn_lw = 0.0;
    public double sumhd;
    public double sumhl;
    public double sumhdm = 0.0;
    public double W = 0.0;
    public double eta_Ml;
    public double eta_Md = 0.0;
    public double rm_d;
    public double rm_l = 0.0;
    public double Mf_dead = 0.0;
    public double Mx_live = 0.0;
    public double dead;
    public double live = 0.0;
    public double sdr = 0.0;
    public double efw = 0.0;
    public double hsk = 0.0;
    public double ros = 0.0;
    public double tau = 0.0;
    public double hpa = 0.0;
    public double fzd = 0.0;
    public double fli = 0.0;
    public double fln = 0.0;

    public boolean setFuelModel(int model) {
        block11: {
            block10: {
                if (model == this.fuelModel) break block10;
                this.fuelModel = model;
                switch (this.fuelModel) {
                    case 1: {
                        this.setFuelModelValues(0.18, 0.0, 0.0, 0.0, 0.0, 0.3048, 11482.94, 12.0);
                        break block11;
                    }
                    case 2: {
                        this.setFuelModelValues(0.486, 0.243, 0.122, 0.122, 0.0, 0.3048, 9842.0, 15.0);
                        break block11;
                    }
                    case 3: {
                        this.setFuelModelValues(0.732, 0.0, 0.0, 0.0, 0.0, 0.762, 4921.2598, 25.0);
                        break block11;
                    }
                    case 4: {
                        this.setFuelModelValues(1.218, 0.975, 0.486, 1.218, 0.0, 1.8288, 6561.67979, 20.0);
                        break block11;
                    }
                    case 5: {
                        this.setFuelModelValues(0.243, 0.122, 0.0, 0.0, 0.122, 0.6096, 6561.68, 20.0);
                        break block11;
                    }
                    case 6: {
                        this.setFuelModelValues(0.365, 0.608, 0.0, 0.0, 0.486, 0.732, 5741.47, 25.0);
                        break block11;
                    }
                    case 7: {
                        this.setFuelModelValues(0.275, 0.645, 0.365, 0.0, 0.09, 0.762, 5741.47, 40.0);
                        break block11;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (model < 1 || model > 13) {
                return false;
            }
        }
        return true;
    }

    private void setFuelModelValues(double wd1, double wd2, double wd3, double wlh, double wlw, double dep, double sv, double mox) {
        this.w0_d1 = wd1;
        this.w0_d2 = wd2;
        this.w0_d3 = wd3;
        this.w0_lh = wlh;
        this.w0_lw = wlw;
        this.depth = dep;
        this.sv_d1 = sv;
        this.mx = mox;
        this.w0 = this.w0_d1 + this.w0_d2 + this.w0_d3 + this.w0_lh + this.w0_lw;
    }

    public void setWindSpeed(double speed) {
        this.wsp = speed;
    }

    public void setWindDir(double dir) {
        this.wdr = dir;
    }

    public void setSlope(double slope) {
        this.slp = slope;
    }

    public void setAspect(double aspect) {
        this.asp = aspect;
    }

    public void setDeadMoisture1(double moisture) {
        this.m_d1 = moisture;
    }

    public void setDeadMoisture10(double moisture) {
        this.m_d2 = moisture;
    }

    public void setDeadMoisture100(double moisture) {
        this.m_d3 = moisture;
    }

    public void setHerbMoisture(double moisture) {
        this.m_lh = moisture;
    }

    public void setWoodyMoisture(double moisture) {
        this.m_lw = moisture;
    }

    public static double getRosInDir(double dRos, double dMaxDirection, double dDirection, double dEcc) {
        double d;
        double dDir = Math.abs(dMaxDirection - dDirection);
        if (d > 180.0) {
            dDir = 360.0 - dDir;
        }
        return dRos * (1.0 - dEcc) / (1.0 - dEcc * Math.cos(Math.toRadians(dDir)));
    }

    public void calc() {
        this.calcRothermel();
    }

    private void calcRothermel() {
        this.isCalculated = false;
        this.canDerive = true;
        this.calcFuel();
        this.eta_s = 0.174 * Math.pow(this.s_e / 100.0, -0.19);
        this.moistureDamping();
        this.reactionVelocity();
        this.I_r = this.gamma * this.heat * this.eta_s * this.eta_M;
        this.xi = Math.exp((0.792 + 0.37597 * Math.sqrt(this.sigma)) * (this.beta + 0.1)) / (192.0 + 0.0791 * this.sigma);
        this.heatSink();
        this.ros = this.I_r * this.xi / this.hsk;
        this.combinedWindAndSlopeFactor();
        if (this.phi_t > 0.0) {
            this.ros = this.I_r * this.xi * (1.0 + this.phi_t) / this.hsk;
        }
        this.tau = 23040.0 / (this.sigma * 0.3048);
        this.hpa = this.I_r * this.tau;
        this.fzd = this.ros * this.tau;
        this.fli = this.I_r * this.fzd;
        this.fln = 0.0775 * Math.pow(this.fli, 0.46);
        this.isCalculated = true;
    }

    protected void calcFuel() {
        this.sigma = 0.0;
        this.rho_b = 0.0;
        this.beta = 0.0;
        this.beta_opt = 0.0;
        this.beta_ratio = 0.0;
        this.sw_d1 = 0.0;
        this.sw_d2 = 0.0;
        this.sw_d3 = 0.0;
        this.sw_lh = 0.0;
        this.sw_lw = 0.0;
        this.s2w_d = 0.0;
        this.s2w_l = 0.0;
        this.s2w_t = 0.0;
        this.sw2_d = 0.0;
        this.sw2_l = 0.0;
        this.sw2_t = 0.0;
        this.swm_d = 0.0;
        this.swm_l = 0.0;
        this.wn_d1 = 0.0;
        this.wn_d2 = 0.0;
        this.wn_d3 = 0.0;
        this.wn_lh = 0.0;
        this.wn_lw = 0.0;
        this.wn_d = 0.0;
        this.wn_l = 0.0;
        this.sw_d1 = this.sv_d1 * this.w0_d1;
        this.sw_d2 = this.sv_d2 * this.w0_d2;
        this.sw_d3 = this.sv_d3 * this.w0_d3;
        this.sw_lh = this.sv_lh * this.w0_lh;
        this.sw_lw = this.sv_lw * this.w0_lw;
        this.sw_d = this.sw_d1 + this.sw_d2 + this.sw_d3;
        this.sw_l = this.sw_lh + this.sw_lw;
        this.sw_t = this.sw_d + this.sw_l;
        this.s2w_d = this.sw_d1 * this.sv_d1 + this.sw_d2 * this.sv_d2 + this.sw_d3 * this.sv_d3;
        this.s2w_l = this.sw_lh * this.sv_lh + this.sw_lw * this.sv_lw;
        this.s2w_t = this.s2w_d + this.s2w_l;
        this.sw2_d = this.sw_d1 * this.w0_d1 + this.sw_d2 * this.w0_d2 + this.sw_d3 * this.w0_d3;
        this.sw2_l = this.sw_lh * this.w0_lh + this.sw_lw * this.w0_lw;
        this.sw2_t = this.sw2_d + this.sw2_l;
        this.swm_d = this.sw_d1 * this.m_d1 + this.sw_d2 * this.m_d2 + this.sw_d3 * this.m_d3;
        this.swm_l = this.sw_lh * this.m_lh + this.sw_lw * this.m_lw;
        this.sigma = this.s2w_t / this.sw_t;
        this.rho_b = this.w0 / this.depth;
        this.beta = this.rho_b / this.rho_p;
        if (this.beta > 1.0 || this.beta < 0.0) {
            System.out.println("Mean packing ration [beta] out of limits [0,1]: " + this.beta);
        }
        this.beta_opt = 8.8578 * Math.pow(this.sigma, -0.8189);
        this.beta_ratio = this.beta / this.beta_opt;
        this.wn_d1 = this.w0_d1 * (1.0 - this.s_t / 100.0);
        this.wn_d2 = this.w0_d2 * (1.0 - this.s_t / 100.0);
        this.wn_d3 = this.w0_d3 * (1.0 - this.s_t / 100.0);
        this.wn_lh = this.w0_lh * (1.0 - this.s_t / 100.0);
        this.wn_lw = this.w0_lw * (1.0 - this.s_t / 100.0);
        if (this.sw_d > 0.0) {
            this.wn_d = (1.0 - this.s_t / 100.0) * this.sw2_d / this.sw_d;
        }
        if (this.sw_l > 0.0) {
            this.wn_l = (1.0 - this.s_t / 100.0) * this.sw2_l / this.sw_l;
        }
    }

    protected void slopeFactor() {
        this.slp_r = Math.toRadians(this.slp);
        this.tan_slp = Math.tan(this.slp_r);
        this.phi_s = 5.275 * Math.pow(this.beta, -0.3) * Math.pow(this.tan_slp, 2.0);
    }

    protected void windFactor() {
        this.B = 0.02526 * Math.pow(this.sigma * 0.3048, 0.54);
        this.C = 7.47 * Math.exp(-0.133 * Math.pow(this.sigma * 0.3048, 0.55));
        this.E = 0.715 * Math.exp(-1.094232E-4 * this.sigma);
        this.phi_w = this.C * Math.pow(196.86 * this.wsp, this.B) * Math.pow(this.beta_ratio, -this.E);
    }

    protected void combinedWindAndSlopeFactor() {
        this.phi_t = 0.0;
        this.vl = 0.0;
        this.slopeFactor();
        this.windFactor();
        this.asp_r = Math.toRadians(this.asp);
        this.wdr_r = Math.toRadians(this.wdr);
        this.asp_r = this.asp_r < Math.PI ? (this.asp_r += Math.PI) : (this.asp_r -= Math.PI);
        this.wdr_r = this.wdr_r < Math.PI ? (this.wdr_r += Math.PI) : (this.wdr_r -= Math.PI);
        this.splitRad = Math.abs(this.wdr_r - this.asp_r) >= Math.PI ? this.wdr_r + this.asp_r - Math.PI * 2 : this.wdr_r - this.asp_r;
        this.cos_splitRad = Math.cos(this.splitRad);
        this.sin_splitRad = Math.sin(this.splitRad);
        this.vx = this.phi_s + this.phi_w * this.cos_splitRad;
        this.vy = this.phi_w * this.sin_splitRad;
        this.vl = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        this.al = Math.asin(this.vy / this.vl);
        this.alRad = this.vx >= 0.0 ? (this.vy >= 0.0 ? this.asp_r + this.al : this.asp_r + this.al + Math.PI * 2) : this.asp_r - this.al + Math.PI;
        this.alDeg = Math.toDegrees(this.alRad);
        if (this.alDeg > 360.0) {
            this.alDeg -= 360.0;
        }
        this.sdr = this.alDeg;
        this.efw = Math.pow(this.vl / (this.C * Math.pow(this.beta_ratio, -this.E)), 1.0 / this.B) / 196.85;
        if (this.efw > 0.024 * this.I_r) {
            this.efw = Math.min(this.efw, 0.024 * this.I_r);
            this.phi_t = this.C * Math.pow(196.85 * this.efw, this.B) * Math.pow(this.beta_ratio, -this.E);
            this.canDerive = false;
        } else {
            this.phi_t = this.vl;
        }
        double lwRatio = 1.0 + 0.002840909 * this.efw;
        this.ecc = Math.sqrt(lwRatio * lwRatio - 1.0) / lwRatio;
    }

    protected void moistureDamping() {
        this.hn_d1 = 0.0;
        this.hn_d2 = 0.0;
        this.hn_d3 = 0.0;
        this.hn_lh = 0.0;
        this.hn_lw = 0.0;
        this.sumhd = 0.0;
        this.sumhl = 0.0;
        this.sumhdm = 0.0;
        this.W = 0.0;
        this.Mf_dead = 0.0;
        this.Mx_live = 0.0;
        this.eta_Ml = 0.0;
        this.eta_Md = 0.0;
        this.eta_M = 0.0;
        if (this.sv_d1 > 0.0) {
            this.hn_d1 = 0.20482 * this.w0_d1 * Math.exp(-452.76 / this.sv_d1);
        }
        if (this.sv_d2 > 0.0) {
            this.hn_d2 = 0.20482 * this.w0_d2 * Math.exp(-452.76 / this.sv_d2);
        }
        if (this.sv_d3 > 0.0) {
            this.hn_d3 = 0.20482 * this.w0_d3 * Math.exp(-452.76 / this.sv_d3);
        }
        if (this.sv_lh > 0.0) {
            this.hn_lh = 0.20482 * this.w0_lh * Math.exp(-1640.42 / this.sv_lh);
        }
        if (this.sv_lw > 0.0) {
            this.hn_lw = 0.20482 * this.w0_lw * Math.exp(-1640.42 / this.sv_lw);
        }
        this.sumhd = this.hn_d1 + this.hn_d2 + this.hn_d3;
        this.sumhl = this.hn_lh + this.hn_lw;
        this.sumhdm = this.hn_d1 * this.m_d1 + this.hn_d2 * this.m_d2 + this.hn_d3 * this.m_d3;
        if (this.sw_l > 0.0) {
            this.W = this.sumhd / this.sumhl;
            if (this.sumhd > 0.0) {
                this.Mf_dead = this.sumhdm / this.sumhd;
            }
            this.Mx_live = (2.9 * this.W * (1.0 - this.Mf_dead / this.mx) - 0.226) * 100.0;
            if (this.Mx_live < this.mx) {
                this.canDerive = false;
                this.Mx_live = this.mx;
            }
            this.rm_l = this.swm_l / (this.sw_l * this.Mx_live);
        }
        if (this.sw_d > 0.0) {
            this.rm_d = this.swm_d / (this.sw_d * this.mx);
        }
        this.eta_Md = 1.0 - 2.59 * this.rm_d + 5.11 * Math.pow(this.rm_d, 2.0) - 3.52 * Math.pow(this.rm_d, 3.0);
        this.eta_Ml = 1.0 - 2.59 * this.rm_l + 5.11 * Math.pow(this.rm_l, 2.0) - 3.52 * Math.pow(this.rm_l, 3.0);
        if (this.eta_Md < 0.0) {
            this.eta_Md = 0.0;
        }
        if (this.eta_Ml < 0.0) {
            this.eta_Ml = 0.0;
        }
        this.eta_M = this.wn_d * this.eta_Md + this.wn_l * this.eta_Ml;
    }

    protected void reactionVelocity() {
        this.A = 340.53 * Math.pow(this.sigma, -0.7913);
        this.gamma_max = 0.16828 * Math.pow(this.sigma, 1.5) / (29700.0 + 0.5997 * Math.pow(this.sigma, 1.5));
        this.gamma = this.gamma_max * Math.pow(this.beta_ratio, this.A) * Math.exp(this.A * (1.0 - this.beta_ratio));
    }

    protected void heatSink() {
        if (this.sv_d1 > 0.0) {
            this.eps_d1 = Math.exp(-452.76 / this.sv_d1);
        }
        if (this.sv_d2 > 0.0) {
            this.eps_d2 = Math.exp(-452.76 / this.sv_d2);
        }
        if (this.sv_d3 > 0.0) {
            this.eps_d3 = Math.exp(-452.76 / this.sv_d3);
        }
        if (this.sv_lh > 0.0) {
            this.eps_lh = Math.exp(-452.76 / this.sv_lh);
        }
        if (this.sv_lw > 0.0) {
            this.eps_lw = Math.exp(-452.76 / this.sv_lw);
        }
        this.q_d1 = 581.5 + 25.957 * this.m_d1;
        this.q_d2 = 581.5 + 25.957 * this.m_d2;
        this.q_d3 = 581.5 + 25.957 * this.m_d3;
        this.q_lh = 581.5 + 25.957 * this.m_lh;
        this.q_lw = 581.5 + 25.957 * this.m_lw;
        this.hskz = this.sw_d1 * this.eps_d1 * this.q_d1 + this.sw_d2 * this.eps_d2 * this.q_d2 + this.sw_d3 * this.eps_d3 * this.q_d3 + this.sw_lh * this.eps_lh * this.q_lh + this.sw_lw * this.eps_lw * this.q_lw;
        this.hsk = this.rho_b * this.hskz / this.sw_t;
    }
}

