/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.chamfer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.chamfer.SegmentData;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChamferEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChamferEditingProvider.class);
    private static final int INSIDE_THE_SEGMENT = 0;
    private static final int BEYOND_THE_SEGMENT = 1;
    private static final int INVALID_ZONE = -1;
    private static final String CHAMFER_DISTANCE = "_Distance";
    private static final String CHAMFER_ANGLE = "_Angle";
    private static final String SHORT_CHAMFER_DISTANCE = "_Short_distance";
    private static final String SHORT_CHAMFER_ANGLE = "_Short_angle";
    private static final String CHAMFER_METHOD = "_Method";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY_QUESTION = "_Delete_second_selected_geometry_question";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY = "_Delete_second_selected_geometry";
    private static final String YES = "_yes";
    private static final String NO = "_no";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private static Boolean deleteSecondFeatureDefaultValue;
    private final EditingServiceParameter firstPointParameter;
    private final EditingServiceParameter secondPointParameter;
    private final EditingServiceParameter firstDistanceParameter;
    private final EditingServiceParameter methodParameter;
    private final EditingServiceParameter secondDistanceParameter;
    private final EditingServiceParameter angleParameter;
    private final EditingServiceParameter deleteSecondSelectedGeometryParameter;
    private final Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private SegmentData firstSegmentData;
    private SegmentData secondSegmentData;
    private Point pointToChamfer;
    private static String savedMethod;

    public ChamferEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.firstPointParameter = new DefaultEditingServiceParameter("_First_point", "_First_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPointParameter = new DefaultEditingServiceParameter("_Second_point", "_Second_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        DefaultEditingServiceParameterOptions methodOptions = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(CHAMFER_DISTANCE), (Object)CHAMFER_DISTANCE, i18nManager.getTranslation(SHORT_CHAMFER_DISTANCE)).add(i18nManager.getTranslation(CHAMFER_ANGLE), (Object)CHAMFER_ANGLE, i18nManager.getTranslation(SHORT_CHAMFER_ANGLE));
        String methodConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(i18nManager.getTranslation(CHAMFER_METHOD), (EditingServiceParameterOptions)methodOptions);
        this.methodParameter = new DefaultEditingServiceParameter(CHAMFER_METHOD, methodConsoleMsg, (EditingServiceParameterOptions)methodOptions, (Object)i18nManager.getTranslation(SHORT_CHAMFER_DISTANCE), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION});
        this.firstDistanceParameter = new DefaultEditingServiceParameter("_First_distance", "_First_distance", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.DISTANCE});
        this.secondDistanceParameter = new DefaultEditingServiceParameter("_Second_distance", "_Second_distance", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.DISTANCE});
        this.angleParameter = new DefaultEditingServiceParameter(CHAMFER_ANGLE, CHAMFER_ANGLE, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
        DefaultEditingServiceParameterOptions deleteSecondSelectedGeometryParameterOptions = new DefaultEditingServiceParameterOptions().add(YES, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(NO, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(DELETE_SECOND_SELECTED_GEOMETRY_QUESTION, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions);
        deleteSecondFeatureDefaultValue = true;
        this.deleteSecondSelectedGeometryParameter = new DefaultEditingServiceParameter(DELETE_SECOND_SELECTED_GEOMETRY, consoleMsg, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions, (Object)deleteSecondFeatureDefaultValue, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
    }

    public String getName() {
        return "modify-chamfer";
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.firstPointParameter) == null) {
            return this.firstPointParameter;
        }
        if (this.values.get(this.secondPointParameter) == null) {
            return this.secondPointParameter;
        }
        if (this.values.get(this.firstDistanceParameter) == null) {
            return this.firstDistanceParameter;
        }
        if (StringUtils.equals((CharSequence)((String)this.values.get(this.methodParameter)), (CharSequence)CHAMFER_DISTANCE) && this.values.get(this.secondDistanceParameter) == null) {
            return this.secondDistanceParameter;
        }
        if (StringUtils.equals((CharSequence)((String)this.values.get(this.methodParameter)), (CharSequence)CHAMFER_ANGLE) && this.values.get(this.angleParameter) == null) {
            return this.angleParameter;
        }
        if (this.values.get(this.deleteSecondSelectedGeometryParameter) == null && !Objects.equals(this.firstSegmentData.getFeature().getReference(), this.secondSegmentData.getFeature().getReference())) {
            return this.deleteSecondSelectedGeometryParameter;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISimpleTextSymbol textSymbol = this.getTextSymbol();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        ISymbol previewSymbol = null;
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (this.values == null) return geometries;
            if (this.firstSegmentData == null) {
                Feature firstFeature = this.getFeatureNearestPoint(mousePosition);
                if (firstFeature == null) {
                    return geometries;
                }
                Geometry firstGeometry = firstFeature.getDefaultGeometry();
                if (firstGeometry == null || !this.validateGeometryType(firstGeometry)) {
                    return geometries;
                }
                SegmentData segmentData = new SegmentData(firstFeature, mousePosition);
                geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                return geometries;
            }
            if (this.secondSegmentData == null) {
                geometries.addStatus((Geometry)this.firstSegmentData.getLine(), auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)this.firstSegmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                Feature secondFeature = this.getFeatureNearestPoint(mousePosition);
                if (secondFeature == null) {
                    return geometries;
                }
                Geometry secondGeometry = secondFeature.getDefaultGeometry();
                if (secondGeometry == null || !this.validateGeometryType(secondGeometry)) {
                    return geometries;
                }
                SegmentData segmentData = new SegmentData(secondFeature, mousePosition);
                Pair<Point, Point> oppositePoints = this.calculateOpositeToChamferVertices(this.firstSegmentData, segmentData);
                if (!this.validateAsSecondSegmentData(segmentData, (Point)oppositePoints.getRight())) return geometries;
                geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
                geometries.addStatus((Geometry)tmpPointToChamfer, auxiliaryPointSymbolEditing, "");
                return geometries;
            } else {
                Double secondDistance;
                previewSymbol = this.getPreviewSymbol(this.firstSegmentData.getFeature());
                geometries.addStatus((Geometry)this.firstSegmentData.getLine(), auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)this.firstSegmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)this.secondSegmentData.getLine(), auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)this.secondSegmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)this.pointToChamfer, auxiliaryPointSymbolEditing, "");
                Double firstDistance = (Double)this.getValue(this.firstDistanceParameter);
                if (firstDistance == null) {
                    firstDistance = (Double)this.firstDistanceParameter.getDefaultValue();
                }
                if ((secondDistance = (Double)this.getValue(this.secondDistanceParameter)) == null) {
                    secondDistance = (Double)this.secondDistanceParameter.getDefaultValue();
                }
                Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, this.secondSegmentData);
                Point oppositeVertex1 = (Point)oppositeVertices.getLeft();
                Point oppositeVertex2 = (Point)oppositeVertices.getRight();
                Line chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
                geometries.addStatus((Geometry)chamfer, auxiliaryLineSymbolEditing, "");
                Line lineForDistance1 = GeometryUtils.createLine((Point)oppositeVertex1, (Point)this.pointToChamfer, (int)subtype);
                geometries.addStatus((Geometry)lineForDistance1, auxiliaryLineSymbolEditing, "");
                Line lineForDistance2 = GeometryUtils.createLine((Point)oppositeVertex2, (Point)this.pointToChamfer, (int)subtype);
                geometries.addStatus((Geometry)lineForDistance2, auxiliaryLineSymbolEditing, "");
                if (this.values.get(this.firstDistanceParameter) == null) {
                    geometries.addStatus((Geometry)lineForDistance1, auxiliaryLineSymbolEditing, "");
                    Point pointForDistance = this.calculatePointForDistance(this.firstSegmentData, this.pointToChamfer, oppositeVertex1, (Point)lineForDistance1.closestPoints((Geometry)mousePosition)[0]);
                    if (pointForDistance == null) {
                        return geometries;
                    }
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)pointForDistance, (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)pointForDistance, auxiliaryPointSymbolEditing, "");
                    Point pointText = GeometryUtils.createPoint((double)((mousePosition.getX() + pointForDistance.getX()) / 2.0), (double)((mousePosition.getY() + pointForDistance.getY()) / 2.0));
                    geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, String.valueOf(this.pointToChamfer.distance((Geometry)pointForDistance)));
                    chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, this.pointToChamfer.distance((Geometry)pointForDistance), secondDistance);
                } else if (this.values.get(this.secondDistanceParameter) == null && this.values.get(this.angleParameter) == null) {
                    firstDistance = (Double)this.getValue(this.firstDistanceParameter);
                    switch ((String)this.values.get(this.methodParameter)) {
                        case "_Distance": {
                            Point pointForDistance = this.calculatePointForDistance(this.secondSegmentData, this.pointToChamfer, oppositeVertex2, (Point)lineForDistance2.closestPoints((Geometry)mousePosition)[0]);
                            if (pointForDistance == null) {
                                return geometries;
                            }
                            geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)pointForDistance, (int)subtype), auxiliaryLineSymbolEditing, "");
                            geometries.addStatus((Geometry)pointForDistance, auxiliaryPointSymbolEditing, "");
                            Point pointText = GeometryUtils.createPoint((double)((mousePosition.getX() + pointForDistance.getX()) / 2.0), (double)((mousePosition.getY() + pointForDistance.getY()) / 2.0));
                            secondDistance = this.pointToChamfer.distance((Geometry)pointForDistance);
                            geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, String.valueOf(secondDistance));
                            chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
                            break;
                        }
                        case "_Angle": {
                            if (!this.validatePointForSecondDistance(mousePosition, chamfer.getVertex(0), oppositeVertex2, this.pointToChamfer)) {
                                return geometries;
                            }
                            double angle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)mousePosition);
                            if (this.calculateZoneInSegment(this.pointToChamfer, this.secondSegmentData) == -1) {
                                return geometries;
                            }
                            angle = this.calculatePositiveRadiansAngle(angle);
                            double maxAngle = this.calculateMaxAngle(chamfer, this.pointToChamfer, oppositeVertex2);
                            if (angle < 0.0 || angle > maxAngle) {
                                return geometries;
                            }
                            double startAngle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer);
                            Line lineForStartAngle = geometryManager.createLine(subtype);
                            lineForStartAngle.addVertex(chamfer.getVertex(0));
                            Point startAnglePoint = GeometryUtils.createPoint((Point)chamfer.getVertex(0), (double)chamfer.getVertex(0).distance((Geometry)mousePosition), (double)startAngle);
                            lineForStartAngle.addVertex(startAnglePoint);
                            geometries.addStatus((Geometry)lineForStartAngle, auxiliaryLineSymbolEditing, "");
                            Line lineForAngle = geometryManager.createLine(subtype);
                            lineForAngle.addVertex(chamfer.getVertex(0));
                            lineForAngle.addVertex(mousePosition);
                            geometries.addStatus((Geometry)lineForAngle, auxiliaryLineSymbolEditing, "");
                            double minDistance = Math.min(chamfer.getVertex(0).distance((Geometry)this.pointToChamfer), chamfer.getVertex(0).distance((Geometry)mousePosition));
                            double angleExt = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)mousePosition);
                            angleExt = angleExt > Math.PI ? angleExt - Math.PI * 2 : angleExt;
                            Arc arc = GeometryUtils.createArc((Point)chamfer.getVertex(0), (double)(minDistance / 2.0), (double)GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer), (double)angleExt, (int)subtype);
                            geometries.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                            double textDistance = 3.0 * minDistance / 4.0;
                            Point pointText = geometryManager.createPoint(chamfer.getVertex(0).getX() + textDistance * Math.cos(startAngle + angleExt / 2.0), chamfer.getVertex(0).getY() + textDistance * Math.sin(startAngle + angleExt / 2.0), subtype);
                            double positiveRadiansAngle = this.calculatePositiveRadiansAngle(angle);
                            geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, GeometryUtils.formatAngle((String)"%5.3D\u00b0", (double)Math.toDegrees(positiveRadiansAngle)));
                            chamfer = this.calculateChamferAngleMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, positiveRadiansAngle);
                            if (chamfer != null) break;
                            return geometries;
                        }
                    }
                } else {
                    firstDistance = (Double)this.getValue(this.firstDistanceParameter);
                    switch ((String)this.values.get(this.methodParameter)) {
                        case "_Distance": {
                            secondDistance = (Double)this.getValue(this.secondDistanceParameter);
                            chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
                            break;
                        }
                        case "_Angle": {
                            double angle = Math.toRadians((Double)this.getValue(this.angleParameter));
                            double positiveRadiansAngle = this.calculatePositiveRadiansAngle(angle);
                            chamfer = this.calculateChamferAngleMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, positiveRadiansAngle);
                            if (chamfer != null) break;
                            return geometries;
                        }
                    }
                }
                if (Objects.equals(this.firstSegmentData.getPrimitive(), this.secondSegmentData.getPrimitive())) {
                    geometries.addStatus((Geometry)this.chamferPrimitive(this.firstSegmentData.getPrimitive(), chamfer), previewSymbol, null);
                    return geometries;
                } else {
                    geometries.addStatus((Geometry)this.chamferPrimitives(this.firstSegmentData.getPrimitive(), this.secondSegmentData.getPrimitive(), chamfer), previewSymbol, null);
                }
            }
            return geometries;
        }
        catch (Exception e) {
            throw new DrawServiceException((Throwable)e);
        }
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.firstPointParameter);
        parameters.add(this.secondPointParameter);
        parameters.add(this.firstDistanceParameter);
        parameters.add(this.methodParameter);
        parameters.add(this.secondDistanceParameter);
        parameters.add(this.angleParameter);
        parameters.add(this.deleteSecondSelectedGeometryParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        try {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (param == this.firstPointParameter) {
                if (!(value instanceof Point)) return;
                Point point = (Point)value;
                Feature firstFeature = this.getFeatureNearestPoint(point);
                if (firstFeature == null) {
                    throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest feature."));
                }
                Geometry firstGeometry = firstFeature.getDefaultGeometry();
                if (!this.validateGeometryType(firstGeometry)) {
                    throw new InvalidEntryException((Throwable)new IllegalArgumentException("invalid geometry type"));
                }
                this.firstSegmentData = new SegmentData(firstFeature, point);
                if (!this.firstSegmentData.isFilled()) {
                    this.firstSegmentData = null;
                    throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
                }
                this.values.put(param, value);
                if (this.firstSegmentData != null) return;
                throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
            }
            if (param == this.secondPointParameter) {
                if (!(value instanceof Point)) return;
                Point point = (Point)value;
                Feature secondFeature = this.getFeatureNearestPoint(point);
                if (secondFeature == null) {
                    throw new InvalidEntryException(null);
                }
                SegmentData segmentData = new SegmentData(secondFeature, point);
                Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, segmentData);
                if (!this.validateAsSecondSegmentData(segmentData, (Point)oppositeVertices.getRight())) {
                    this.secondSegmentData = null;
                    this.pointToChamfer = null;
                    throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
                }
                try {
                    this.secondSegmentData = segmentData;
                    this.pointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, this.secondSegmentData);
                    Point oppositeVertex1 = (Point)oppositeVertices.getLeft();
                    if (oppositeVertex1.distance((Geometry)this.firstSegmentData.getProjectedPoint()) > oppositeVertex1.distance((Geometry)this.pointToChamfer)) {
                        this.firstDistanceParameter.setDefaultValue((Object)0.0);
                    } else {
                        this.firstDistanceParameter.setDefaultValue((Object)this.pointToChamfer.distance((Geometry)this.firstSegmentData.getProjectedPoint()));
                    }
                    this.secondDistanceParameter.setDefaultValue((Object)this.pointToChamfer.distance((Geometry)this.secondSegmentData.getProjectedPoint()));
                    this.values.put(param, value);
                    return;
                }
                catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                    throw new InvalidEntryException(ex);
                }
            }
            if (param == this.firstDistanceParameter) {
                Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, this.secondSegmentData);
                double maxDistance = this.pointToChamfer.distance((Geometry)oppositeVertices.getLeft());
                Line lineForDistance1 = GeometryUtils.createLine((Point)((Point)oppositeVertices.getLeft()), (Point)this.pointToChamfer, (int)subtype);
                Double distance = null;
                if (value instanceof Point) {
                    Point pointForDistance = this.calculatePointForDistance(this.firstSegmentData, this.pointToChamfer, (Point)oppositeVertices.getLeft(), (Point)lineForDistance1.closestPoints((Geometry)((Point)value))[0]);
                    distance = this.pointToChamfer.distance((Geometry)pointForDistance);
                } else if (value instanceof Double) {
                    distance = (Double)value;
                } else if (value == null) {
                    distance = (Double)this.firstDistanceParameter.getDefaultValue();
                }
                if (distance == null || distance < 0.0 || distance > maxDistance) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(param, distance);
                Double secondDistance = (Double)this.secondDistanceParameter.getDefaultValue();
                Line chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, distance, secondDistance);
                if (distance == 0.0) {
                    this.angleParameter.setDefaultValue((Object)0);
                    this.values.put(this.angleParameter, 0);
                    this.values.put(this.secondDistanceParameter, 0);
                    return;
                } else {
                    double radiansAngle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)chamfer.getVertex(1));
                    if (radiansAngle > Math.PI) {
                        radiansAngle -= Math.PI * 2;
                    }
                    this.angleParameter.setDefaultValue((Object)Math.toDegrees(Math.abs(radiansAngle)));
                }
                return;
            } else if (param == this.methodParameter) {
                savedMethod = (String)param.getOptions2().getValue(value, param.getDefaultValue());
                this.values.put(param, savedMethod);
                return;
            } else if (param == this.secondDistanceParameter) {
                Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, this.secondSegmentData);
                double maxDistance = this.pointToChamfer.distance((Geometry)oppositeVertices.getRight());
                Double distance = null;
                if (value instanceof Point) {
                    Line lineForDistance2 = GeometryUtils.createLine((Point)((Point)oppositeVertices.getRight()), (Point)this.pointToChamfer, (int)subtype);
                    Point pointForDistance = this.calculatePointForDistance(this.secondSegmentData, this.pointToChamfer, (Point)oppositeVertices.getRight(), (Point)lineForDistance2.closestPoints((Geometry)((Point)value))[0]);
                    distance = this.pointToChamfer.distance((Geometry)pointForDistance);
                } else if (value instanceof Double) {
                    distance = (Double)value;
                } else if (value == null) {
                    distance = (Double)this.secondDistanceParameter.getDefaultValue();
                }
                if (distance == null || distance < 0.0 || distance > maxDistance) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(param, distance);
                return;
            } else if (param == this.angleParameter) {
                Double firstDistance = (Double)this.getValue(this.firstDistanceParameter);
                if (firstDistance == null) {
                    firstDistance = (Double)this.firstDistanceParameter.getDefaultValue();
                }
                Double secondDistance = (Double)this.secondDistanceParameter.getDefaultValue();
                Line chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
                Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, this.secondSegmentData);
                double radiansMaxAngle = this.calculateMaxAngle(chamfer, this.pointToChamfer, (Point)oppositeVertices.getRight());
                if (value instanceof Double) {
                    if ((Double)value < 0.0 || (Double)value > Math.toDegrees(radiansMaxAngle)) {
                        throw new InvalidEntryException(null);
                    }
                    this.values.put(param, value);
                    return;
                } else if (value instanceof Point) {
                    Point point = (Point)value;
                    if (!this.validatePointForAngle(chamfer, point)) throw new InvalidEntryException(null);
                    double angle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)point);
                    if (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                    this.values.put(param, Math.toDegrees(Math.abs(angle)));
                    return;
                } else {
                    if (value != null) throw new InvalidEntryException(null);
                    this.values.put(param, (Double)param.getDefaultValue());
                }
                return;
            } else {
                if (param != this.deleteSecondSelectedGeometryParameter) return;
                Boolean v = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
                this.values.put(param, v);
                deleteSecondFeatureDefaultValue = v;
            }
            return;
        }
        catch (Exception ex) {
            throw new InvalidEntryException((Throwable)ex);
        }
    }

    private boolean validatePointForAngle(Line chamfer, Point point) {
        double angle1;
        double angle0;
        double coefDirection = GeometryUtils.getCoefDirection((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)point);
        double angle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)point);
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        if ((angle0 = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)this.secondSegmentData.getLine().getVertex(0))) > Math.PI) {
            angle0 -= Math.PI * 2;
        }
        if ((angle1 = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)this.pointToChamfer, (Point)this.secondSegmentData.getLine().getVertex(1))) > Math.PI) {
            angle1 -= Math.PI * 2;
        }
        if (angle0 <= angle1) {
            return angle >= angle0 && angle <= angle1;
        }
        return angle >= angle1 && angle <= angle0;
    }

    private double calculateMaxAngle(Line chamfer, Point pointToChamfer, Point oppositeVertex) throws CreateGeometryException, DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        if (Objects.equals(chamfer.getVertex(0), pointToChamfer)) {
            return 0.0;
        }
        double radiansAngle = GeometryUtils.calculateAngle((Point)chamfer.getVertex(0), (Point)pointToChamfer, (Point)oppositeVertex);
        return this.calculatePositiveRadiansAngle(radiansAngle);
    }

    private double calculatePositiveRadiansAngle(double radiansAngle1) {
        while (radiansAngle1 > Math.PI) {
            radiansAngle1 -= Math.PI * 2;
        }
        radiansAngle1 = Math.abs(radiansAngle1);
        return radiansAngle1;
    }

    private boolean validateGeometryType(Geometry geometry) throws IllegalArgumentException {
        ArrayList<Integer> validGeometryTypes = new ArrayList<Integer>(Arrays.asList(18, 19, 21, 22));
        return validGeometryTypes.contains(geometry.getType());
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Double firstDistance = (Double)this.getValue(this.firstDistanceParameter);
        if (firstDistance == null) {
            firstDistance = (Double)this.firstDistanceParameter.getDefaultValue();
        }
        try {
            Geometry modifiedGeometry;
            Line chamfer;
            if (StringUtils.equals((CharSequence)((String)this.values.get(this.methodParameter)), (CharSequence)CHAMFER_DISTANCE)) {
                Double secondDistance = (Double)this.getValue(this.secondDistanceParameter);
                if (secondDistance == null) {
                    secondDistance = (Double)this.secondDistanceParameter.getDefaultValue();
                }
                chamfer = this.calculateChamferDistanceMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
            } else {
                double angle = Math.toRadians((Double)this.values.get(this.angleParameter) == null ? (Double)this.angleParameter.getDefaultValue() : (Double)this.values.get(this.angleParameter));
                chamfer = this.calculateChamferAngleMethod(this.firstSegmentData, this.secondSegmentData, this.pointToChamfer, firstDistance, angle);
                if (chamfer == null) {
                    throw new IllegalArgumentException("Invalid segments.");
                }
            }
            Feature firstFeature = this.firstSegmentData.getFeature();
            Feature secondFeature = this.secondSegmentData.getFeature();
            Boolean doDeleteSecondSelectedGeometry = false;
            if (!Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
            }
            EditableFeature editableFeature = firstFeature.getEditable();
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Geometry firstGeometry = this.firstSegmentData.getGeometry();
            Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
            Primitive secondPrimitive = this.secondSegmentData.getPrimitive();
            if (Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                if (firstGeometry instanceof MultiPrimitive) {
                    modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    if (Objects.equals(firstPrimitive, secondPrimitive)) {
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                Primitive modifiedPrimitive = this.chamferPrimitive(primitive, chamfer);
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    } else {
                        Primitive modifiedPrimitive = this.chamferPrimitives(firstPrimitive, secondPrimitive, chamfer);
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    }
                } else {
                    modifiedGeometry = this.chamferPrimitive((Primitive)editableFeature.getDefaultGeometry(), chamfer);
                }
            } else {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
                Primitive modifiedPrimitive = this.chamferPrimitives(firstPrimitive, secondPrimitive, chamfer);
                modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                if (firstGeometry instanceof MultiPrimitive) {
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    for (Geometry geometry : firstMultiPrimitive) {
                        Primitive primitive = (Primitive)geometry;
                        if (Objects.equals(firstPrimitive, primitive)) {
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                            continue;
                        }
                        ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                    }
                } else {
                    modifiedGeometry = modifiedPrimitive;
                }
                if (doDeleteSecondSelectedGeometry.booleanValue()) {
                    secondFeature.getStore().delete(secondFeature);
                }
            }
            editableFeature.setDefaultGeometry(modifiedGeometry);
            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    private Primitive chamferPrimitive(Primitive primitive, Line chamfer) throws IllegalStateException, GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        if (primitive instanceof Line || primitive instanceof Polygon) {
            modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        } else if (primitive instanceof Curve) {
            modifiedPrimitive = (Line)primitive.toLines().getPrimitiveAt(0);
        } else if (primitive instanceof Surface) {
            modifiedPrimitive = (Line)primitive.toPolygons().getPrimitiveAt(0);
        }
        boolean collapsedChamfer = Objects.equals(chamfer.getVertex(0), chamfer.getVertex(1));
        if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() - 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + 1, chamfer.getVertex(0));
                ((Line)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 2);
                if (!collapsedChamfer) {
                    ((Line)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + 2, chamfer.getVertex(1));
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + 1, chamfer.getVertex(0));
                ((Polygon)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 2);
                if (!collapsedChamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + 2, chamfer.getVertex(1));
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() + 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + 1, chamfer.getVertex(1));
                ((Line)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 2);
                if (!collapsedChamfer) {
                    ((Line)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + 2, chamfer.getVertex(0));
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + 1, chamfer.getVertex(1));
                ((Polygon)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 2);
                if (!collapsedChamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + 2, chamfer.getVertex(0));
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 2) && Objects.equals(this.secondSegmentData.getPosition(), 0)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).insertVertex(0, chamfer.getVertex(1));
                if (!collapsedChamfer) {
                    ((Line)modifiedPrimitive).insertVertex(0, chamfer.getVertex(0));
                }
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                ((Line)modifiedPrimitive).insertVertex(((Line)modifiedPrimitive).getNumVertices(), chamfer.getVertex(0));
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).insertVertex(0, chamfer.getVertex(1));
                if (!collapsedChamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(0, chamfer.getVertex(0));
                }
                ((Polygon)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(((Line)modifiedPrimitive).getNumVertices(), chamfer.getVertex(0));
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 0) && Objects.equals(this.secondSegmentData.getPosition(), 2)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).insertVertex(0, chamfer.getVertex(0));
                if (!collapsedChamfer) {
                    ((Line)modifiedPrimitive).insertVertex(0, chamfer.getVertex(1));
                }
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                ((Line)modifiedPrimitive).insertVertex(((Line)modifiedPrimitive).getNumVertices(), chamfer.getVertex(1));
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).insertVertex(0, chamfer.getVertex(0));
                if (!collapsedChamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(0, chamfer.getVertex(1));
                }
                ((Polygon)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(((Line)modifiedPrimitive).getNumVertices(), chamfer.getVertex(1));
            }
        } else {
            throw new IllegalStateException("Invalid segments");
        }
        return modifiedPrimitive;
    }

    private Primitive chamferPrimitives(Primitive firstPrimitive, Primitive secondPrimitive, Line chamfer) throws IllegalStateException, GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Line secondLine;
        Line firstLine;
        if (firstPrimitive == null) {
            throw new IllegalArgumentException("firstPrimitive is null");
        }
        if (firstPrimitive instanceof Line) {
            firstLine = (Line)firstPrimitive.cloneGeometry();
        } else {
            MultiLine lines = firstPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find first primitive.");
            }
            firstLine = (Line)lines.getPrimitiveAt(0);
        }
        if (secondPrimitive == null) {
            throw new IllegalArgumentException("secondPrimitive is null");
        }
        if (secondPrimitive instanceof Line) {
            secondLine = (Line)secondPrimitive;
        } else {
            MultiLine lines = secondPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find second primitive.");
            }
            secondLine = (Line)lines.getPrimitiveAt(0);
        }
        boolean collapsedChamfer = Objects.equals(chamfer.getVertex(0), chamfer.getVertex(1));
        Line modifiedPrimitive = firstLine;
        if (Objects.equals(this.firstSegmentData.getPosition(), 2)) {
            modifiedPrimitive.removeVertex(modifiedPrimitive.getNumVertices() - 1);
            modifiedPrimitive.addVertex(chamfer.getVertex(0));
            if (!collapsedChamfer) {
                modifiedPrimitive.addVertex(chamfer.getVertex(1));
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            }
        } else {
            modifiedPrimitive.removeVertex(0);
            modifiedPrimitive.insertVertex(0, chamfer.getVertex(0));
            if (!collapsedChamfer) {
                modifiedPrimitive.insertVertex(0, chamfer.getVertex(1));
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            }
        }
        return modifiedPrimitive;
    }

    private Line calculateChamferDistanceMethod(SegmentData firstSegmentData, SegmentData secondSegmentData, Point pointToChamfer, Double firstDistance, Double secondDistance) throws CreateGeometryException, DataException, LocatorException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Pair<Point, Point> pair = this.calculateOpositeToChamferVertices(firstSegmentData, secondSegmentData);
        Point oppositeVertex1 = (Point)pair.getLeft();
        Point oppositeVertex2 = (Point)pair.getRight();
        double angle1 = GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)oppositeVertex1);
        double angle2 = GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)oppositeVertex2);
        Point firstPoint = GeometryUtils.createPoint((Point)pointToChamfer, (double)firstDistance, (double)angle1);
        Point secondPoint = GeometryUtils.createPoint((Point)pointToChamfer, (double)secondDistance, (double)angle2);
        return GeometryUtils.createLine((Point)firstPoint, (Point)secondPoint, (int)editingProviderServices.getSubType(this.featureStore));
    }

    private Pair<Point, Point> calculateOpositeToChamferVertices(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        if (Objects.equals(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(0);
                secondVertex = secondSegmentData.getLine().getVertex(1);
            } else if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(1);
                secondVertex = secondSegmentData.getLine().getVertex(0);
            } else {
                firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
                secondVertex = Objects.equals(secondSegmentData.getPosition(), 2) ? secondSegmentData.getLine().getVertex(0) : secondSegmentData.getLine().getVertex(1);
            }
        } else {
            firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
            secondVertex = Objects.equals(secondSegmentData.getPosition(), 2) ? secondSegmentData.getLine().getVertex(0) : secondSegmentData.getLine().getVertex(1);
        }
        return new ImmutablePair((Object)firstVertex, (Object)secondVertex);
    }

    private Line calculateChamferAngleMethod(SegmentData firstSegmentData, SegmentData secondSegmentData, Point pointToChamfer, Double firstDistance, Double angle) throws CreateGeometryException, DataException, LocatorException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Double secondDistance = (Double)this.getValue(this.secondDistanceParameter);
        if (secondDistance == null) {
            secondDistance = (Double)this.secondDistanceParameter.getDefaultValue();
        }
        Line tmpChamfer = this.calculateChamferDistanceMethod(firstSegmentData, secondSegmentData, this.pointToChamfer, firstDistance, secondDistance);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Line rotatedChamferLine = firstSegmentData.getLine().cloneGeometry();
        if (this.calculateZoneInSegment(pointToChamfer, secondSegmentData) == -1) {
            return null;
        }
        rotatedChamferLine.rotate(GeometryUtils.getCoefDirection((Point)tmpChamfer.getVertex(0), (Point)pointToChamfer, (Point)tmpChamfer.getVertex(1)) * angle, tmpChamfer.getVertex(0).getX(), tmpChamfer.getVertex(0).getY());
        EuclideanLine2D rotateChamferEuclideanLine = euclideanManager.createLine2D(rotatedChamferLine.getVertex(0).getX(), rotatedChamferLine.getVertex(0).getY(), rotatedChamferLine.getVertex(1).getX(), rotatedChamferLine.getVertex(1).getY());
        Line secondLine = secondSegmentData.getLine();
        EuclideanLine2D secondEuclideanLine = euclideanManager.createLine2D(secondLine.getVertex(0).getX(), secondLine.getVertex(0).getY(), secondLine.getVertex(1).getX(), secondLine.getVertex(1).getY());
        Point2D secondPoint2D = rotateChamferEuclideanLine.getIntersection(secondEuclideanLine);
        Point secondPoint = GeometryUtils.createPoint((double)secondPoint2D.getX(), (double)secondPoint2D.getY());
        if (this.calculateZoneInSegment(secondPoint, secondSegmentData) == -1) {
            return null;
        }
        return GeometryUtils.createLine((Point)tmpChamfer.getVertex(0), (Point)secondPoint, (int)editingProviderServices.getSubType(this.featureStore));
    }

    public void start() throws StartServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
        if (savedMethod != null) {
            this.values.put(this.methodParameter, savedMethod);
        }
        if (deleteSecondFeatureDefaultValue != null) {
            this.deleteSecondSelectedGeometryParameter.setDefaultValue((Object)deleteSecondFeatureDefaultValue);
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
        if (savedMethod != null) {
            this.values.put(this.methodParameter, savedMethod);
        }
        if (deleteSecondFeatureDefaultValue != null) {
            this.deleteSecondSelectedGeometryParameter.setDefaultValue((Object)deleteSecondFeatureDefaultValue);
        }
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Feature getFeatureNearestPoint(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Feature feature = editingProviderServices.getFeature(point, this.featureStore, this.mapContext);
        return feature;
    }

    private boolean validateAsSecondSegmentData(SegmentData segmentData, Point oppositeVertex) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        if (!segmentData.isFilled()) {
            return false;
        }
        if (this.firstSegmentData == null) {
            return false;
        }
        Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = segmentData.getPrimitive())) {
            if (Objects.equals(this.firstSegmentData.getIdxVertex(), segmentData.getIdxVertex())) {
                return false;
            }
            if (Math.abs(this.firstSegmentData.getIdxVertex() - segmentData.getIdxVertex()) == 1) {
                return true;
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0)) {
                            return true;
                        }
                    } else if ((this.firstSegmentData.getPosition().equals(0) || this.firstSegmentData.getPosition().equals(2)) && (segmentData.getPosition().equals(0) || segmentData.getPosition().equals(2))) {
                        Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
                        if (tmpPointToChamfer == null || this.calculateZoneInSegment(tmpPointToChamfer, segmentData) == -1 || this.calculateZoneInSegment(tmpPointToChamfer, this.firstSegmentData) == -1) {
                            return false;
                        }
                        return this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToChamfer);
                    }
                    return false;
                }
                case 19: {
                    return this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0);
                }
            }
            return false;
        }
        if (firstPrimitive.getType() != 18 || secondPrimitive.getType() != 18) {
            return false;
        }
        if (this.firstSegmentData.getPosition().equals(1) || segmentData.getPosition().equals(1)) {
            return false;
        }
        Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
        return tmpPointToChamfer != null && this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToChamfer);
    }

    private Point calculatePointToChamfer(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        Primitive firstPrimitive = firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex())) {
                return null;
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        return null;
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2) || firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return this.calculatePointToChamferSeparateSegments(firstSegmentData, secondSegmentData);
                    }
                    return null;
                }
                case 19: {
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    return null;
                }
            }
            return null;
        }
        if (firstPrimitive.getType() != 18) {
            return null;
        }
        if (secondPrimitive.getType() != 18) {
            return null;
        }
        if ((firstSegmentData.getPosition().equals(0) || firstSegmentData.getPosition().equals(2)) && (secondSegmentData.getPosition().equals(0) || secondSegmentData.getPosition().equals(2))) {
            return this.calculatePointToChamferSeparateSegments(firstSegmentData, secondSegmentData);
        }
        return null;
    }

    private Point calculatePointToChamferSeparateSegments(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanLine2D secondLine;
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D firstLine = euclideanManager.createLine2D(firstSegmentData.getLine().getVertex(0).getX(), firstSegmentData.getLine().getVertex(0).getY(), firstSegmentData.getLine().getVertex(1).getX(), firstSegmentData.getLine().getVertex(1).getY());
        Point2D intersection = firstLine.getIntersection(secondLine = euclideanManager.createLine2D(secondSegmentData.getLine().getVertex(0).getX(), secondSegmentData.getLine().getVertex(0).getY(), secondSegmentData.getLine().getVertex(1).getX(), secondSegmentData.getLine().getVertex(1).getY()));
        Point intersectionPoint = GeometryUtils.createPoint((double)intersection.getX(), (double)intersection.getY());
        if (intersectionPoint == null) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        return intersectionPoint;
    }

    private int calculateZoneInSegment(Point point, SegmentData segmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        Line line = segmentData.getLine();
        if (line.getNumVertices() > 2) {
            throw new IllegalArgumentException("Segment has more than two vertex.");
        }
        if (Objects.equals(segmentData.getPosition(), 2)) {
            firstVertex = line.getVertex(0);
            secondVertex = line.getVertex(1);
        } else {
            firstVertex = line.getVertex(1);
            secondVertex = line.getVertex(0);
        }
        double segmentLenght = firstVertex.distance((Geometry)secondVertex);
        if (segmentLenght >= firstVertex.distance((Geometry)point) && segmentLenght >= secondVertex.distance((Geometry)point)) {
            return 0;
        }
        if (firstVertex.distance((Geometry)point) > secondVertex.distance((Geometry)point)) {
            return 1;
        }
        return -1;
    }

    private boolean isPointBetweenTwoPoints(Point point, Point vertex1, Point vertex2) {
        if (point.getX() < vertex1.getX() && point.getX() < vertex2.getX()) {
            return false;
        }
        if (point.getX() > vertex1.getX() && point.getX() > vertex2.getX()) {
            return false;
        }
        if (point.getY() < vertex1.getY() && point.getY() < vertex2.getY()) {
            return false;
        }
        return !(point.getY() > vertex1.getY()) || !(point.getY() > vertex2.getY());
    }

    private Point calculatePointForDistance(SegmentData segmentData, Point pointToChamfer, Point oppositeVertex, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException, DataException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Line segment = segmentData.getLine();
        int zone = this.calculateZoneInSegment(point, segmentData);
        if (zone == -1) {
            return null;
        }
        Line line = GeometryUtils.createLine((Point)oppositeVertex, (Point)pointToChamfer, (int)editingProviderServices.getSubType(this.featureStore));
        return (Point)line.closestPoints((Geometry)point)[0];
    }

    private boolean validatePointForSecondDistance(Point point, Point fixPoint, Point secondVertex, Point pointToChamfer) throws DataException, CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanLine2D euclideanLine2;
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subType = editingProviderServices.getSubType(this.featureStore);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D euclideanLine1 = euclideanManager.createLine2D(secondVertex.getX(), secondVertex.getY(), pointToChamfer.getX(), pointToChamfer.getY());
        Point2D intersection = euclideanLine1.getIntersection(euclideanLine2 = euclideanManager.createLine2D(fixPoint.getX(), fixPoint.getY(), point.getX(), point.getY()));
        if (intersection == null) {
            return false;
        }
        return this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)intersection.getX(), (double)intersection.getY()), secondVertex, pointToChamfer);
    }
}

