/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.parabolicfillet;

import java.awt.Color;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.chamfer.SegmentData;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParabolicFilletEditingProvider
extends AbstractEditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParabolicFilletEditingProvider.class);
    private static final int INSIDE_THE_SEGMENT = 0;
    private static final int BEYOND_THE_SEGMENT = 1;
    private static final int INVALID_ZONE = -1;
    private static final String CHAMFER_DISTANCE = "_Distance";
    private static final String CHAMFER_ANGLE = "_Angle";
    private static final String SHORT_CHAMFER_DISTANCE = "_Short_distance";
    private static final String SHORT_CHAMFER_ANGLE = "_Short_angle";
    private static final String CHAMFER_METHOD = "_Method";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY_QUESTION = "_Delete_second_selected_geometry_question";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY = "_Delete_second_selected_geometry";
    private static final String YES = "_yes";
    private static final String NO = "_no";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private static Boolean deleteSecondFeatureDefaultValue;
    private final EditingServiceParameter distanceParameter;
    private final EditingServiceParameter firstSegmentParameter;
    private final EditingServiceParameter secondSegmentParameter;
    private final EditingServiceParameter angleParameter;
    private final EditingServiceParameter deleteSecondSelectedGeometryParameter;
    private final Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private SegmentData firstSegmentData;
    private SegmentData secondSegmentData;
    private Point pointToFillet;
    private static Double savedDistance;
    private ISymbol previewSymbol;

    public ParabolicFilletEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.firstSegmentParameter = new DefaultEditingServiceParameter("_First_segment", "_First_segment", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondSegmentParameter = new DefaultEditingServiceParameter("_Second_segment", "_Second_segment", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        DefaultEditingServiceParameterOptions methodOptions = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(CHAMFER_DISTANCE), (Object)CHAMFER_DISTANCE, i18nManager.getTranslation(SHORT_CHAMFER_DISTANCE)).add(i18nManager.getTranslation(CHAMFER_ANGLE), (Object)CHAMFER_ANGLE, i18nManager.getTranslation(SHORT_CHAMFER_ANGLE));
        String methodConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(i18nManager.getTranslation(CHAMFER_METHOD), (EditingServiceParameterOptions)methodOptions);
        this.distanceParameter = new DefaultEditingServiceParameter(CHAMFER_DISTANCE, CHAMFER_DISTANCE, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.DISTANCE});
        this.angleParameter = new DefaultEditingServiceParameter(CHAMFER_ANGLE, CHAMFER_ANGLE, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
        DefaultEditingServiceParameterOptions deleteSecondSelectedGeometryParameterOptions = new DefaultEditingServiceParameterOptions().add(YES, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(NO, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(DELETE_SECOND_SELECTED_GEOMETRY_QUESTION, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions);
        this.deleteSecondSelectedGeometryParameter = new DefaultEditingServiceParameter(DELETE_SECOND_SELECTED_GEOMETRY, consoleMsg, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions, null, false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
    }

    public String getName() {
        return "modify-parabolicfillet";
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.firstSegmentParameter) == null) {
            return this.firstSegmentParameter;
        }
        if (this.values.get(this.secondSegmentParameter) == null) {
            return this.secondSegmentParameter;
        }
        if (this.values.get(this.distanceParameter) == null) {
            return this.distanceParameter;
        }
        if (this.values.get(this.angleParameter) == null) {
            return this.angleParameter;
        }
        if (this.values.get(this.deleteSecondSelectedGeometryParameter) == null && !Objects.equals(this.firstSegmentData.getFeature().getReference(), this.secondSegmentData.getFeature().getReference())) {
            return this.deleteSecondSelectedGeometryParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries;
        block11: {
            geometries = new DefaultDrawingStatus();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
            auxiliaryPointSymbolEditing.setColor(Color.RED);
            ISimpleTextSymbol textSymbol = this.getTextSymbol();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            Object previewSymbol = null;
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                if (this.values == null) break block11;
                if (this.firstSegmentData == null) {
                    Feature firstFeature = this.getFeatureNearestPoint(mousePosition);
                    if (firstFeature == null) {
                        return geometries;
                    }
                    Geometry firstGeometry = firstFeature.getDefaultGeometry();
                    if (firstGeometry == null || !this.validateGeometryType(firstGeometry)) {
                        return geometries;
                    }
                    SegmentData segmentData = new SegmentData(firstFeature, mousePosition);
                    geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                    return geometries;
                }
                if (this.secondSegmentData == null) {
                    geometries.addStatus((Geometry)this.firstSegmentData.getLine(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)this.firstSegmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                    Feature secondFeature = this.getFeatureNearestPoint(mousePosition);
                    if (secondFeature == null) {
                        return geometries;
                    }
                    Geometry secondGeometry = secondFeature.getDefaultGeometry();
                    if (secondGeometry == null || !this.validateGeometryType(secondGeometry)) {
                        return geometries;
                    }
                    SegmentData segmentData = new SegmentData(secondFeature, mousePosition);
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToFilletVertices(this.firstSegmentData, segmentData);
                    if (this.validateAsSecondSegmentData(segmentData, (Point)oppositePoints.getRight())) {
                        geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                        Point tmpPointToFillet = this.calculatePointToFillet(this.firstSegmentData, segmentData);
                        geometries.addStatus((Geometry)tmpPointToFillet, auxiliaryPointSymbolEditing, "");
                        break block11;
                    }
                    return geometries;
                }
                if (this.values.get(this.distanceParameter) == null) {
                    Point tmpPointToFillet = this.calculatePointToFillet(this.firstSegmentData, this.secondSegmentData);
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToFilletVertices(this.firstSegmentData, this.secondSegmentData);
                    geometries.addStatus((Geometry)oppositePoints.getLeft(), (ISymbol)textSymbol, "LEFT");
                    geometries.addStatus((Geometry)oppositePoints.getRight(), (ISymbol)textSymbol, "RIGHT");
                    geometries.addStatus((Geometry)GeometryUtils.getMidPoint((Point)((Point)oppositePoints.getLeft()), (Point)((Point)oppositePoints.getRight()), (int)subtype), (ISymbol)textSymbol, "MID");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getLeft()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getRight()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    double angle = Math.toRadians((Double)(this.getValue(this.angleParameter) != null ? this.getValue(this.angleParameter) : this.angleParameter.getDefaultValue()));
                    Double distance = this.pointToFillet.distance((Geometry)mousePosition);
                    EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
                    Line base = GeometryUtils.createLine((double)this.pointToFillet.getX(), (double)this.pointToFillet.getY(), (double)(this.pointToFillet.getX() + distance), (double)this.pointToFillet.getY(), (int)subtype);
                    base.rotate(angle, this.pointToFillet.getX(), this.pointToFillet.getY());
                    EuclideanLine2D euclideanBase = euclideanManager.createLine2D(base.getVertex(0).getX(), base.getVertex(0).getY(), base.getVertex(1).getX(), base.getVertex(1).getY());
                    Point2D projectedPoint = euclideanBase.getNearestPoint(mousePosition.getX(), mousePosition.getY());
                    distance = this.pointToFillet.distance((Geometry)GeometryUtils.createPoint((double)projectedPoint.getX(), (double)projectedPoint.getY())) * 2.0;
                    ScaffoldingToParabolicFillet scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, this.pointToFillet, distance, angle, subtype);
                    geometries.addStatus((Geometry)scaffolding.getCentralLine(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getParallelLine1(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getParallelLine2(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getBase(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)this.pointToFillet, (ISymbol)textSymbol, String.valueOf(distance));
                    this.drawResult(geometries, this.firstSegmentData, this.secondSegmentData, scaffolding, subtype);
                    return geometries;
                }
                if (this.values.get(this.angleParameter) == null) {
                    Point tmpPointToFillet = this.calculatePointToFillet(this.firstSegmentData, this.secondSegmentData);
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToFilletVertices(this.firstSegmentData, this.secondSegmentData);
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getLeft()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getRight()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    Double distance = (Double)this.getValue(this.distanceParameter);
                    double angle = GeometryUtils.calculateAngle((Point)this.pointToFillet, (Point)mousePosition);
                    geometries.addStatus((Geometry)tmpPointToFillet, auxiliaryPointSymbolEditing, "");
                    ScaffoldingToParabolicFillet scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, this.pointToFillet, distance, angle, subtype);
                    geometries.addStatus((Geometry)scaffolding.getCentralLine(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getParallelLine1(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getParallelLine2(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)scaffolding.getBase(), auxiliaryLineSymbolEditing, "");
                    Line ruleAxisBaseLine = geometryManager.createLine(subtype);
                    ruleAxisBaseLine.addVertex(tmpPointToFillet);
                    Point p2 = geometryManager.createPoint(tmpPointToFillet.getX() + tmpPointToFillet.distance((Geometry)mousePosition), tmpPointToFillet.getY(), subtype);
                    ruleAxisBaseLine.addVertex(p2);
                    geometries.addStatus((Geometry)ruleAxisBaseLine, ruleAxisSymbol, "");
                    Line angleLine = geometryManager.createLine(subtype);
                    angleLine.addVertex(tmpPointToFillet);
                    angleLine.addVertex(mousePosition);
                    geometries.addStatus((Geometry)angleLine, ruleAxisSymbol, "");
                    Double ext = Math.PI * 2 - angle;
                    Arc arc = GeometryUtils.createArc((Point)tmpPointToFillet, (double)(tmpPointToFillet.distance((Geometry)mousePosition) / 2.0), (double)0.0, (double)angle, (int)0);
                    geometries.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                    double textDistance = 3.0 * tmpPointToFillet.distance((Geometry)mousePosition) / 4.0;
                    Point pointText = geometryManager.createPoint(tmpPointToFillet.getX() + textDistance * Math.cos(angle / 2.0), tmpPointToFillet.getY() + textDistance * Math.sin(angle / 2.0), subtype);
                    geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, GeometryUtils.formatAngle((String)"%5.3D\u00b0", (double)Math.toDegrees(angle)));
                    this.drawResult(geometries, this.firstSegmentData, this.secondSegmentData, scaffolding, subtype);
                    return geometries;
                }
                ScaffoldingToParabolicFillet scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, this.pointToFillet, (Double)this.getValue(this.distanceParameter), Math.toRadians((Double)this.getValue(this.angleParameter)), subtype);
                this.drawResult(geometries, this.firstSegmentData, this.secondSegmentData, scaffolding, subtype);
                return geometries;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return geometries;
    }

    private void drawResult(DefaultDrawingStatus geometries, SegmentData firstSegmentData, SegmentData secondSegmentData, ScaffoldingToParabolicFillet scaffolding, int subtype) throws CreateGeometryException, GeometryOperationNotSupportedException, IllegalStateException, GeometryException, GeometryOperationException {
        if (this.previewSymbol == null) {
            return;
        }
        Line fillet = this.calculateFillet(firstSegmentData, secondSegmentData, scaffolding, subtype);
        if (fillet == null) {
            return;
        }
        if (Objects.equals(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive())) {
            geometries.addStatus((Geometry)this.filletPrimitive(firstSegmentData.getPrimitive(), fillet), this.previewSymbol, null);
        } else {
            geometries.addStatus((Geometry)this.filletPrimitives(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive(), fillet), this.previewSymbol, null);
        }
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.distanceParameter);
        parameters.add(this.firstSegmentParameter);
        parameters.add(this.secondSegmentParameter);
        parameters.add(this.angleParameter);
        parameters.add(this.deleteSecondSelectedGeometryParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        block30: {
            try {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                int subtype = editingProviderServices.getSubType(this.featureStore);
                if (param == this.firstSegmentParameter) {
                    if (value instanceof Point) {
                        Point point = (Point)value;
                        Feature firstFeature = this.getFeatureNearestPoint(point);
                        if (firstFeature == null) {
                            throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest feature."));
                        }
                        Geometry firstGeometry = firstFeature.getDefaultGeometry();
                        if (!this.validateGeometryType(firstGeometry)) {
                            throw new InvalidEntryException((Throwable)new IllegalArgumentException("invalid geometry type"));
                        }
                        this.firstSegmentData = new SegmentData(firstFeature, point);
                        if (!this.firstSegmentData.isFilled()) {
                            this.firstSegmentData = null;
                            throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
                        }
                        if (this.firstSegmentData == null) {
                            throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
                        }
                        this.values.put(param, value);
                        this.previewSymbol = this.getPreviewSymbol(this.firstSegmentData.getFeature());
                    }
                    break block30;
                }
                if (param == this.secondSegmentParameter) {
                    if (!(value instanceof Point)) break block30;
                    Point point = (Point)value;
                    Feature secondFeature = this.getFeatureNearestPoint(point);
                    if (secondFeature == null) {
                        throw new InvalidEntryException(null);
                    }
                    SegmentData segmentData = new SegmentData(secondFeature, point);
                    Pair<Point, Point> oppositeVertices = this.calculateOpositeToFilletVertices(this.firstSegmentData, segmentData);
                    if (!this.validateAsSecondSegmentData(segmentData, (Point)oppositeVertices.getRight())) {
                        this.secondSegmentData = null;
                        this.pointToFillet = null;
                        throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest geometry."));
                    }
                    try {
                        this.secondSegmentData = segmentData;
                        this.pointToFillet = this.calculatePointToFillet(this.firstSegmentData, this.secondSegmentData);
                        this.angleParameter.setDefaultValue((Object)this.calculateDefaultAngle(this.pointToFillet, oppositeVertices));
                        this.values.put(param, value);
                        break block30;
                    }
                    catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                        throw new InvalidEntryException(ex);
                    }
                }
                if (param == this.distanceParameter) {
                    Double distance = null;
                    if (value instanceof Double) {
                        distance = (Double)value;
                    } else if (value instanceof Point) {
                        Point point = (Point)value;
                        distance = this.pointToFillet.distance((Geometry)point);
                        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
                        Line base = GeometryUtils.createLine((double)this.pointToFillet.getX(), (double)this.pointToFillet.getY(), (double)(this.pointToFillet.getX() + distance), (double)this.pointToFillet.getY(), (int)subtype);
                        base.rotate(Math.toRadians((Double)(this.getValue(this.angleParameter) != null ? this.getValue(this.angleParameter) : this.angleParameter.getDefaultValue())), this.pointToFillet.getX(), this.pointToFillet.getY());
                        EuclideanLine2D euclideanBase = euclideanManager.createLine2D(base.getVertex(0).getX(), base.getVertex(0).getY(), base.getVertex(1).getX(), base.getVertex(1).getY());
                        Point2D projectedPoint = euclideanBase.getNearestPoint(point.getX(), point.getY());
                        distance = this.pointToFillet.distance((Geometry)GeometryUtils.createPoint((double)projectedPoint.getX(), (double)projectedPoint.getY())) * 2.0;
                    } else if (value == null && (distance = (Double)this.distanceParameter.getDefaultValue()) == null) {
                        throw new InvalidEntryException(null);
                    }
                    this.values.put(param, distance);
                    savedDistance = distance;
                } else if (param == this.angleParameter) {
                    Double angle = null;
                    if (value instanceof Double) {
                        angle = Math.toRadians((Double)value);
                    } else if (value instanceof Point) {
                        Point point = (Point)value;
                        angle = GeometryUtils.calculateAngle((Point)this.pointToFillet, (Point)point);
                    } else if (value == null) {
                        angle = Math.toRadians((Double)param.getDefaultValue());
                    } else {
                        throw new InvalidEntryException(null);
                    }
                    Double distance = (Double)this.getValue(this.distanceParameter);
                    ScaffoldingToParabolicFillet scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, this.pointToFillet, distance, angle, subtype);
                    Line fillet = this.calculateFillet(this.firstSegmentData, this.secondSegmentData, scaffolding, subtype);
                    if (fillet == null) {
                        throw new InvalidEntryException(null);
                    }
                    this.values.put(param, Math.toDegrees(angle));
                } else if (param == this.deleteSecondSelectedGeometryParameter) {
                    Boolean v = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
                    this.values.put(param, v);
                    deleteSecondFeatureDefaultValue = v;
                }
            }
            catch (Exception ex) {
                throw new InvalidEntryException((Throwable)ex);
            }
        }
    }

    private Pair<Double, Double> calculateAngleRange(Point pointToFillet, Pair<Point, Point> oppositeVertices, double distance) throws CreateGeometryException, DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D line1Left = euclideanManager.createLine2D(pointToFillet.getX() - distance / 2.0, pointToFillet.getY(), ((Point)oppositeVertices.getLeft()).getX(), ((Point)oppositeVertices.getLeft()).getY());
        EuclideanLine2D line1Right = euclideanManager.createLine2D(pointToFillet.getX() - distance / 2.0, pointToFillet.getY(), ((Point)oppositeVertices.getRight()).getX(), ((Point)oppositeVertices.getRight()).getY());
        EuclideanLine2D line2Left = euclideanManager.createLine2D(pointToFillet.getX() + distance / 2.0, pointToFillet.getY(), ((Point)oppositeVertices.getLeft()).getX(), ((Point)oppositeVertices.getLeft()).getY());
        EuclideanLine2D line2Right = euclideanManager.createLine2D(pointToFillet.getX() + distance / 2.0, pointToFillet.getY(), ((Point)oppositeVertices.getRight()).getX(), ((Point)oppositeVertices.getRight()).getY());
        ArrayList<Double> angles = new ArrayList<Double>();
        angles.add(line1Left.getPerpendicular(pointToFillet.getX(), pointToFillet.getY()).getAngle());
        angles.add(line1Right.getPerpendicular(pointToFillet.getX(), pointToFillet.getY()).getAngle());
        angles.add(line2Left.getPerpendicular(pointToFillet.getX(), pointToFillet.getY()).getAngle());
        angles.add(line2Right.getPerpendicular(pointToFillet.getX(), pointToFillet.getY()).getAngle());
        angles.sort((o1, o2) -> o1.compareTo((Double)o2));
        ImmutablePair range = new ImmutablePair(angles.get(1), angles.get(2));
        return range;
    }

    private boolean validateGeometryType(Geometry geometry) throws IllegalArgumentException {
        ArrayList<Integer> validGeometryTypes = new ArrayList<Integer>(Arrays.asList(18, 19, 21, 22));
        return validGeometryTypes.contains(geometry.getType());
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Double distance = (Double)this.getValue(this.distanceParameter);
        Double angle = (Double)this.getValue(this.angleParameter);
        try {
            Geometry modifiedGeometry;
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subType = editingProviderServices.getSubType(this.featureStore);
            ScaffoldingToParabolicFillet scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, this.pointToFillet, distance, Math.toRadians(angle), subType);
            Line fillet = this.calculateFillet(this.firstSegmentData, this.secondSegmentData, scaffolding, subType);
            if (fillet == null) {
                throw new FinishServiceException("Can't calculate fillet.", null);
            }
            Feature firstFeature = this.firstSegmentData.getFeature();
            Feature secondFeature = this.secondSegmentData.getFeature();
            Boolean doDeleteSecondSelectedGeometry = false;
            if (!Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
            }
            EditableFeature editableFeature = firstFeature.getEditable();
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Geometry firstGeometry = this.firstSegmentData.getGeometry();
            Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
            Primitive secondPrimitive = this.secondSegmentData.getPrimitive();
            if (Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                if (firstGeometry instanceof MultiPrimitive) {
                    modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    if (Objects.equals(firstPrimitive, secondPrimitive)) {
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                Primitive modifiedPrimitive = this.filletPrimitive(primitive, fillet);
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    } else {
                        Primitive modifiedPrimitive = this.filletPrimitives(firstPrimitive, secondPrimitive, fillet);
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    }
                } else {
                    modifiedGeometry = this.filletPrimitive((Primitive)editableFeature.getDefaultGeometry(), fillet);
                }
            } else {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
                Primitive modifiedPrimitive = this.filletPrimitives(firstPrimitive, secondPrimitive, fillet);
                modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                if (firstGeometry instanceof MultiPrimitive) {
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    for (Geometry geometry : firstMultiPrimitive) {
                        Primitive primitive = (Primitive)geometry;
                        if (Objects.equals(firstPrimitive, primitive)) {
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                            continue;
                        }
                        ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                    }
                } else {
                    modifiedGeometry = modifiedPrimitive;
                }
                if (doDeleteSecondSelectedGeometry.booleanValue()) {
                    secondFeature.getStore().delete(secondFeature);
                }
            }
            editableFeature.setDefaultGeometry(modifiedGeometry);
            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    private Primitive filletPrimitive(Primitive primitive, Line fillet) throws IllegalStateException, GeometryException, GeometryOperationException, GeometryOperationNotSupportedException {
        Primitive modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        if (primitive instanceof Line || primitive instanceof Polygon) {
            modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        } else if (primitive instanceof Curve) {
            modifiedPrimitive = (Line)primitive.toLines().getPrimitiveAt(0);
        } else if (primitive instanceof Surface) {
            modifiedPrimitive = (Line)primitive.toPolygons().getPrimitiveAt(0);
        }
        if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() - 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 1);
                int i = 1;
                for (Point point : fillet) {
                    ((Line)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + i++, point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 1);
                int i = 1;
                for (Point point : fillet) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + i++, point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() + 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 1);
                Line flipedFillet = fillet.cloneGeometry();
                flipedFillet.flip();
                int i = 1;
                for (Point point : flipedFillet) {
                    ((Line)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + i++, point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 1);
                Line flipedFillet = fillet.cloneGeometry();
                flipedFillet.flip();
                int i = 1;
                for (Point point : flipedFillet) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + i++, point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 2) && Objects.equals(this.secondSegmentData.getPosition(), 0)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                for (Point point : fillet) {
                    ((Line)modifiedPrimitive).addVertex(point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).removeVertex(((Polygon)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(0, fillet.getVertex(fillet.getNumVertices() - 1));
                for (Point point : fillet) {
                    ((Polygon)modifiedPrimitive).addVertex(point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 0) && Objects.equals(this.secondSegmentData.getPosition(), 2)) {
            Line flipedFillet = fillet.cloneGeometry();
            flipedFillet.flip();
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                boolean i = true;
                for (Point point : flipedFillet) {
                    ((Line)modifiedPrimitive).addVertex(point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).removeVertex(((Polygon)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(0, flipedFillet.getVertex(flipedFillet.getNumVertices() - 1));
                for (Point point : flipedFillet) {
                    ((Polygon)modifiedPrimitive).addVertex(point);
                }
            }
        } else {
            throw new IllegalStateException("Invalid segments");
        }
        return modifiedPrimitive;
    }

    private Primitive filletPrimitives(Primitive firstPrimitive, Primitive secondPrimitive, Line fillet) throws IllegalStateException, GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Line secondLine;
        Line firstLine;
        if (firstPrimitive == null) {
            throw new IllegalArgumentException("firstPrimitive is null");
        }
        if (firstPrimitive instanceof Line) {
            firstLine = (Line)firstPrimitive.cloneGeometry();
        } else {
            MultiLine lines = firstPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find first primitive.");
            }
            firstLine = (Line)lines.getPrimitiveAt(0);
        }
        if (secondPrimitive == null) {
            throw new IllegalArgumentException("secondPrimitive is null");
        }
        if (secondPrimitive instanceof Line) {
            secondLine = (Line)secondPrimitive;
        } else {
            MultiLine lines = secondPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find second primitive.");
            }
            secondLine = (Line)lines.getPrimitiveAt(0);
        }
        Line modifiedPrimitive = firstLine;
        if (Objects.equals(this.firstSegmentData.getPosition(), 2)) {
            modifiedPrimitive.removeVertex(modifiedPrimitive.getNumVertices() - 1);
            for (Point point : fillet) {
                modifiedPrimitive.addVertex(point);
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            }
        } else {
            modifiedPrimitive.removeVertex(0);
            for (Point point : fillet) {
                modifiedPrimitive.insertVertex(0, point);
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            }
        }
        return modifiedPrimitive;
    }

    private Pair<Point, Point> calculateOpositeToFilletVertices(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        if (Objects.equals(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(0);
                secondVertex = secondSegmentData.getLine().getVertex(1);
            } else if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(1);
                secondVertex = secondSegmentData.getLine().getVertex(0);
            } else {
                firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
                secondVertex = Objects.equals(secondSegmentData.getPosition(), 0) ? secondSegmentData.getLine().getVertex(1) : secondSegmentData.getLine().getVertex(0);
            }
        } else {
            firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
            secondVertex = Objects.equals(secondSegmentData.getPosition(), 0) ? secondSegmentData.getLine().getVertex(1) : secondSegmentData.getLine().getVertex(0);
        }
        return new ImmutablePair((Object)firstVertex, (Object)secondVertex);
    }

    public void start() throws StartServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToFillet = null;
        if (savedDistance != null) {
            this.distanceParameter.setDefaultValue((Object)savedDistance);
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToFillet = null;
        if (savedDistance != null) {
            this.distanceParameter.setDefaultValue((Object)savedDistance);
        }
    }

    public void initDefaultValues() {
        super.initDefaultValues();
        if (deleteSecondFeatureDefaultValue != null) {
            this.deleteSecondSelectedGeometryParameter.setDefaultValue((Object)deleteSecondFeatureDefaultValue);
        }
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToFillet = null;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Feature getFeatureNearestPoint(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Feature feature = editingProviderServices.getFeature(point, this.featureStore, this.mapContext);
        return feature;
    }

    private boolean validateAsSecondSegmentData(SegmentData segmentData, Point oppositeVertex) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        if (!segmentData.isFilled()) {
            return false;
        }
        if (this.firstSegmentData == null) {
            return false;
        }
        Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = segmentData.getPrimitive())) {
            if (Objects.equals(this.firstSegmentData.getIdxVertex(), segmentData.getIdxVertex())) {
                return false;
            }
            if (Math.abs(this.firstSegmentData.getIdxVertex() - segmentData.getIdxVertex()) == 1) {
                return true;
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0)) {
                            return true;
                        }
                    } else if ((this.firstSegmentData.getPosition().equals(0) || this.firstSegmentData.getPosition().equals(2)) && (segmentData.getPosition().equals(0) || segmentData.getPosition().equals(2))) {
                        Point tmpPointToChamfer = this.calculatePointToFillet(this.firstSegmentData, segmentData);
                        if (tmpPointToChamfer == null || this.calculateZoneInSegment(tmpPointToChamfer, segmentData) == -1 || this.calculateZoneInSegment(tmpPointToChamfer, this.firstSegmentData) == -1) {
                            return false;
                        }
                        return this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToChamfer);
                    }
                    return false;
                }
                case 19: {
                    return this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0);
                }
            }
            return false;
        }
        if (firstPrimitive.getType() != 18 || secondPrimitive.getType() != 18) {
            return false;
        }
        if (this.firstSegmentData.getPosition().equals(1) || segmentData.getPosition().equals(1)) {
            return false;
        }
        Point tmpPointToFillet = this.calculatePointToFillet(this.firstSegmentData, segmentData);
        return tmpPointToFillet != null && this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToFillet);
    }

    private Point calculatePointToFillet(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        Primitive firstPrimitive = firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex())) {
                return null;
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        return null;
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2) || firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return this.calculatePointToFilletSeparateSegments(firstSegmentData, secondSegmentData);
                    }
                    return null;
                }
                case 19: {
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    return null;
                }
            }
            return null;
        }
        if (firstPrimitive.getType() != 18) {
            return null;
        }
        if (secondPrimitive.getType() != 18) {
            return null;
        }
        if ((firstSegmentData.getPosition().equals(0) || firstSegmentData.getPosition().equals(2)) && (secondSegmentData.getPosition().equals(0) || secondSegmentData.getPosition().equals(2))) {
            return this.calculatePointToFilletSeparateSegments(firstSegmentData, secondSegmentData);
        }
        return null;
    }

    private Point calculatePointToFilletSeparateSegments(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanLine2D secondLine;
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D firstLine = euclideanManager.createLine2D(firstSegmentData.getLine().getVertex(0).getX(), firstSegmentData.getLine().getVertex(0).getY(), firstSegmentData.getLine().getVertex(1).getX(), firstSegmentData.getLine().getVertex(1).getY());
        Point2D intersection = firstLine.getIntersection(secondLine = euclideanManager.createLine2D(secondSegmentData.getLine().getVertex(0).getX(), secondSegmentData.getLine().getVertex(0).getY(), secondSegmentData.getLine().getVertex(1).getX(), secondSegmentData.getLine().getVertex(1).getY()));
        Point intersectionPoint = GeometryUtils.createPoint((double)intersection.getX(), (double)intersection.getY());
        if (intersectionPoint == null) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        return intersectionPoint;
    }

    private int calculateZoneInSegment(Point point, SegmentData segmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        Line line = segmentData.getLine();
        if (line.getNumVertices() > 2) {
            throw new IllegalArgumentException("Segment has more than two vertex.");
        }
        if (Objects.equals(segmentData.getPosition(), 2)) {
            firstVertex = line.getVertex(0);
            secondVertex = line.getVertex(1);
        } else {
            firstVertex = line.getVertex(1);
            secondVertex = line.getVertex(0);
        }
        double segmentLenght = firstVertex.distance((Geometry)secondVertex);
        if (segmentLenght >= firstVertex.distance((Geometry)point) && segmentLenght >= secondVertex.distance((Geometry)point)) {
            return 0;
        }
        if (firstVertex.distance((Geometry)point) > secondVertex.distance((Geometry)point)) {
            return 1;
        }
        return -1;
    }

    private boolean isPointBetweenTwoPoints(Point point, Point vertex1, Point vertex2) {
        if (point.getX() < vertex1.getX() && point.getX() < vertex2.getX()) {
            return false;
        }
        if (point.getX() > vertex1.getX() && point.getX() > vertex2.getX()) {
            return false;
        }
        if (point.getY() < vertex1.getY() && point.getY() < vertex2.getY()) {
            return false;
        }
        return !(point.getY() > vertex1.getY()) || !(point.getY() > vertex2.getY());
    }

    private double calculateDefaultAngle(Point pointToFillet, Pair<Point, Point> oppositeVertices) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Point2D p = euclideanManager.getPointAtDistance(pointToFillet.getX(), pointToFillet.getY(), pointToFillet.distance((Geometry)oppositeVertices.getLeft()), GeometryUtils.calculateAngle((Point)pointToFillet, (Point)((Point)oppositeVertices.getRight())), null);
        Point midPoint = GeometryUtils.getMidPoint((Point)((Point)oppositeVertices.getLeft()), (Point)GeometryUtils.createPoint((double)p.getX(), (double)p.getY()), (int)pointToFillet.getGeometryType().getSubType());
        double angle = GeometryUtils.calculateAngle((Point)pointToFillet, (Point)midPoint);
        if ((angle += 1.5707963267948966) > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return Math.toDegrees(angle);
    }

    private Line calculateFillet(SegmentData firstSegmentData, SegmentData secondSegmentData, ScaffoldingToParabolicFillet scaffolding, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToFilletVertices(firstSegmentData, secondSegmentData);
        Line parallelLine1 = scaffolding.getParallelLine1();
        Line parallelLine2 = scaffolding.getParallelLine2();
        Point intersection1 = null;
        Point intersection2 = null;
        Line flank1 = GeometryUtils.createLine((Point)this.pointToFillet, (Point)((Point)oppositeVertices.getLeft()), (int)subType);
        Line flank2 = GeometryUtils.createLine((Point)this.pointToFillet, (Point)((Point)oppositeVertices.getRight()), (int)subType);
        intersection1 = (Point)flank1.intersection((Geometry)parallelLine1);
        intersection2 = (Point)flank2.intersection((Geometry)parallelLine2);
        if (intersection1 == null || intersection2 == null) {
            intersection1 = (Point)flank1.intersection((Geometry)parallelLine2);
            intersection2 = (Point)flank2.intersection((Geometry)parallelLine1);
        }
        if (intersection1 == null || intersection2 == null) {
            return null;
        }
        Line fillet = GeometryUtils.createLine((int)subType);
        QuadCurve2D.Double quadCurve = new QuadCurve2D.Double(intersection1.getX(), intersection1.getY(), this.pointToFillet.getX(), this.pointToFillet.getY(), intersection2.getX(), intersection2.getY());
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        double flatness = geometryManager.getFlatness();
        PathIterator pi = quadCurve.getPathIterator(null, flatness);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    fillet.addVertex(geometryManager.createPoint(coords[0], coords[1], subType));
                    break;
                }
                case 1: {
                    fillet.addVertex(geometryManager.createPoint(coords[0], coords[1], subType));
                    break;
                }
                case 2: {
                    fillet.addVertex(geometryManager.createPoint(coords[0], coords[1], subType));
                    fillet.addVertex(geometryManager.createPoint(coords[2], coords[3], subType));
                    break;
                }
                case 3: {
                    fillet.addVertex(geometryManager.createPoint(coords[0], coords[1], subType));
                    fillet.addVertex(geometryManager.createPoint(coords[2], coords[3], subType));
                    fillet.addVertex(geometryManager.createPoint(coords[4], coords[5], subType));
                    break;
                }
                case 4: {
                    fillet.addVertex(fillet.getVertex(0));
                }
            }
            pi.next();
        }
        return fillet;
    }

    private ScaffoldingToParabolicFillet calculateScaffolding(SegmentData firstSegmentData, SegmentData secondSegmentData, Point pointToFillet, Double distance, Double angle, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToFilletVertices(firstSegmentData, secondSegmentData);
        double large = pointToFillet.distance((Geometry)oppositeVertices.getLeft()) >= pointToFillet.distance((Geometry)oppositeVertices.getRight()) ? pointToFillet.distance((Geometry)oppositeVertices.getLeft()) : pointToFillet.distance((Geometry)oppositeVertices.getRight());
        Line base = GeometryUtils.createLine((double)(pointToFillet.getX() - distance / 2.0), (double)pointToFillet.getY(), (double)(pointToFillet.getX() + distance / 2.0), (double)pointToFillet.getY(), (int)subType);
        Line centralLine = GeometryUtils.createLine((double)pointToFillet.getX(), (double)pointToFillet.getY(), (double)pointToFillet.getX(), (double)(pointToFillet.getY() - large), (int)subType);
        Line parallelLine1 = GeometryUtils.createLine((double)(pointToFillet.getX() + distance / 2.0), (double)pointToFillet.getY(), (double)(pointToFillet.getX() + distance / 2.0), (double)(pointToFillet.getY() - large), (int)subType);
        Line parallelLine2 = GeometryUtils.createLine((double)(pointToFillet.getX() - distance / 2.0), (double)pointToFillet.getY(), (double)(pointToFillet.getX() - distance / 2.0), (double)(pointToFillet.getY() - large), (int)subType);
        base.rotate(angle.doubleValue(), pointToFillet.getX(), pointToFillet.getY());
        centralLine.rotate(angle.doubleValue(), pointToFillet.getX(), pointToFillet.getY());
        parallelLine1.rotate(angle.doubleValue(), pointToFillet.getX(), pointToFillet.getY());
        parallelLine2.rotate(angle.doubleValue(), pointToFillet.getX(), pointToFillet.getY());
        ScaffoldingToParabolicFillet scaffolding = new ScaffoldingToParabolicFillet(base, centralLine, parallelLine1, parallelLine2);
        return scaffolding;
    }

    private class ScaffoldingToParabolicFillet {
        private final Line base;
        private final Line centralLine;
        private final Line parallelLine1;
        private final Line parallelLine2;

        public ScaffoldingToParabolicFillet(Line base, Line centralLine, Line parallelLine1, Line parallelLine2) {
            this.base = base;
            this.centralLine = centralLine;
            this.parallelLine1 = parallelLine1;
            this.parallelLine2 = parallelLine2;
        }

        public Line getBase() {
            return this.base;
        }

        public Line getCentralLine() {
            return this.centralLine;
        }

        public Line getParallelLine1() {
            return this.parallelLine1;
        }

        public Line getParallelLine2() {
            return this.parallelLine2;
        }
    }
}

