/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.algorithm;

import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roimask.algorithm.ROIMaskException;

public class ROIMaskProcess
extends DataProcess {
    public static String RASTER_STORE1 = "RasterStore1";
    public static String BUFFER = "Buffer";
    public static String PATH = "Path";
    public static String FILENAME = "FileName";
    public static String ROIS = "Rois";
    public static String INVERSE = "Inverse";
    public static String ALPHA = "Alpha";
    public static String ALPHA_BAND = "AlphaBand";
    public static String NODATA = "NoData";
    private RasterDataStore store = null;
    private String filename = null;
    private ROI[] rois = null;
    private boolean inverse = false;
    private int alpha = 0;
    private NoData nodata = null;
    private double noDataResult = 0.0;
    private Buffer bufferForTest = null;

    public static void registerParameters() {
        ROIMaskProcess.registerInputParameter((String)RASTER_STORE1, RasterDataStore.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerInputParameter((String)PATH, String.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerInputParameter((String)ROIS, ROI[].class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerInputParameter((String)INVERSE, Boolean.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerInputParameter((String)ALPHA, Integer.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerInputParameter((String)NODATA, NoData.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerOutputParameter((String)FILENAME, String.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerOutputParameter((String)ALPHA_BAND, Buffer.class, (String)"ROIMaskProcess");
        ROIMaskProcess.registerOutputParameter((String)BUFFER, Buffer.class, (String)"ROIMaskProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE1) != null ? (RasterDataStore)this.getParam(RASTER_STORE1) : null;
        this.filename = this.getStringParam(PATH);
        this.inverse = this.getBooleanParam(INVERSE);
        this.alpha = this.getIntParam(ALPHA);
        this.nodata = this.getParam(NODATA) != null ? (NoData)this.getParam(NODATA) : null;
        this.rois = this.getParam(ROIS) != null ? (ROI[])this.getParam(ROIS) : null;
        switch (this.store.getDataType()[0]) {
            case 0: {
                if (this.nodata.getValue() != null) {
                    this.noDataResult = this.nodata.getValue().byteValue();
                    break;
                }
                this.noDataResult = RasterLibrary.defaultByteNoDataValue;
                break;
            }
            case 2: {
                if (this.nodata.getValue() != null) {
                    this.noDataResult = this.nodata.getValue().shortValue();
                    break;
                }
                this.noDataResult = RasterLibrary.defaultShortNoDataValue;
                break;
            }
            case 3: {
                if (this.nodata.getValue() != null) {
                    this.noDataResult = this.nodata.getValue().intValue();
                    break;
                }
                this.noDataResult = RasterLibrary.defaultIntegerNoDataValue;
                break;
            }
            case 4: {
                if (this.nodata.getValue() != null) {
                    this.noDataResult = this.nodata.getValue().floatValue();
                    break;
                }
                this.noDataResult = RasterLibrary.defaultFloatNoDataValue;
                break;
            }
            case 5: {
                this.noDataResult = this.nodata.getValue() != null ? this.nodata.getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
            }
        }
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        this.insertLineLog(Messages.getText((String)"applying_mask"));
        try {
            if (this.store == null) {
                throw new ROIMaskException("Store not found");
            }
            RasterQuery query = RasterLocator.getManager().createQuery();
            Extent windowExtent = this.getExtentResult(this.getOutputWindow(), null, this.store);
            Rectangle2D sourcePxBBox = null;
            if (this.isOutputRescaled()) {
                sourcePxBBox = new Rectangle2D.Double(0.0, 0.0, this.getOutputWidth(), this.getOutputHeight());
                query.setSupersamplingOption(true);
            } else {
                sourcePxBBox = this.getSourcePxBox(windowExtent, this.store);
                query.setSupersamplingOption(false);
            }
            double cellSize = windowExtent.width() / sourcePxBBox.getWidth();
            if (this.isForPreviews()) {
                query.setReadOnly(false);
                query.forceRGBRequest();
                query.setDrawableBands(this.store.getRender().getRenderColorInterpretation().buildRenderBands());
            } else {
                query.setAllDrawableBands();
                query.setReadOnly(true);
            }
            int w = (int)sourcePxBBox.getWidth();
            int h = (int)sourcePxBBox.getHeight();
            query.setAreaOfInterest(windowExtent, w, h);
            Buffer sourceBuffer = null;
            try {
                sourceBuffer = this.store.query(query);
                sourceBuffer.setDataExtent(windowExtent.toRectangle2D());
            }
            catch (QueryException e) {
                throw new ROIMaskException("Error reading data", e);
            }
            this.bufferForTest = sourceBuffer;
            ColorInterpretation ci = this.store.getColorInterpretation();
            int ouputAlphaBandNumber = -1;
            if (this.rois != null && this.rois.length > 0) {
                this.nodata.setNoDataTransparent(false);
                if (ci.isRGBA()) {
                    this.bufferForTest = this.processRGB(windowExtent, sourceBuffer, w, h, cellSize, ci.getAlphaBand());
                    ouputAlphaBandNumber = this.bufferForTest.getBandCount() - 1;
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation("ARGB");
                } else if (ci.isRGB()) {
                    this.bufferForTest = this.processRGB(windowExtent, sourceBuffer, w, h, cellSize, -1);
                    ouputAlphaBandNumber = this.bufferForTest.getBandCount() - 1;
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation("ARGB");
                } else {
                    this.bufferForTest = this.processMDT(windowExtent, sourceBuffer, cellSize);
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation("GRAYSCALE");
                }
            }
            if (!this.isForPreviews()) {
                super.exportRaster(this.filename, this.bufferForTest, ci, windowExtent, this.nodata, this.store.getProjection());
                this.addOutputValue(FILENAME, this.filename);
            } else {
                this.addOutputValue(BUFFER, this.bufferForTest);
            }
            this.addOutputValue(ALPHA_BAND, ouputAlphaBandNumber);
        }
        catch (ROIMaskException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("Error in mask process", (Object)this, (Exception)((Object)e));
        }
    }

    private Buffer processRGB(Extent extent, Buffer sourceBuffer, int w, int h, double cellsize, int inputAlphaBandNumber) throws ProcessInterruptedException, ProcessException {
        BufferParam params = RasterLocator.getManager().getBufferFactory().createBufferParams(w, h, 4, this.store.getDataType()[0], true);
        Buffer outputBuffer = null;
        try {
            outputBuffer = RasterLocator.getManager().getBufferFactory().createBuffer(params);
        }
        catch (Exception e) {
            throw new ProcessException("Error creating buffer", (Throwable)e);
        }
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                double wcX = extent.minX() + (double)col * extent.width() / (double)w;
                double wcY = extent.minY() + (double)(h - row) * extent.height() / (double)h;
                for (int iBand = 0; iBand < 3; ++iBand) {
                    outputBuffer.setElem(row, col, iBand, sourceBuffer.getElemByte(row, col, iBand));
                }
                boolean insideRoi = false;
                for (int i = 0; i < this.rois.length; ++i) {
                    if (!this.rois[i].isInside(wcX, wcY, cellsize, cellsize)) continue;
                    if (this.inverse) {
                        if (inputAlphaBandNumber != -1) {
                            outputBuffer.setElem(row, col, 3, sourceBuffer.getElemByte(row, col, inputAlphaBandNumber));
                        } else {
                            outputBuffer.setElem(row, col, 3, (byte)-1);
                        }
                    } else {
                        outputBuffer.setElem(row, col, 3, (byte)(255 - this.alpha));
                    }
                    insideRoi = true;
                }
                if (insideRoi) continue;
                if (this.inverse) {
                    outputBuffer.setElem(row, col, 3, (byte)(255 - this.alpha));
                    continue;
                }
                if (inputAlphaBandNumber != -1) {
                    outputBuffer.setElem(row, col, 3, sourceBuffer.getElemByte(row, col, inputAlphaBandNumber));
                    continue;
                }
                outputBuffer.setElem(row, col, 3, (byte)-1);
            }
            this.updatePercent(row, h);
        }
        return outputBuffer;
    }

    private Buffer processMDT(Extent extent, Buffer inputBuffer, double cellsize) throws ProcessInterruptedException, ProcessException {
        int w = inputBuffer.getWidth();
        int h = inputBuffer.getHeight();
        Buffer outputBuffer = null;
        BufferParam params = RasterLocator.getManager().getBufferFactory().createBufferParams(w, h, inputBuffer.getBandCount(), inputBuffer.getDataType(), true);
        try {
            outputBuffer = RasterLocator.getManager().getBufferFactory().createBuffer(params);
        }
        catch (Exception e) {
            throw new ProcessException("Error creating buffer", (Throwable)e);
        }
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                for (int nband = 0; nband < inputBuffer.getBandCount(); ++nband) {
                    double wcX = extent.minX() + (double)col * extent.width() / (double)w;
                    double wcY = extent.minY() + (double)(h - row) * extent.height() / (double)h;
                    boolean insideRoi = false;
                    for (int i = 0; i < this.rois.length; ++i) {
                        if (!this.rois[i].isInside(wcX, wcY, cellsize, cellsize)) continue;
                        if (this.inverse) {
                            this.writePixel(inputBuffer, outputBuffer, col, row, nband);
                        } else {
                            this.writeNoData(outputBuffer, col, row, nband);
                        }
                        insideRoi = true;
                    }
                    if (insideRoi) continue;
                    if (this.inverse) {
                        this.writeNoData(outputBuffer, col, row, nband);
                        continue;
                    }
                    this.writePixel(inputBuffer, outputBuffer, col, row, nband);
                }
            }
            this.updatePercent(row, h);
        }
        return outputBuffer;
    }

    private void writePixel(Buffer inputBuffer, Buffer outputBuffer, int col, int row, int nband) {
        switch (inputBuffer.getDataType()) {
            case 0: {
                outputBuffer.setElem(row, col, nband, inputBuffer.getElemByte(row, col, nband));
                break;
            }
            case 2: {
                outputBuffer.setElem(row, col, nband, inputBuffer.getElemShort(row, col, nband));
                break;
            }
            case 3: {
                outputBuffer.setElem(row, col, nband, inputBuffer.getElemInt(row, col, nband));
                break;
            }
            case 4: {
                outputBuffer.setElem(row, col, nband, inputBuffer.getElemFloat(row, col, nband));
                break;
            }
            case 5: {
                outputBuffer.setElem(row, col, nband, inputBuffer.getElemDouble(row, col, nband));
            }
        }
    }

    private void writeNoData(Buffer outputBuffer, int col, int row, int nband) {
        switch (outputBuffer.getDataType()) {
            case 0: {
                outputBuffer.setElem(row, col, nband, (byte)this.noDataResult);
                break;
            }
            case 2: {
                outputBuffer.setElem(row, col, nband, (short)this.noDataResult);
                break;
            }
            case 3: {
                outputBuffer.setElem(row, col, nband, (int)this.noDataResult);
                break;
            }
            case 4: {
                outputBuffer.setElem(row, col, nband, (float)this.noDataResult);
                break;
            }
            case 5: {
                outputBuffer.setElem(row, col, nband, this.noDataResult);
            }
        }
    }

    public String getTitle() {
        return Messages.getText((String)"mask_process");
    }
}

