/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.index.quadtree.LazySearchCollection;
import org.geotools.index.quadtree.LazySearchIterator;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;

public class QuadTree {
    private static final double SPLITRATIO = 0.55;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.index.quadtree");
    private Node root;
    private int numShapes;
    private int maxDepth;
    private Set iterators = new HashSet();

    public QuadTree(int numShapes, Envelope maxBounds) {
        this(numShapes, 0, maxBounds);
    }

    public QuadTree(int numShapes, int maxDepth, Envelope maxBounds) {
        if (maxDepth > 65535) {
            throw new IllegalArgumentException("maxDepth must be <= 65535");
        }
        this.numShapes = numShapes;
        this.maxDepth = maxDepth;
        if (maxBounds != null) {
            this.root = new Node(new Envelope(maxBounds), 0, null);
        }
        if (maxDepth == 0) {
            int numNodes = 1;
            while (numNodes * 4 < numShapes) {
                ++this.maxDepth;
                numNodes *= 2;
            }
        }
    }

    public QuadTree(int numShapes, int maxDepth) {
        this(numShapes, maxDepth, null);
    }

    public void insert(int recno, Envelope bounds) throws StoreException {
        this.insert(this.root, recno, bounds, this.maxDepth);
    }

    private void insert(Node node, int recno, Envelope bounds, int md) throws StoreException {
        if (md > 1 && node.getNumSubNodes() > 0) {
            Node subNode = null;
            int i = 0;
            while (i < node.getNumSubNodes()) {
                subNode = node.getSubNode(i);
                if (subNode.getBounds().contains(bounds)) {
                    this.insert(subNode, recno, bounds, md - 1);
                    return;
                }
                ++i;
            }
        } else if (md > 1 && node.getNumSubNodes() == 0) {
            Envelope[] tmp = this.splitBounds(node.getBounds());
            Envelope half1 = tmp[0];
            Envelope half2 = tmp[1];
            tmp = this.splitBounds(half1);
            Envelope quad1 = tmp[0];
            Envelope quad2 = tmp[1];
            tmp = this.splitBounds(half2);
            Envelope quad3 = tmp[0];
            Envelope quad4 = tmp[1];
            if (quad1.contains(bounds) || quad2.contains(bounds) || quad3.contains(bounds) || quad4.contains(bounds)) {
                node.addSubNode(new Node(quad1, 0, node));
                node.addSubNode(new Node(quad2, 1, node));
                node.addSubNode(new Node(quad3, 2, node));
                node.addSubNode(new Node(quad4, 3, node));
                this.insert(node, recno, bounds, md);
                return;
            }
        }
        node.addShapeId(recno);
    }

    public List query(Envelope bounds) {
        ArrayList<Integer> solution = new ArrayList<Integer>();
        Stack<Node> nodesToVisit = new Stack<Node>();
        nodesToVisit.push(this.root);
        while (nodesToVisit.size() != 0) {
            Node current = (Node)nodesToVisit.pop();
            if (!current.getBounds().intersects(bounds)) continue;
            int[] indexes = current.getShapesId();
            int i = 0;
            while (i < indexes.length) {
                if (indexes[i] != -1) {
                    solution.add(new Integer(indexes[i]));
                }
                ++i;
            }
            int numSubNodes = current.getNumSubNodes();
            int i2 = 0;
            while (i2 < numSubNodes) {
                try {
                    nodesToVisit.push(current.getSubNode(i2));
                }
                catch (StoreException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        Collections.sort(solution);
        return solution;
    }

    public void delete(Envelope bounds, int numRec) {
        Stack<Node> nodesToVisit = new Stack<Node>();
        nodesToVisit.push(this.root);
        while (nodesToVisit.size() != 0) {
            Node current = (Node)nodesToVisit.pop();
            if (!current.getBounds().intersects(bounds)) continue;
            int[] indexes = current.getShapesId();
            int i = 0;
            while (i < indexes.length) {
                if (indexes[i] == -1) break;
                if (indexes[i] == numRec) {
                    current.removeShapeId(i);
                    --this.numShapes;
                    return;
                }
                ++i;
            }
            int numSubNodes = current.getNumSubNodes();
            int i2 = 0;
            while (i2 < numSubNodes) {
                try {
                    nodesToVisit.push(current.getSubNode(i2));
                }
                catch (StoreException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
    }

    public Collection search(Envelope bounds) throws StoreException {
        LazySearchCollection lazySearchCollection;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Querying " + bounds);
        }
        try {
            lazySearchCollection = new LazySearchCollection(this, bounds);
        }
        catch (RuntimeException e) {
            LOGGER.warning("IOException occurred while reading root");
            return null;
        }
        return lazySearchCollection;
    }

    public void close(Iterator iter) throws StoreException {
        this.iterators.remove(iter);
        if (iter instanceof LazySearchIterator) {
            ((LazySearchIterator)iter).close();
        }
    }

    public boolean trim() throws StoreException {
        LOGGER.fine("Trimming the tree...");
        return this.trim(this.root);
    }

    private boolean trim(Node node) throws StoreException {
        Node[] dummy = new Node[node.getNumSubNodes()];
        int i = 0;
        while (i < node.getNumSubNodes()) {
            dummy[i] = node.getSubNode(i);
            ++i;
        }
        i = 0;
        while (i < dummy.length) {
            if (this.trim(dummy[i])) {
                node.removeSubNode(dummy[i]);
            }
            ++i;
        }
        if (node.getNumSubNodes() == 1 && node.getNumShapeIds() == 0) {
            Node subNode = node.getSubNode(0);
            node.clearSubNodes();
            int i2 = 0;
            while (i2 < subNode.getNumSubNodes()) {
                node.addSubNode(subNode.getSubNode(i2));
                ++i2;
            }
            node.setShapesId(subNode.getShapesId());
            node.setBounds(subNode.getBounds());
        }
        return node.getNumSubNodes() == 0 && node.getNumShapeIds() == 0;
    }

    private Envelope[] splitBounds(Envelope in) {
        Envelope[] ret = new Envelope[2];
        if (in.getMaxX() - in.getMinX() > in.getMaxY() - in.getMinY()) {
            double range = in.getMaxX() - in.getMinX();
            double calc = in.getMinX() + range * 0.55;
            ret[0] = new Envelope(in.getMinX(), calc, in.getMinY(), in.getMaxY());
            calc = in.getMaxX() - range * 0.55;
            ret[1] = new Envelope(calc, in.getMaxX(), in.getMinY(), in.getMaxY());
        } else {
            double range = in.getMaxY() - in.getMinY();
            double calc = in.getMinY() + range * 0.55;
            ret[0] = new Envelope(in.getMinX(), in.getMaxX(), in.getMinY(), calc);
            calc = in.getMaxY() - range * 0.55;
            ret[1] = new Envelope(in.getMinX(), in.getMaxX(), calc, in.getMaxY());
        }
        return ret;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public void setNumShapes(int numShapes) {
        this.numShapes = numShapes;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public void close() throws StoreException {
        if (!this.iterators.isEmpty()) {
            throw new StoreException("There are still open iterators!!");
        }
    }

    public void registerIterator(Iterator object) {
        this.iterators.add(object);
    }

    public static void main(String[] args) {
        QuadTree q = new QuadTree(100, 8, new Envelope(0.0, 300.0, 0.0, 500.0));
        try {
            int i = 1;
            while (i <= 100) {
                q.insert(i, new Envelope((double)(100 + i), 100.0, (double)(200 - i), 200.0));
                ++i;
            }
        }
        catch (StoreException e) {
            e.printStackTrace();
        }
        int i = 1;
        while (i <= 100) {
            System.out.println(i);
            q.delete(new Envelope((double)(100 + i), 100.0, (double)(200 - i), 200.0), i);
            ++i;
        }
        System.out.println(q.getNumShapes());
    }
}

