/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.index.rtree.database.Dialect;

public abstract class AbstractDialect
implements Dialect {
    protected static final String CAT_TABLE = "rtrees_cat";
    private static final String QUERY_CAT = "select * from rtrees_cat where rtree_name=?";
    private static final String INSERT_CAT = "insert into rtrees_cat (rtree_name, min_entries, max_entries, split_alg) values (?, ?, ?, ?)";
    private int current = -1;

    public String getCatalogQuery() {
        return QUERY_CAT;
    }

    public String getCatalogInsert() {
        return INSERT_CAT;
    }

    public synchronized int getNextPageId(Connection cnn, String tableName) throws SQLException {
        if (this.current == -1) {
            Statement pst = null;
            ResultSet rs = null;
            try {
                pst = cnn.prepareStatement("select max(page_id) from " + tableName);
                rs = pst.executeQuery();
                rs.next();
                this.current = rs.getInt(1);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    pst.close();
                }
                catch (Exception exception) {}
            }
        }
        return ++this.current;
    }

    public String getSelectPage(String tableName) {
        return "select * from " + tableName + " where page_id=?";
    }

    public String getInsertPage(String tableName) {
        return "insert into " + tableName + " (page_id, fl_leaf, blob_content)" + " values (?,?,?)";
    }

    public String getUpdatePage(String tableName) {
        return "update " + tableName + " set fl_leaf=?, blob_content=? where page_id=?";
    }
}

