/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class JETALineBorder
extends LineBorder {
    private boolean m_top = true;
    private boolean m_left = true;
    private boolean m_bottom = true;
    private boolean m_right = true;

    public JETALineBorder() {
        super(Color.black);
    }

    public JETALineBorder(Color c, int thickness, boolean curved, boolean top, boolean left, boolean bottom, boolean right) {
        super(c, thickness, curved);
        this.m_top = top;
        this.m_left = left;
        this.m_bottom = bottom;
        this.m_right = right;
    }

    public Insets getBorderInsets(Component c) {
        if (this.getRoundedCorners()) {
            return super.getBorderInsets(c);
        }
        int thickness = this.getThickness();
        return new Insets(this.m_top ? thickness : 0, this.m_left ? thickness : 0, this.m_bottom ? thickness : 0, this.m_right ? thickness : 0);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (this.getRoundedCorners()) {
            return super.getBorderInsets(c, insets);
        }
        insets.left = this.m_left ? this.thickness : 0;
        insets.top = this.m_top ? this.thickness : 0;
        insets.right = this.m_right ? this.thickness : 0;
        insets.bottom = this.m_bottom ? this.thickness : 0;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.getRoundedCorners() || this.m_top && this.m_bottom && this.m_right && this.m_left) {
            super.paintBorder(c, g, x, y, width, height);
        } else {
            Color oldColor = g.getColor();
            g.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                int top = y + i;
                int left = x + i;
                int right = left + width - i - i - 1;
                int bottom = top + height - i - i - 1;
                if (this.m_top) {
                    g.drawLine(x, top, x + width - 1, top);
                }
                if (this.m_left) {
                    g.drawLine(left, y, left, y + height - 1);
                }
                if (this.m_bottom) {
                    g.drawLine(x, bottom, x + width - 1, bottom);
                }
                if (!this.m_right) continue;
                g.drawLine(right, y, right, y + height - 1);
            }
            g.setColor(oldColor);
        }
    }
}

