/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans;

import com.jeta.forms.gui.beans.DynamicPropertyDescriptor;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.beans.StandardPropertyDescriptor;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class DynamicBeanInfo {
    private BeanInfo m_delegate;
    private TreeMap m_props = new TreeMap();

    public DynamicBeanInfo(BeanInfo delegate) throws IntrospectionException, IllegalAccessException {
        this(delegate, null);
    }

    public DynamicBeanInfo(BeanInfo delegate, Collection customProps) throws IntrospectionException, IllegalAccessException {
        this.m_delegate = delegate;
        PropertyDescriptor[] pds = delegate.getPropertyDescriptors();
        for (int index = 0; index < pds.length; ++index) {
            StandardPropertyDescriptor std_pds = new StandardPropertyDescriptor(pds[index]);
            this.m_props.put(std_pds.getName(), std_pds);
        }
        if (customProps != null) {
            Iterator iter = customProps.iterator();
            while (iter.hasNext()) {
                JETAProperty prop = (JETAProperty)iter.next();
                FormUtils.safeAssert(prop.getName() != null);
                this.m_props.put(prop.getName(), new DynamicPropertyDescriptor(prop.getName(), prop.getClass(), prop.isPreferred(), prop.isTransient()));
            }
        }
        this.removePropertyDescriptor("debugGraphicsOptions");
    }

    public int getDefaultPropertyIndex() {
        return this.m_delegate.getDefaultPropertyIndex();
    }

    public Image getIcon(int i) {
        return this.m_delegate.getIcon(i);
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.m_delegate.getBeanDescriptor();
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return this.m_delegate.getAdditionalBeanInfo();
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.m_delegate.getMethodDescriptors();
    }

    public JETAPropertyDescriptor getPropertyDescriptor(String propName) {
        return (JETAPropertyDescriptor)this.m_props.get(propName);
    }

    public Collection getPropertyDescriptors() {
        return this.m_props.values();
    }

    void register(JETAPropertyDescriptor prop) {
        if (prop != null) {
            this.m_props.put(prop.getName(), prop);
        }
    }

    void removePropertyDescriptor(String propName) {
        this.m_props.remove(propName);
    }
}

