/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.formmgr;

import com.jeta.forms.beanmgr.BeanManager;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLUtils;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.FormPackage;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class FormManagerUtils {
    private static final int DEFAULT_BUFFER_SIZE = 20480;

    public static FormMemento loadForm(InputStream is) throws ClassNotFoundException, IOException, JMLException {
        if (is instanceof ObjectInputStream) {
            FormMemento memento = null;
            Object obj = ((ObjectInputStream)is).readObject();
            memento = obj instanceof FormPackage ? ((FormPackage)obj).getMemento() : (FormMemento)obj;
            return memento;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] first_read = new byte[1024];
        byte[] data = new byte[20480];
        int nread = is.read(first_read);
        if (nread > 0) {
            baos.write(first_read, 0, nread);
            nread = is.read(data);
        }
        while (nread > 0) {
            baos.write(data, 0, nread);
            nread = is.read(data);
        }
        boolean found_binary = true;
        int BINARY_TAG_OFFSET = 4;
        String binary_tag = "sr\u0000(com.jeta.forms.store.memento.FormPackage";
        for (int index = 0; index < binary_tag.length(); ++index) {
            if (first_read[index + BINARY_TAG_OFFSET] == (byte)binary_tag.charAt(index)) continue;
            found_binary = false;
            break;
        }
        FormMemento memento = null;
        if (found_binary) {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object obj = ois.readObject();
            memento = obj instanceof FormPackage ? ((FormPackage)obj).getMemento() : (FormMemento)obj;
        } else {
            FormPackage fp = (FormPackage)JMLUtils.readObject(new ByteArrayInputStream(baos.toByteArray()));
            memento = fp.getMemento();
        }
        return memento;
    }

    public static FormComponent openForm(InputStream istream) throws FormException {
        try {
            FormMemento memento = FormManagerUtils.loadForm(istream);
            FormComponent fc = FormComponent.create();
            fc.setState(memento);
            return fc;
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public static FormComponent openPackagedForm(String relativePath) throws FormException {
        FormUtils.safeAssert(!FormUtils.isDesignMode());
        FormUtils.safeAssert(relativePath != null);
        FormUtils.safeAssert(relativePath.length() > 0);
        try {
            File f;
            String abspath;
            ProjectManager pmgr = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
            FormUtils.safeAssert(pmgr != null);
            if (pmgr != null && (abspath = pmgr.getAbsolutePath(relativePath)) != null && (f = new File(abspath)).isFile()) {
                return FormManagerUtils.openForm(new FileInputStream(f));
            }
            FormsLogger.debug("FormManagerUtils.loadForm: " + relativePath);
            relativePath = relativePath.replace('\\', '/');
            ResourceLoader loader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
            BufferedInputStream bis = new BufferedInputStream(loader.getResourceAsStream(relativePath), 20480);
            FormMemento memento = FormManagerUtils.loadForm(bis);
            FormComponent fc = FormComponent.create();
            fc.setState(memento);
            bis.close();
            return fc;
        }
        catch (Exception e) {
            try {
                BeanManager bm = (BeanManager)JETARegistry.lookup("jeta.forms.bean.manager");
                if (bm != null) {
                    ClassLoader loader = bm.getClassLoader();
                    return FormManagerUtils.openForm(loader.getResourceAsStream(relativePath));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("FormManagerUtils.openPackgedForm failed: " + relativePath);
            e.printStackTrace();
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            FormsLogger.severe(I18N.format("Error_loading_form_1", relativePath));
            throw new FormException(e);
        }
    }
}

