/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Insets;
import java.io.IOException;

public class CellConstraintsMemento
extends AbstractJETAPersistable {
    static final long serialVersionUID = 7894081609390290274L;
    public static final int VERSION = 1;
    private int m_column;
    private int m_row;
    private int m_colspan;
    private int m_rowspan;
    private Insets m_insets;
    private String m_valign;
    private String m_halign;

    public CellConstraintsMemento() {
    }

    public CellConstraintsMemento(CellConstraints cc) {
        this.m_column = cc.gridX;
        this.m_row = cc.gridY;
        this.m_colspan = cc.gridWidth;
        this.m_rowspan = cc.gridHeight;
        this.m_halign = cc.hAlign.toString();
        this.m_valign = cc.vAlign.toString();
        this.m_insets = cc.insets;
    }

    public CellConstraints createCellConstraints() {
        try {
            return new CellConstraints(this.m_column, this.m_row, this.m_colspan, this.m_rowspan, FormUtils.toAlignment(this.m_halign), FormUtils.toAlignment(this.m_valign), this.m_insets);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CellConstraints();
        }
    }

    public int getRow() {
        return this.m_row;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
        this.m_column = in.readInt("column");
        this.m_row = in.readInt("row");
        this.m_colspan = in.readInt("colspan");
        this.m_rowspan = in.readInt("rowspan");
        this.m_halign = (String)in.readObject("halign");
        this.m_valign = (String)in.readObject("valign");
        this.m_insets = (Insets)in.readObject("insets");
    }

    public void write(JETAObjectOutput out) throws IOException {
        out.writeVersion(1);
        out.writeInt("column", this.m_column);
        out.writeInt("row", this.m_row);
        out.writeInt("colspan", this.m_colspan);
        out.writeInt("rowspan", this.m_rowspan);
        out.writeObject("halign", this.m_halign);
        out.writeObject("valign", this.m_valign);
        out.writeObject("insets", this.m_insets);
    }
}

