/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconProperty
extends JETAProperty
implements Icon {
    static final long serialVersionUID = -7743120720855547949L;
    public static final int VERSION = 1;
    private boolean m_embedded = false;
    private String m_path;
    private transient ImageIcon m_image;
    private String m_description;
    private int[] m_pixels;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getDescription() {
        return this.m_description;
    }

    public ImageIcon imageIcon() {
        return this.m_image;
    }

    public int getIconWidth() {
        return this.m_image == null ? 0 : this.m_image.getIconWidth();
    }

    public int getIconHeight() {
        return this.m_image == null ? 0 : this.m_image.getIconHeight();
    }

    public String getRelativePath() {
        return this.m_path;
    }

    public boolean isEmbedded() {
        return this.m_embedded;
    }

    public void loadImage() {
        try {
            ProjectManager pmgr = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
            if (pmgr != null && this.m_path != null && this.m_path.length() > 0) {
                this.m_image = pmgr.loadImage(this.m_path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.m_image != null) {
            this.m_image.paintIcon(c, g, x, y);
        }
    }

    public void print() {
        System.out.println("IconProperty..................");
        System.out.println("  embedded: " + this.isEmbedded());
        System.out.println("  description: " + this.getDescription());
        System.out.println("  path: " + this.getRelativePath());
        System.out.println("  width: " + this.getIconWidth());
        System.out.println("  height: " + this.getIconHeight());
    }

    public void setEmbedded(boolean bembedded) {
        this.m_embedded = false;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
    }

    public void setRelativePath(String path) {
        this.m_path = path;
        this.m_image = null;
        this.loadImage();
        if (path != null) {
            int pos = path.lastIndexOf(92);
            this.m_description = (pos = Math.max(pos, path.lastIndexOf(47))) > 0 ? path.substring(pos + 1, path.length()) : path;
        }
    }

    public void setValue(Object prop) {
        if (prop == this) {
            return;
        }
        if (prop instanceof IconProperty) {
            IconProperty iprop = (IconProperty)prop;
            this.m_embedded = false;
            this.m_path = iprop.m_path;
            this.m_image = iprop.m_image;
            this.m_description = iprop.m_description;
            if (!this.m_embedded && this.m_image == null) {
                this.loadImage();
            }
        } else if (prop == null) {
            this.m_path = "";
            this.m_image = null;
            this.m_description = "";
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_embedded = in.readBoolean("embedded");
        this.m_path = in.readString("path");
        if (FormUtils.isDesignMode()) {
            this.m_path = FormUtils.fixPath(this.m_path);
        }
        this.m_description = in.readString("description");
        int w = in.readInt("width");
        int h = in.readInt("height");
        this.m_embedded = false;
        this.loadImage();
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeBoolean("embedded", this.m_embedded);
        out.writeObject("path", this.m_path);
        out.writeObject("description", this.m_description);
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        out.writeInt("width", width);
        out.writeInt("height", height);
    }

    static {
        $assertionsDisabled = !IconProperty.class.desiredAssertionStatus();
    }
}

