/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.gui.layerproperties.ExpressionSymbolPanelView;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;

public class ExpressionSymbolPanel
extends ExpressionSymbolPanelView {
    private final FeatureStore store;
    private PickerController<ISymbol> pickerSymbolController;
    private JExpressionBuilder expressionPanel;
    private final ISymbol symbol;
    private final int symbolType;

    public ExpressionSymbolPanel(FeatureStore store, int symbolType, ISymbol symbol) {
        this.store = store;
        this.symbolType = symbolType;
        this.symbol = symbol;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        toolsSwingManager.translate((JComponent)this.lblExpression);
        toolsSwingManager.translate((JComponent)this.lblSymbolAndDescriptor);
        this.expressionPanel = dataSwingManager.createQueryFilterExpresion(this.store);
        this.pnlExpression.setLayout(new BorderLayout());
        this.pnlExpression.add((Component)this.expressionPanel.asJComponent(), "Center");
        this.pickerSymbolController = SymbologySwingLocator.getSwingManager().createSymbolPickerController(this.btnSymbolPreview, (JTextComponent)this.txtSymbolDescription, this.symbolType, this.symbol);
        this.setPreferredSize(new Dimension(800, 500));
    }

    public String getExpression() {
        Expression exp = this.expressionPanel.getExpression();
        if (exp == null) {
            return null;
        }
        return exp.getPhrase();
    }

    public ISymbol getSymbol() {
        ISymbol theSymbol = (ISymbol)this.pickerSymbolController.get();
        if (theSymbol == null) {
            return null;
        }
        return theSymbol;
    }
}

