/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.annotation.AnnotationCreationService;
import org.gvsig.annotation.AnnotationCreationServiceException;
import org.gvsig.annotation.AnnotationManager;
import org.gvsig.annotation.calculator.AnnotationPositionCalculator;
import org.gvsig.annotation.calculator.AnnotationPositionCalculatorCreationException;
import org.gvsig.annotation.impl.DefaultAnnotationCreationService;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.ServiceException;

public class DefaultAnnotationManager
implements AnnotationManager {
    private static final String ANNOTATION_POSITION_CALCULATOR_EXTENSION_POINT = "AnnotationPositionCalculatorExtensionPoint";
    private ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
    private static final String DEFAULT_ANNOTATION_POSITION_CALCULATOR = "DefaultAnnotationPositionCalculator";
    private String defaultTextValue = null;
    private int defaultFontColor = -1;
    private double defaultFontHeight = -1.0;
    private double defaultFontRotation = -1.0;
    private String defaultFontStyle = null;
    private String defaultFontType = null;
    private List<String> fontTypes = Collections.synchronizedList(new ArrayList());
    private List<String> fontStyles = Collections.synchronizedList(new ArrayList());

    public AnnotationCreationService getAnnotationCreationService(FeatureStore featureStore) throws ServiceException {
        DefaultAnnotationCreationService fc;
        try {
            fc = new DefaultAnnotationCreationService(featureStore, this);
        }
        catch (DataException e) {
            throw new AnnotationCreationServiceException("Impossible to create the annotation service", (Throwable)e);
        }
        return fc;
    }

    public AnnotationPositionCalculator getAnnotationPositionCalculator(String name) throws AnnotationPositionCalculatorCreationException {
        if (this.extensionPointManager.get(ANNOTATION_POSITION_CALCULATOR_EXTENSION_POINT).has(name)) {
            try {
                return (AnnotationPositionCalculator)this.extensionPointManager.get(ANNOTATION_POSITION_CALCULATOR_EXTENSION_POINT).create(name);
            }
            catch (InstantiationException e) {
                throw new AnnotationPositionCalculatorCreationException(name, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AnnotationPositionCalculatorCreationException(name, (Throwable)e);
            }
        }
        throw new IllegalArgumentException("There is not an annotation position calculator registered with this name");
    }

    public List<String> getAnnotationPositionCalculatorList() {
        return this.extensionPointManager.get(ANNOTATION_POSITION_CALCULATOR_EXTENSION_POINT).getNames();
    }

    public AnnotationPositionCalculator getDefaultAnnotationPositionCalculator() throws AnnotationPositionCalculatorCreationException {
        return this.getAnnotationPositionCalculator(DEFAULT_ANNOTATION_POSITION_CALCULATOR);
    }

    public void registerAnnotationPositionCalculator(String name, Class annotationPositionCalculatorClass) {
        if (!AnnotationPositionCalculator.class.isAssignableFrom(annotationPositionCalculatorClass)) {
            throw new IllegalArgumentException(annotationPositionCalculatorClass.getName() + " must implement the AnnotationPositionCalculator interface");
        }
        ExtensionPoint extensionPoint = this.extensionPointManager.add(ANNOTATION_POSITION_CALCULATOR_EXTENSION_POINT, "");
        extensionPoint.append(name, name, annotationPositionCalculatorClass);
    }

    public void registerDefaultAnnotationPositionCalculator(Class annotationPositionCalculatorClass) {
        this.registerAnnotationPositionCalculator(DEFAULT_ANNOTATION_POSITION_CALCULATOR, annotationPositionCalculatorClass);
    }

    public void addFontStyle(String fontStyle) {
        this.fontStyles.add(fontStyle);
    }

    public void addFontType(String fontType) {
        this.fontTypes.add(fontType);
    }

    public int getDefaultFontColor() {
        return this.defaultFontColor;
    }

    public double getDefaultFontHeight() {
        return this.defaultFontHeight;
    }

    public double getDefaultFontRotation() {
        return this.defaultFontRotation;
    }

    public String getDefaultFontStyle() {
        return this.defaultFontStyle;
    }

    public String getDefaultFontType() {
        return this.defaultFontType;
    }

    public String getDefaultTextValue() {
        return this.defaultTextValue;
    }

    public List<String> getFontStyles() {
        return this.fontStyles;
    }

    public List<String> getFontTypes() {
        return this.fontTypes;
    }

    public void setDefaultFontColor(int fontColor) {
        this.defaultFontColor = fontColor;
    }

    public void setDefaultFontColor(Color fontColor) {
        this.defaultFontColor = fontColor.getRGB();
    }

    public void setDefaultFontHeight(double fontHeight) {
        this.defaultFontHeight = fontHeight;
    }

    public void setDefaultFontRotation(double fontRotation) {
        this.defaultFontRotation = fontRotation;
    }

    public void setDefaultFontStyle(String fontStyle) {
        this.defaultFontStyle = fontStyle;
    }

    public void setDefaultFontType(String fontType) {
        this.defaultFontType = fontType;
    }

    public void setDefaultTextValue(String textValue) {
        this.defaultTextValue = textValue;
    }
}

