/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.Umath;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;
import org.python.core.PyObject;

final class Tanh
extends UnaryFunction {
    Tanh() {
    }

    @Override
    String docString() {
        return "tanh(a [,r]) returns tanh(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            double d = Array.getDouble(a.data, i);
            double e2d = Math.exp(2.0 * d);
            Array.setDouble(a.data, i, (e2d - 1.0) / (e2d + 1.0));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        PyObject e2a = Umath.exp.__call__(UnaryFunction.cp2.__mul__((PyObject)a));
        return PyMultiarray.asarray(e2a.__sub__((PyObject)UnaryFunction.cp1).__div__(e2a.__add__((PyObject)UnaryFunction.cp1)));
    }
}

