/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrLoximuthal
extends MapProjection {
    protected final double latitudeOfCenter;
    protected final double longitudeOfCenter;

    protected IdrLoximuthal(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.LATITUDE_OF_CENTER)) {
            this.latitudeOfCenter = Math.abs(IdrLoximuthal.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)parameters));
            IdrLoximuthal.ensureLatitudeInRange((ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (double)this.latitudeOfCenter, (boolean)false);
        } else {
            this.latitudeOfCenter = Double.NaN;
        }
        if (expected.contains(Provider.LONGITUDE_OF_CENTER)) {
            this.longitudeOfCenter = Math.abs(IdrLoximuthal.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)parameters));
            IdrLoximuthal.ensureLongitudeInRange((ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (double)this.longitudeOfCenter, (boolean)false);
        } else {
            this.longitudeOfCenter = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        List expected = this.getParameterDescriptors().descriptors();
        ParameterValueGroup values = super.getParameterValues();
        IdrLoximuthal.set((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.latitudeOfCenter);
        IdrLoximuthal.set((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.longitudeOfCenter);
        return values;
    }

    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_center"), new NamedIdentifier(CitationImpl.OGC, "central_parallel"), new NamedIdentifier(CitationImpl.OGC, "Central parallel"), new NamedIdentifier(CitationImpl.OGC, "central-parallel"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Spherical latitude of origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "longitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Spherical longitude of origin"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLong")}, (double)0.0, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Miller_Cylindrical"), new NamedIdentifier(CitationImpl.GEOTIFF, "MillerCylindrical"), new NamedIdentifier(CitationImpl.EPSG, "Miller Cylindrical"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrLoximuthal(parameters);
        }
    }
}

