/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.CoordTransRuntimeException;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gdal.gdal.gdal;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.proj.CrsProj;
import org.gvsig.crs.proj.OperationCrsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COperation
implements ICoordTrans {
    private static final Logger logger = LoggerFactory.getLogger(COperation.class);
    private ICrs sourceCrs;
    private ICrs targetCrs;
    private CrsProj paramsCrsProj = null;
    private boolean paramsInTarget;
    private String sourceParams = null;
    private String targetParams = null;
    private CrsProj source = null;
    private CrsProj target = null;
    private CoordinateTransformation coordinateTransformation = null;

    public COperation(ICrs from, ICrs to) throws CrsException {
        this.sourceCrs = from;
        this.targetCrs = to;
        this.source = this.sourceCrs.getCrsProj();
        this.target = this.targetCrs.getCrsProj();
    }

    public COperation(ICrs sourceCrs, ICrs targetCrs, String sourceParams, String targetParams) throws CrsException {
        this.sourceCrs = sourceCrs;
        this.targetCrs = targetCrs;
        this.sourceParams = sourceParams;
        this.targetParams = targetParams;
        this.source = sourceParams != null ? new CrsProj(this.addParamsInProj4String(sourceCrs.getProj4String(), sourceParams) + " +wktext") : sourceCrs.getCrsProj();
        this.target = targetParams != null ? new CrsProj(this.addParamsInProj4String(targetCrs.getProj4String(), targetParams) + " +wktext") : targetCrs.getCrsProj();
    }

    private String addParamsInProj4String(String proj4String, String params) {
        String res = proj4String;
        if (!StringUtils.isEmpty((CharSequence)params)) {
            res = proj4String.contains("+towgs84=") ? proj4String.replaceFirst("[+]towgs84=[^ ]*", params) : proj4String.concat(" ").concat(params);
        }
        return res;
    }

    private Point2D operate(Point2D pt) throws CrsException, OperationCrsException {
        double x = pt.getX();
        double y = pt.getY();
        int errno = 0;
        String msg = "";
        int errtype = 0;
        double[] transformed = new double[]{0.0, 0.0, 0.0};
        this.initializeCoordinateTransformation();
        gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
        gdal.ErrorReset();
        if (this.coordinateTransformation != null) {
            this.coordinateTransformation.TransformPoint(transformed, x, y, 0.0);
        }
        gdal.PopErrorHandler();
        errno = gdal.GetLastErrorNo();
        msg = gdal.GetLastErrorMsg();
        errtype = gdal.GetLastErrorType();
        Point2D.Double result = null;
        if (errno != 0 || errtype != 0 || !msg.isEmpty()) {
            if (msg.equalsIgnoreCase("Reprojection failed, err = -14, further errors will be supressed on the transform object.")) {
                this.resetCoordinateTransformation();
            }
            throw new CoordTransRuntimeException((IProjection)this.sourceCrs, (IProjection)this.targetCrs, x, y);
        }
        result = new Point2D.Double(transformed[0], transformed[1]);
        return result;
    }

    private void initializeCoordinateTransformation() {
        if (this.coordinateTransformation == null) {
            int errno = 0;
            String msg = "";
            int errtype = 0;
            gdal.ErrorReset();
            gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
            SpatialReference sourceSpatialReference = this.source.getSpatialReference();
            SpatialReference targetSpatialReference = this.target.getSpatialReference();
            this.coordinateTransformation = CoordinateTransformation.CreateCoordinateTransformation((SpatialReference)sourceSpatialReference, (SpatialReference)targetSpatialReference);
            gdal.PopErrorHandler();
            errno = gdal.GetLastErrorNo();
            msg = gdal.GetLastErrorMsg();
            errtype = gdal.GetLastErrorType();
            if (errno != 0 || errtype != 0 || !msg.isEmpty()) {
                logger.warn("Can't initialize coordinate transformation from " + this.sourceCrs.getAbrev() + " to " + this.targetCrs.getAbrev() + " " + errno + " " + errtype + " " + msg + ".");
            }
        }
    }

    private void resetCoordinateTransformation() {
        this.coordinateTransformation = null;
        this.initializeCoordinateTransformation();
    }

    public IProjection getPOrig() {
        return this.sourceCrs;
    }

    public IProjection getPDest() {
        return this.targetCrs;
    }

    public Point2D convert(Point2D ptOrig, Point2D ptDest) throws CoordTransRuntimeException {
        try {
            ptDest = this.operate(ptOrig);
        }
        catch (CrsException e) {
            logger.error("Can't operate over point orig (" + ptOrig.toString() + ").", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (OperationCrsException e) {
            logger.error("Can't operate over point orig (" + ptOrig.toString() + ").", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        return ptDest;
    }

    public Rectangle2D convert(Rectangle2D rect) throws CoordTransRuntimeException {
        Point2D pt1 = new Point2D.Double(rect.getMinX(), rect.getMinY());
        Point2D pt2 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
        Point2D pt3 = new Point2D.Double(rect.getMinX(), rect.getMaxY());
        Point2D pt4 = new Point2D.Double(rect.getMaxX(), rect.getMinY());
        try {
            pt1 = this.operate(pt1);
            pt2 = this.operate(pt2);
            pt3 = this.operate(pt3);
            pt4 = this.operate(pt4);
        }
        catch (CrsException e) {
            logger.error("Can't operate over rect (" + rect.toString() + ").", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (OperationCrsException e) {
            logger.error("Can't operate over rect (" + rect.toString() + ").", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        double min_x = Math.min(Math.min(pt1.getX(), pt2.getX()), Math.min(pt3.getX(), pt4.getX()));
        double min_y = Math.min(Math.min(pt1.getY(), pt2.getY()), Math.min(pt3.getY(), pt4.getY()));
        double max_x = Math.max(Math.max(pt1.getX(), pt2.getX()), Math.max(pt3.getX(), pt4.getX()));
        double max_y = Math.max(Math.max(pt1.getY(), pt2.getY()), Math.max(pt3.getY(), pt4.getY()));
        return new Rectangle2D.Double(min_x, min_y, max_x - min_x, max_y - min_y);
    }

    public ICoordTrans getInverted() {
        try {
            COperation operation = new COperation(this.targetCrs, this.sourceCrs, this.targetParams, this.sourceParams);
            return operation;
        }
        catch (CrsException e) {
            logger.error("Can't get operation.", (Throwable)e);
            return null;
        }
    }
}

