/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import es.idr.teledeteccion.connection.epsg.HSQLDataSource;
import java.io.File;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.Vector;
import org.cresques.cts.CRSUtils;
import org.cresques.cts.ICRSFactory;
import org.cresques.cts.IProjection;
import org.gdal.gdal.gdal;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.SpatialReferenceIdentifyStrategy;
import org.gvsig.crs.repository.EpsgRepository;
import org.gvsig.crs.repository.EpsgRepositoryGT;
import org.gvsig.crs.repository.EsriRepository;
import org.gvsig.crs.repository.EsriRepositoryGT;
import org.gvsig.crs.repository.ICrsRepository;
import org.gvsig.crs.repository.Iau2000Repository;
import org.gvsig.crs.repository.Iau2000RepositoryGT;
import org.gvsig.crs.repository.NoAuthRepository;
import org.gvsig.crs.repository.NoAuthRepositoryGT;
import org.gvsig.crs.repository.UsrRepository;
import org.gvsig.crs.repository.UsrRepositoryGT;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEPSGCustom;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEPSGIterateAll;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEPSGNormalizing;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEsri;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEsriIterateAll;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.IdentifyEsriNormalizing;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrsFactory<E>
implements ICRSFactory {
    private static final Logger logger = LoggerFactory.getLogger(CrsFactory.class);
    static TreeMap data = new TreeMap();
    private static File databaseFolder = null;
    private static File projLibFolder = null;
    private static boolean enableMemoryCache = true;
    private static File epsgDatabaseFile = null;

    public ICrs getCRS(String code) throws CrsException {
        return this.getCRS(code, null, null);
    }

    public ICrs getCRS(String code, String theSourceParams, String theTargetParams) throws CrsException {
        String keyOfCache = this.getKeyOfCache(code, theSourceParams, theTargetParams);
        if (enableMemoryCache && data.containsKey(keyOfCache)) {
            return (ICrs)data.get(keyOfCache);
        }
        String sourceParams = theSourceParams;
        String targetParams = theTargetParams;
        String crsCode = code;
        if (code.indexOf(":", code.indexOf(":") + 1) >= 0) {
            crsCode = code.substring(0, code.indexOf(":", code.indexOf(":") + 1));
            if (!code.contains("@")) {
                crsCode = crsCode.substring(0, crsCode.indexOf(","));
            } else {
                sourceParams = code.substring(code.indexOf("@") + 1, code.lastIndexOf("@"));
                targetParams = code.substring(code.lastIndexOf("@") + 1);
                if (sourceParams.equals("")) {
                    sourceParams = null;
                } else if (targetParams.equals("1")) {
                    targetParams = sourceParams;
                    sourceParams = "";
                }
                if (targetParams.equals("") || targetParams.equals("0")) {
                    targetParams = null;
                }
            }
        }
        ICrs crs = this.getSimpleCRS(crsCode);
        if (sourceParams != null || targetParams != null) {
            crs.setTransformationParams(sourceParams, targetParams);
        }
        if (enableMemoryCache) {
            keyOfCache = this.getKeyOfCache(crsCode, sourceParams, targetParams);
            data.put(keyOfCache, crs);
        }
        return crs;
    }

    private String getKeyOfCache(String code, String theSourceParams, String theTargetParams) {
        String keyOfCache = code;
        if (theSourceParams != null) {
            keyOfCache = keyOfCache + ":proj@" + theSourceParams + "@";
            if (theTargetParams != null) {
                keyOfCache = keyOfCache + theTargetParams;
            }
        }
        return keyOfCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICrs getSimpleCRS(String code) throws CrsException {
        ICrs crs = null;
        ICrsRepository repo = null;
        try {
            String repoId = code.substring(0, code.indexOf(":"));
            String crsCode = code.substring(code.indexOf(":") + 1);
            if (repoId.equals("EPSG")) {
                repo = new EpsgRepositoryGT();
                crs = repo.getCrs(crsCode);
                if (crs == null) {
                    repo = new EpsgRepository();
                    crs = repo.getCrs(crsCode);
                }
            } else if (repoId.equals("IAU2000")) {
                repo = new Iau2000RepositoryGT();
                crs = repo.getCrs(crsCode);
                if (crs == null) {
                    repo = new Iau2000Repository();
                    crs = repo.getCrs(crsCode);
                }
            } else if (repoId.equals("CRS")) {
                repo = new NoAuthRepositoryGT();
                crs = repo.getCrs(crsCode);
                if (crs == null) {
                    repo = new NoAuthRepository();
                    crs = repo.getCrs(crsCode);
                }
            } else if (repoId.equals("ESRI")) {
                repo = new EsriRepositoryGT();
                crs = repo.getCrs(crsCode);
                if (crs == null) {
                    repo = new EsriRepository();
                    crs = repo.getCrs(crsCode);
                }
            } else if (repoId.equals("USR") && (crs = (repo = new UsrRepositoryGT()).getCrs(crsCode)) == null) {
                repo = new UsrRepository();
                crs = repo.getCrs(crsCode);
            }
            if (crs == null) {
                logger.debug("Can't find CRS '" + code + "' in available repositories.");
            } else {
                logger.debug("Found CRS '" + code + "' in repository '" + (repo == null ? "unknow" : repo.getClass().getSimpleName()) + "'.");
            }
            ICrs iCrs = crs;
            return iCrs;
        }
        finally {
            if (repo instanceof Disposable) {
                ((Disposable)repo).dispose();
            }
        }
    }

    public ICrs getCRS(int epsg_code, String code) throws CrsException {
        Crs crs = new Crs(epsg_code, code);
        return crs;
    }

    public ICrs getCRS(int epsg_code, String code, String params) throws CrsException {
        Crs crs = new Crs(epsg_code, code, params);
        return crs;
    }

    public IProjection get(String name) {
        try {
            return this.getCRS(CRSUtils.ogcProjectionToAuthorityAndCode((String)name), null, null);
        }
        catch (CrsException e) {
            logger.error("Can't get CRS name '" + name + "'.", (Throwable)e);
            return null;
        }
    }

    public boolean doesRigurousTransformations() {
        return true;
    }

    public static File getDataBaseFolder() {
        return databaseFolder;
    }

    public static void setDataBaseFolder(File folder) {
        databaseFolder = folder;
    }

    public static File getProjLibFolder() {
        return projLibFolder;
    }

    public static void setProjLibFolder(File folder) {
        projLibFolder = folder;
    }

    public static void setEnableMemoryCacheOfCRS(boolean enableMemoryCache) {
        CrsFactory.enableMemoryCache = enableMemoryCache;
    }

    public static boolean isEnableMemoryCacheOfCRS() {
        return enableMemoryCache;
    }

    public static File getEpsgDatabaseFile() {
        if (epsgDatabaseFile == null) {
            epsgDatabaseFile = new File(CrsFactory.getDataBaseFolder(), "EPSG.sql");
        }
        return epsgDatabaseFile;
    }

    public static void setEpsgDatabaseFile(File databaseFile) {
        epsgDatabaseFile = databaseFile;
        if (!epsgDatabaseFile.isAbsolute()) {
            epsgDatabaseFile = new File(CrsFactory.getDataBaseFolder(), epsgDatabaseFile.getPath());
        }
    }

    public static void initializeDatabase() {
        try {
            HSQLDataSource ds = new HSQLDataSource();
            ds.initializeDatabase();
        }
        catch (SQLException ex) {
            logger.warn("Can't initialize the database.", (Throwable)ex);
        }
    }

    public static void initializeDatabaseInbackground() {
        Thread th = new Thread(new Runnable(){

            public void run() {
                CrsFactory.initializeDatabase();
            }
        }, "EPSG-Initialization");
        th.start();
    }

    public IProjection get(String format, String value) {
        if ("wkt_esri".equalsIgnoreCase(format)) {
            gdal.SetConfigOption((String)"GDAL_FIX_ESRI_WKT", (String)"NO");
            SpatialReference sr = new SpatialReference();
            Vector<String> vector = new Vector<String>();
            vector.add(value);
            try {
                sr.ImportFromESRI(vector);
                sr.Fixup();
            }
            catch (Exception e) {
                logger.debug("Can't import from ESRI WKT.", (Throwable)e);
                return null;
            }
            SpatialReferenceIdentifyStrategy[] identifyStrategies = new SpatialReferenceIdentifyStrategy[]{new IdentifyEsriNormalizing().setAccuracy(0), new IdentifyEsri(), new IdentifyEsriIterateAll().setAccuracy(5), new IdentifyEPSGNormalizing().setAccuracy(5), new IdentifyEPSGIterateAll().setAccuracy(5), new IdentifyEPSGCustom()};
            SpatialReference bestsr = null;
            for (SpatialReferenceIdentifyStrategy identifyStrategy : identifyStrategies) {
                SpatialReference sr2 = identifyStrategy.identify(sr);
                if (sr2 != null) {
                    return new Crs(sr2);
                }
                bestsr = identifyStrategy.getBest();
            }
            return null;
        }
        if ("wkt".equalsIgnoreCase(format)) {
            SpatialReference sr = CrsFactory.getSpatialReferenceFromWKT(value);
            return new Crs(sr);
        }
        if ("proj4".equalsIgnoreCase(format)) {
            SpatialReference sr = new SpatialReference();
            sr.ImportFromProj4(value);
            SpatialReferenceIdentifyStrategy[] identifyStrategies = new SpatialReferenceIdentifyStrategy[]{new IdentifyEPSGNormalizing().setAccuracy(4), new IdentifyEsriNormalizing().setAccuracy(0), new IdentifyEsri(), new IdentifyEPSGIterateAll().setAccuracy(5), new IdentifyEsriIterateAll().setAccuracy(5), new IdentifyEPSGCustom()};
            SpatialReference bestsr = null;
            for (SpatialReferenceIdentifyStrategy identifyStrategy : identifyStrategies) {
                SpatialReference sr2 = identifyStrategy.identify(sr);
                if (sr2 != null) {
                    return new Crs(sr2);
                }
                bestsr = identifyStrategy.getBest();
            }
            return null;
        }
        return null;
    }

    public static SpatialReference getSpatialReferenceFromWKT(String wkt) {
        SpatialReference sr = new SpatialReference();
        sr.ImportFromWkt(wkt);
        SpatialReference sr2 = CrsFactory.getFixedSpatiaReference(sr);
        if (sr2 == null) {
            return sr;
        }
        return sr2;
    }

    private static SpatialReference getFixedSpatiaReference(SpatialReference sr) {
        SpatialReferenceIdentifyStrategy[] identifyStrategies = new SpatialReferenceIdentifyStrategy[]{new IdentifyEPSGNormalizing().setAccuracy(5), new IdentifyEPSGIterateAll().setAccuracy(5), new IdentifyEsriNormalizing().setAccuracy(0), new IdentifyEsri(), new IdentifyEsriIterateAll().setAccuracy(5), new IdentifyEPSGCustom()};
        SpatialReference bestsr = null;
        for (SpatialReferenceIdentifyStrategy identifyStrategy : identifyStrategies) {
            SpatialReference sr2 = identifyStrategy.identify(sr);
            if (sr2 != null) {
                return sr2;
            }
            bestsr = identifyStrategy.getBest();
        }
        return null;
    }

    public String export(String format, IProjection proj) {
        return proj.export(format);
    }

    public static void addCustomCRSIdentifyExpression(String expression, int epsgcode) {
        IdentifyEPSGCustom.addCustomIdentifyExpression(expression, epsgcode);
    }
}

