/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import es.idr.teledeteccion.connection.EpsgConnection;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.Crs;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.repository.ICrsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpsgRepository
implements ICrsRepository {
    private static final Logger logger = LoggerFactory.getLogger(EpsgRepository.class);
    public EpsgConnection connection = new EpsgConnection();

    public ICrs getCrs(String code) {
        Crs crs;
        int epsg_code = Integer.parseInt(code);
        SpatialReference spatialReference = new SpatialReference();
        try {
            spatialReference.ImportFromEPSG(epsg_code);
            crs = new Crs(spatialReference);
        }
        catch (RuntimeException e) {
            logger.warn("Can't create ESPG Crs from " + code + ".", (Throwable)e);
            throw e;
        }
        return crs;
    }
}

